/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.ajax4jsf.template;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.jsf.vpe.ajax4jsf.Activator;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Ajax4JSFMediaOutput
extends VpeAbstractTemplate {
    private static final String IMG_PATH = "mediaOutput/mediaOutput.jpg";
    private static final List<String> SAME_ATTRIBUTES_LIST;

    static {
        String[] sameAttributes = new String[]{"align", "border", "dir", "hspace", "id", "style", "vspace"};
        int i = 0;
        while (i < sameAttributes.length) {
            sameAttributes[i] = sameAttributes[i].toLowerCase();
            ++i;
        }
        SAME_ATTRIBUTES_LIST = Arrays.asList(sameAttributes);
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement mainTag = Ajax4JSFMediaOutput.createMainTag(visualDocument, sourceElement);
        String uriAttribute = sourceElement.hasAttribute("uriAttribute") ? sourceElement.getAttribute("uriAttribute") : "src";
        mainTag.setAttribute(uriAttribute, "file:///" + Ajax4JSFMediaOutput.getAbsoluteResourcePath(IMG_PATH).replace('\\', '/'));
        VisualDomUtil.copyAttributes((Element)sourceElement, (nsIDOMElement)mainTag, SAME_ATTRIBUTES_LIST);
        if (sourceElement.hasAttribute("styleClass")) {
            String styleClass = sourceElement.getAttribute("styleClass");
            mainTag.setAttribute("class", styleClass);
        }
        return new VpeCreationData((nsIDOMNode)mainTag);
    }

    public static String getAbsoluteResourcePath(String resourcePathInPlugin) {
        String pluginPath = Activator.getPluginResourcePath();
        Path pluginFile = new Path(pluginPath);
        File file = pluginFile.append(resourcePathInPlugin).toFile();
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        throw new RuntimeException("Can't get path for " + resourcePathInPlugin);
    }

    private static nsIDOMElement createMainTag(nsIDOMDocument visualDocument, Element sourceElement) {
        String element = sourceElement.hasAttribute("element") ? sourceElement.getAttribute("element") : "img";
        nsIDOMElement mainTag = visualDocument.createElement(element);
        return mainTag;
    }
}

