/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model.handlers;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.AbstractWebFileImpl;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.seam.pages.xml.SeamPagesXMLMessages;
import org.jboss.tools.seam.pages.xml.model.SeamPagesConstants;
import org.jboss.tools.seam.pages.xml.model.handlers.AddViewSupport;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramHelper;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;

public class RenameViewSupport
extends SpecialWizardSupport
implements SeamPagesConstants {
    String initialPath;
    XModelObject page;
    ReferenceObject item;
    protected DefaultWizardDataValidator viewValidator = new ViewValidator();

    public boolean isEnabled(XModelObject target) {
        if (!super.isEnabled(target)) {
            return false;
        }
        if (!"SeamPagesDiagramItem".equals(target.getModelEntity().getName())) {
            return false;
        }
        return !"exception".equals(target.getAttributeValue("type"));
    }

    public void reset() {
        this.initItem();
        this.initialPath = this.item.getAttributeValue("path");
        this.initialPath = AddViewSupport.revalidatePath(this.initialPath);
        this.page = SeamPagesDiagramHelper.isPattern(this.initialPath) ? null : this.getTarget().getModel().getByPath(this.initialPath);
        this.setAttributeValue(0, "view id", this.initialPath);
    }

    void initItem() {
        String entity = this.getTarget().getModelEntity().getName();
        this.item = null;
        if ("SeamPagesDiagramItem".equals(entity)) {
            this.item = (ReferenceObject)this.getTarget();
        }
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL, HELP};
    }

    void execute() throws XModelException {
        block6: {
            Properties p = this.extractStepData(0);
            String path = AddViewSupport.revalidatePath(p.getProperty("view id"));
            if (this.initialPath.equals(path)) {
                return;
            }
            SeamPagesDiagramHelper h = SeamPagesDiagramHelper.getHelper(SeamPagesDiagramStructureHelper.instance.getDiagram((XModelObject)this.item));
            h.addUpdateLock(this);
            try {
                RenameViewSupport.replace(this.item, this.initialPath, path);
                if (this.page == null || !"true".equals(p.getProperty("rename file")) || !this.isFieldEditorEnabled(0, "rename file", p)) break block6;
                try {
                    RenameViewSupport.renameFile(this.page, path);
                }
                catch (CoreException e) {
                    throw new XModelException((Throwable)e);
                }
            }
            finally {
                h.removeUpdateLock(this);
                h.updateDiagram();
            }
        }
    }

    public boolean isActionEnabled(String name) {
        if (FINISH.equals(name)) {
            String path = this.getAttributeValue(0, "view id");
            if (this.initialPath.equals(path = AddViewSupport.revalidatePath(path))) {
                return false;
            }
        }
        return true;
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        if (name.equals("rename file")) {
            if (this.page == null) {
                return false;
            }
            String path = AddViewSupport.revalidatePath(values.getProperty("view id"));
            if (path.equals(this.initialPath)) {
                return false;
            }
            if (SeamPagesDiagramHelper.isPattern(path)) {
                return false;
            }
            XModelObject page2 = this.getTarget().getModel().getByPath(path);
            if (page2 != null) {
                return false;
            }
        }
        return true;
    }

    public static void replace(ReferenceObject group, String oldPath, String newPath) throws XModelException {
        String ppi;
        String pp = SeamPagesDiagramHelper.toNavigationRulePathPart(newPath);
        boolean isPattern = SeamPagesDiagramHelper.isPattern(newPath);
        XModel model = group.getModel();
        XModelObject process = group.getParent();
        AbstractWebFileImpl cfr_ignored_0 = (AbstractWebFileImpl)process.getParent();
        XModelObject rs = group.getReference();
        if (rs != null) {
            model.changeObjectAttribute(rs, "view id", newPath);
        }
        if (process.getChildByPath(pp) == null) {
            model.changeObjectAttribute((XModelObject)group, "name", pp);
            model.changeObjectAttribute((XModelObject)group, "path", newPath);
        } else if (isPattern && rs != null) {
            rs.getAttributeValue("index");
            ppi = pp;
            group.setAttributeValue("path", newPath);
            if (process.getChildByPath(ppi) == null) {
                model.changeObjectAttribute((XModelObject)group, "name", ppi);
            }
        } else if (isPattern && rs == null) {
            ppi = pp;
            model.changeObjectAttribute((XModelObject)group, "path", newPath);
            model.changeObjectAttribute((XModelObject)group, "name", ppi);
        } else if (!isPattern && rs == null) {
            DefaultRemoveHandler.removeFromParent((XModelObject)group);
        }
        XModelObject[] gs = process.getChildren("SeamPagesDiagramItem");
        int i = 0;
        while (i < gs.length) {
            XModelObject[] os = gs[i].getChildren("SeamPagesDiagramItemOutput");
            int k = 0;
            while (k < os.length) {
                ReferenceObject output;
                XModelObject c;
                if (oldPath.equals(os[k].getAttributeValue("path")) && (c = (output = (ReferenceObject)os[k]).getReference()) != null) {
                    model.changeObjectAttribute(c, "view id", newPath);
                }
                ++k;
            }
            ++i;
        }
    }

    public static void renameFile(XModelObject page, String path) throws XModelException, CoreException {
        IResource r = (IResource)page.getAdapter(IResource.class);
        String initialPath = XModelObjectLoaderUtil.getResourcePath((XModelObject)page);
        String p = r.getFullPath().toString();
        if (!p.toLowerCase().endsWith(initialPath.toLowerCase())) {
            return;
        }
        p = String.valueOf(p.substring(0, p.length() - initialPath.length())) + path;
        Path np = new Path(p);
        RenameViewSupport.provideParent((IResource)r.getWorkspace().getRoot().getFile((IPath)np));
        r.move((IPath)np, true, null);
        page.getModel().update();
    }

    public static void provideParent(IResource resource) throws XModelException, CoreException {
        IContainer parent = resource.getParent();
        if (parent.exists()) {
            return;
        }
        IFolder folder = resource.getWorkspace().getRoot().getFolder(parent.getFullPath());
        RenameViewSupport.provideParent((IResource)folder);
        folder.create(true, true, null);
    }

    public WizardDataValidator getValidator(int step) {
        this.viewValidator.setSupport((SpecialWizardSupport)this, step);
        return this.viewValidator;
    }

    class ViewValidator
    extends DefaultWizardDataValidator {
        ViewValidator() {
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String path = data.getProperty("view id");
            if (!AddViewSupport.isCorrectPath(path)) {
                this.message = SeamPagesXMLMessages.ATTRIBUTE_VIEW_ID_IS_NOT_CORRECT;
            }
            if (this.message != null) {
                return;
            }
        }
    }
}

