/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model.helpers;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.jst.web.model.helpers.WebProcessUpdateHelper;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramHelper;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesUpdateManager;
import org.jboss.tools.seam.pages.xml.model.impl.SeamPagesDiagramImpl;

public class SeamPagesUpdateHelper
implements WebProcessUpdateHelper {
    private XModelObject config;
    private SeamPagesDiagramImpl diagram;
    private SeamPagesDiagramHelper helper;

    public SeamPagesUpdateHelper(SeamPagesDiagramImpl diagram) {
        this.diagram = diagram;
        this.helper = diagram.getHelper();
        this.config = diagram.getParent();
        SeamPagesUpdateManager.getInstance(diagram.getModel()).register(this.config.getPath(), this);
    }

    public void unregister() {
        SeamPagesUpdateManager.getInstance(this.diagram.getModel()).unregister(this.config.getPath(), this);
    }

    public boolean isActive() {
        return this.diagram.isActive();
    }

    public void nodeChanged(XModelTreeEvent event, String localPath) {
        if (localPath == null || localPath.length() == 0) {
            return;
        }
        if (localPath.startsWith("Pages") || localPath.startsWith("Exceptions")) {
            this.helper.updateDiagram();
        }
    }

    public void structureChanged(XModelTreeEvent event, String localPath) {
        if (localPath == null) {
            return;
        }
        if (localPath.startsWith("Pages") || localPath.startsWith("Exceptions")) {
            this.helper.updateDiagram();
            if (!this.helper.isUpdateLocked()) {
                this.helper.autolayout();
            }
        }
    }
}

