/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.xml.components.model;

import java.io.IOException;
import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XMLRecognizerContext;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.seam.xml.SeamXMLPlugin;
import org.jboss.tools.seam.xml.components.model.SeamComponentConstants;

public class SeamComponentsEntityRecognizer
implements EntityRecognizer,
SeamComponentConstants {
    static int NONE;
    static int COM;
    static int ORG;
    static String COM_SCHEMA;
    static String ORG_SCHEMA;

    static {
        try {
            Class<SeamComponentsEntityRecognizer> c = SeamComponentsEntityRecognizer.class;
            XMLEntityResolver.registerPublicEntity((String)"-//JBoss/Seam Component Configuration DTD 1.1//EN", c, (String)"/meta/components-1.1.dtd");
        }
        catch (IOException e) {
            SeamXMLPlugin.log(e);
        }
        NONE = 0;
        COM = 1;
        ORG = 2;
        COM_SCHEMA = "\"http://jboss.com/products/seam/components\"";
        ORG_SCHEMA = "\"http://jboss.org/schema/seam/components\"";
    }

    public String getEntityName(EntityRecognizerContext context) {
        String body = context.getBody();
        if (body == null) {
            return null;
        }
        XMLRecognizerContext xml = context.getXMLContext();
        if (xml.isDTD()) {
            String publicId = xml.getPublicId();
            if ("-//JBoss/Seam Component Configuration DTD 1.1//EN".equals(publicId)) {
                return "FileSeamComponents11";
            }
            return null;
        }
        int isSingleComponent = this.isSingleComponent(body);
        if (this.isComponentsSchema(body) == NONE && isSingleComponent == NONE) {
            return null;
        }
        int isMultiComponent = this.isMultiComponent(body);
        int i = body.indexOf("xsi:schemaLocation");
        if (i < 0) {
            return null;
        }
        int j = body.indexOf("\"", i);
        if (j < 0) {
            return null;
        }
        int k = body.indexOf("\"", j + 1);
        if (k < 0) {
            return null;
        }
        String schemaLocation = body.substring(j + 1, k);
        int i12 = schemaLocation.indexOf("1.2");
        if (i12 >= 0) {
            if (isSingleComponent == COM) {
                return "FileSeamComponent12";
            }
            if (isMultiComponent == COM) {
                return "FileSeamComponents12";
            }
            return null;
        }
        int i20 = schemaLocation.indexOf("-2.0");
        int i21 = schemaLocation.indexOf("-2.1");
        int i22 = schemaLocation.indexOf("-2.2");
        int i23 = schemaLocation.indexOf("-2.");
        if (i21 < 0 && i20 < 0 && i22 < 0 && i23 < 0) {
            i23 = 0;
        }
        if (i23 >= 0) {
            if (isSingleComponent == COM) {
                if (i20 >= 0) {
                    return "FileSeamComponent20";
                }
                if (i21 >= 0) {
                    return "FileSeamComponent21";
                }
                if (i22 >= 0) {
                    return "FileSeamComponent22";
                }
                return "FileSeamComponent23";
            }
            if (isMultiComponent == COM) {
                if (i20 >= 0) {
                    return "FileSeamComponents20";
                }
                if (i21 >= 0) {
                    return "FileSeamComponents21";
                }
                if (i22 >= 0) {
                    return "FileSeamComponents22";
                }
                return "FileSeamComponents23";
            }
            if (isSingleComponent == ORG && i23 >= 0) {
                return "FileSeamComponent230";
            }
            if (isMultiComponent == ORG && i23 >= 0) {
                return "FileSeamComponents230";
            }
        }
        return null;
    }

    private int isComponentsSchema(String body) {
        int i = body.indexOf("<components");
        if (i < 0) {
            return NONE;
        }
        int j = body.indexOf(">", i);
        if (j < 0) {
            return NONE;
        }
        String s = body.substring(i, j);
        return s.indexOf(COM_SCHEMA) > 0 ? COM : (s.indexOf(ORG_SCHEMA) > 0 ? ORG : NONE);
    }

    private int isMultiComponent(String body) {
        int i = body.indexOf("<components");
        if (i < 0) {
            return NONE;
        }
        int j = body.indexOf(">", i);
        if (j < 0) {
            return NONE;
        }
        String s = body.substring(i, j);
        return s.indexOf(COM_SCHEMA) > 0 ? COM : (s.indexOf(ORG_SCHEMA) > 0 ? ORG : NONE);
    }

    private int isSingleComponent(String body) {
        int i = body.indexOf("<component");
        int is = body.indexOf("<components");
        if (i < 0 || is >= 0) {
            return NONE;
        }
        int j = body.indexOf(">", i);
        if (j < 0) {
            return NONE;
        }
        String s = body.substring(i, j);
        return s.indexOf(COM_SCHEMA) > 0 ? COM : (s.indexOf(ORG_SCHEMA) > 0 ? ORG : NONE);
    }
}

