/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.jboss.tools.cdi.core.test.tck.TCKTest;
import org.jboss.tools.common.base.test.contentassist.CATestUtil;
import org.jboss.tools.jst.jsp.test.ca.ContentAssistantTestCase;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.AutoContentAssistantProposal;

public class CAELProposalFilteringTest
extends TCKTest {
    private IProject project = null;
    private ContentAssistantTestCase caTest = new ContentAssistantTestCase();
    private static final String JSP_PAGE_NAME = "WebContent/test.jsp";
    private static final String XHTML_PAGE_NAME = "WebContent/elValidation1.xhtml";

    public void setUp() {
        this.project = this.findTestProject();
        this.caTest.setProject(this.project);
    }

    public void testCAELProposalFilteringInJSP() {
        this.caTest.openEditor(JSP_PAGE_NAME);
        try {
            this.doCAELProposalFilteringTest(JSP_PAGE_NAME, "rendered=\"#{(game.", "value : String - Game", "value");
            this.doCAELProposalFilteringTest(JSP_PAGE_NAME, "value=\"#{sheep.", "name : String - Sheep", "name");
        }
        finally {
            this.caTest.closeEditor();
        }
    }

    public void testCAELProposalFilteringInXHTML() {
        this.caTest.openEditor(XHTML_PAGE_NAME);
        try {
            this.doCAELProposalFilteringTest(XHTML_PAGE_NAME, "value=\"#{sheep.", "name : String - Sheep", "name");
        }
        finally {
            this.caTest.closeEditor();
        }
    }

    private void doCAELProposalFilteringTest(String pageName, String prefix, String proposalToApply, String compareString) {
        IDocument document = this.caTest.getDocument();
        String documentContent = document.get();
        int start = documentContent == null ? -1 : documentContent.indexOf(prefix);
        CAELProposalFilteringTest.assertFalse((String)("Required text '" + prefix + "' not found in document"), (start == -1 ? 1 : 0) != 0);
        int offsetToTest = start + prefix.length();
        String documentContentToCompare = String.valueOf(documentContent.substring(0, start + prefix.length())) + compareString + documentContent.substring(start + prefix.length());
        List res = CATestUtil.collectProposals((IContentAssistant)this.caTest.getContentAssistant(), (ITextViewer)this.caTest.getViewer(), (int)offsetToTest);
        CAELProposalFilteringTest.assertTrue((String)"Content Assistant returned no proposals", (res != null && res.size() > 0 ? 1 : 0) != 0);
        boolean bPropoosalToApplyFound = false;
        for (ICompletionProposal p : res) {
            AutoContentAssistantProposal proposal;
            String proposalString;
            if (!(p instanceof AutoContentAssistantProposal) || !proposalToApply.equals(proposalString = (proposal = (AutoContentAssistantProposal)p).getDisplayString())) continue;
            if (!bPropoosalToApplyFound) {
                bPropoosalToApplyFound = true;
                proposal.apply(document);
                continue;
            }
            CAELProposalFilteringTest.fail((String)("Duplicate proposal '" + proposalToApply + "' found in CA Proposal List"));
        }
        CAELProposalFilteringTest.assertTrue((String)"The proposal to apply not found.", (boolean)bPropoosalToApplyFound);
        String documentUpdatedContent = document.get();
        CAELProposalFilteringTest.assertTrue((String)"The proposal replacement is failed.", (boolean)documentContentToCompare.equals(documentUpdatedContent));
    }
}

