/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.test.tck.TCKTest;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.EventBean;
import org.jboss.tools.cdi.internal.core.impl.InjectionPointField;
import org.jboss.tools.cdi.internal.core.impl.InjectionPointParameter;
import org.jboss.tools.cdi.internal.core.impl.ObserverMethod;
import org.jboss.tools.cdi.ui.search.CDIBeanQueryParticipant;
import org.jboss.tools.cdi.ui.search.CDIMatch;
import org.jboss.tools.cdi.ui.search.InjectionPointQueryParticipant;
import org.jboss.tools.cdi.ui.test.testmodel.CDIBean;
import org.jboss.tools.cdi.ui.test.testmodel.CDIProject;
import org.jboss.tools.cdi.ui.test.testmodel.JavaSearchScope;
import org.jboss.tools.common.EclipseUtil;

public class CDISearchParticipantTest
extends TCKTest {
    private static final int FIELD_SEARCH = 1;
    private static final int METHOD_SEARCH = 2;
    private static final int TYPE_SEARCH = 3;
    private static final int PARAMETER_SEARCH = 4;

    private void testSearchParticipant(String fileName, int searchType, String elementName, String parameterName, IQueryParticipant participant, List<MatchStructure> matches) {
        IFile file = this.tckProject.getFile(fileName);
        CDISearchParticipantTest.assertNotNull((String)("File - " + fileName + " not found"), (Object)file);
        try {
            ICompilationUnit compilationUnit = EclipseUtil.getCompilationUnit((IFile)file);
            CDISearchParticipantTest.assertNotNull((String)"CompilationUnit not found", (Object)compilationUnit);
            IField element = null;
            IType type = compilationUnit.findPrimaryType();
            if (searchType == 1) {
                element = type.getField(elementName);
            } else if (searchType == 2) {
                element = this.getMethod(type, elementName);
            } else if (searchType == 3) {
                element = type;
            } else if (searchType == 4) {
                IMethod method = this.getMethod(type, elementName);
                element = CDIUtil.getParameter((IMethod)method, (String)parameterName);
            }
            if (element != null) {
                CDISearchRequestor requestor = new CDISearchRequestor();
                JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
                IJavaSearchScope scope = factory.createWorkspaceScope(true);
                String description = factory.getWorkspaceScopeDescription(true);
                ElementQuerySpecification specification = new ElementQuerySpecification((IJavaElement)element, 2, scope, description);
                participant.search((ISearchRequestor)requestor, (QuerySpecification)specification, (IProgressMonitor)new NullProgressMonitor());
                List<Match> matchesForCheck = requestor.getMatches();
                this.checkMatches(matchesForCheck, matches);
            } else {
                CDISearchParticipantTest.fail((String)"Java Element not found");
            }
        }
        catch (CoreException coreException) {
            CDISearchParticipantTest.fail((String)"Core exception");
        }
    }

    private IMethod getMethod(IType type, String name) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(name)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private void checkMatches(List<Match> matchesForCheck, List<MatchStructure> matchList) throws CoreException {
        for (Match match : matchesForCheck) {
            CDISearchParticipantTest.assertTrue((String)"Match must be CDIMatch", (boolean)(match instanceof CDIMatch));
            MatchStructure ms = this.findMatch(matchList, (CDIMatch)match);
            CDISearchParticipantTest.assertNotNull((String)("Unexpected match found (class - " + ((CDIMatch)match).getCDIElement().getClass() + " name - " + ((CDIMatch)match).getLabel() + ")"), (Object)ms);
            ms.checked = true;
        }
        for (MatchStructure ms : matchList) {
            CDISearchParticipantTest.assertTrue((String)("Match not found (class - " + ms.type + " name - " + ms.name), (boolean)ms.checked);
        }
    }

    protected MatchStructure findMatch(List<MatchStructure> matchList, CDIMatch match) {
        for (MatchStructure ms : matchList) {
            if (ms.checked || !ms.type.equals(match.getCDIElement().getClass()) || !ms.name.equals(match.getLabel())) continue;
            return ms;
        }
        return null;
    }

    public void testInjectionPointQueryParticipant1() {
        ArrayList<MatchStructure> matches = new ArrayList<MatchStructure>();
        matches.add(new MatchStructure(ClassBean.class, "BeanWithInjectionPointMetadata"));
        this.testSearchParticipant("JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/FieldInjectionPointBean.java", 1, "injectedBean", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipant2() {
        ArrayList<MatchStructure> matches = new ArrayList<MatchStructure>();
        matches.add(new MatchStructure(ClassBean.class, "BeanWithInjectionPointMetadata"));
        this.testSearchParticipant("JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/ConstructorInjectionPointBean.java", 4, "ConstructorInjectionPointBean", "injectedBean", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipant3() {
        ArrayList<MatchStructure> matches = new ArrayList<MatchStructure>();
        matches.add(new MatchStructure(EventBean.class, "Event"));
        matches.add(new MatchStructure(ObserverMethod.class, "EventTypeFamilyObserver.observeObject()"));
        matches.add(new MatchStructure(ObserverMethod.class, "GoldenRetriever.anObserverMethod()"));
        matches.add(new MatchStructure(ObserverMethod.class, "ClassFragmentLogger.addEntry()"));
        this.testSearchParticipant("JavaSource/org/jboss/jsr299/tck/tests/jbt/search/EventEmitter.java", 1, "myEvent", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipant4() {
        ArrayList<MatchStructure> matches = new ArrayList<MatchStructure>();
        matches.add(new MatchStructure(InjectionPointField.class, "EventEmitter.myEvent"));
        matches.add(new MatchStructure(InjectionPointField.class, "EventEmitter.myEventWithAnyAndNonRuntimeBindingType"));
        matches.add(new MatchStructure(InjectionPointField.class, "EventEmitter.myEventWithOnlyNonRuntimeBindingType"));
        this.testSearchParticipant("JavaSource/org/jboss/jsr299/tck/tests/jbt/search/GoldenRetriever.java", 2, "anObserverMethod", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipant() {
        ArrayList<MatchStructure> matches = new ArrayList<MatchStructure>();
        matches.add(new MatchStructure(InjectionPointField.class, "FieldInjectionPointBean.injectedBean"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedStereotypedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedStereotypedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "TransientFieldInjectionPointBean.injectedBean"));
        matches.add(new MatchStructure(InjectionPointField.class, "SpecializingDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "ObserverMethodInDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "ObjectInjection.object"));
        matches.add(new MatchStructure(InjectionPointParameter.class, "ConstructorInjectionPointBean.ConstructorInjectionPointBean(BeanWithInjectionPointMetadata injectedBean)"));
        matches.add(new MatchStructure(InjectionPointParameter.class, "MethodInjectionPointBean.methodWithInjectedMetadata(BeanWithInjectionPointMetadata injectedBean)"));
        this.testSearchParticipant("JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/BeanWithInjectionPointMetadata.java", 3, "BeanWithInjectionPointMetadata", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipantAtProducerField() {
        ArrayList<MatchStructure> matches = new ArrayList<MatchStructure>();
        matches.add(new MatchStructure(InjectionPointField.class, "Zoo.p"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedStereotypedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedStereotypedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "SpecializingDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "ObserverMethodInDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "ObjectInjection.object"));
        this.testSearchParticipant("JavaSource/org/jboss/jsr299/tck/tests/lookup/typesafe/resolution/Zoo.java", 1, "petShop", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipantAtProducerMethod() {
        ArrayList<MatchStructure> matches = new ArrayList<MatchStructure>();
        matches.add(new MatchStructure(InjectionPointField.class, "Zoo.p"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedStereotypedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "NamedStereotypedDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "SpecializingDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "ObserverMethodInDecoratorBroken.logger"));
        matches.add(new MatchStructure(InjectionPointField.class, "ObjectInjection.object"));
        this.testSearchParticipant("JavaSource/org/jboss/jsr299/tck/tests/lookup/typesafe/resolution/Zoo.java", 2, "getPetShop", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipantWithNullResource() throws CoreException {
        CDIProject project = CDIProject.defaultCDIProject;
        CDIBean bean = new CDIBean(project, "org.test.CustomBean");
        bean.makeResourseNull();
        Collection qualifiers = bean.getQualifiers();
        IMethod method = ((IQualifier)qualifiers.iterator().next()).getSourceType().getMethods()[0];
        InjectionPointQueryParticipant participant = new InjectionPointQueryParticipant();
        CDISearchRequestor requestor = new CDISearchRequestor();
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        JavaSearchScope scope = new JavaSearchScope();
        String description = factory.getWorkspaceScopeDescription(true);
        ElementQuerySpecification specification = new ElementQuerySpecification((IJavaElement)method, 2, (IJavaSearchScope)scope, description);
        participant.search((ISearchRequestor)requestor, (QuerySpecification)specification, (IProgressMonitor)new NullProgressMonitor());
    }

    class CDISearchRequestor
    implements ISearchRequestor {
        ArrayList<Match> matches = new ArrayList();

        CDISearchRequestor() {
        }

        public void reportMatch(Match match) {
            this.matches.add(match);
        }

        public List<Match> getMatches() {
            return this.matches;
        }
    }

    class MatchStructure {
        Class<? extends ICDIElement> type;
        String name;
        boolean checked;

        public MatchStructure(Class<? extends ICDIElement> type, String name) {
            this.type = type;
            this.name = name;
            this.checked = false;
        }
    }
}

