/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.search;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.InjectionPointField;
import org.jboss.tools.cdi.internal.core.impl.InjectionPointParameter;
import org.jboss.tools.cdi.ui.search.CDIBeanQueryParticipant;
import org.jboss.tools.cdi.ui.search.CDIMatch;
import org.jboss.tools.cdi.ui.search.InjectionPointQueryParticipant;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.base.test.kb.QueryParticipantTestUtils;
import org.jboss.tools.jst.web.kb.refactoring.ELReferencesQueryParticipant;

public class FiveDependentProjectsSearchParticipantTest
extends TestCase {
    IProject project1 = null;
    IProject project2 = null;
    IProject project3 = null;
    IProject project4 = null;
    IProject project5 = null;
    private static final int FIELD_SEARCH = 1;
    private static final int METHOD_SEARCH = 2;
    private static final int TYPE_SEARCH = 3;
    private static final int PARAMETER_SEARCH = 4;

    protected void setUp() throws Exception {
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("CDITest1");
        this.project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("CDITest2");
        this.project3 = ResourcesPlugin.getWorkspace().getRoot().getProject("CDITest3");
        this.project4 = ResourcesPlugin.getWorkspace().getRoot().getProject("CDITest4");
        this.project5 = ResourcesPlugin.getWorkspace().getRoot().getProject("CDITest5");
    }

    private void testSearchParticipant(IProject project, String fileName, int searchType, String elementName, String parameterName, IQueryParticipant participant, List<MStructure> matches) {
        IFile file = project.getFile(fileName);
        FiveDependentProjectsSearchParticipantTest.assertNotNull((String)("File - " + fileName + " not found"), (Object)file);
        try {
            ICompilationUnit compilationUnit = EclipseUtil.getCompilationUnit((IFile)file);
            FiveDependentProjectsSearchParticipantTest.assertNotNull((String)"CompilationUnit not found", (Object)compilationUnit);
            IField element = null;
            IType type = compilationUnit.findPrimaryType();
            if (searchType == 1) {
                element = type.getField(elementName);
            } else if (searchType == 2) {
                element = this.getMethod(type, elementName);
            } else if (searchType == 3) {
                element = type;
            } else if (searchType == 4) {
                IMethod method = this.getMethod(type, elementName);
                element = CDIUtil.getParameter((IMethod)method, (String)parameterName);
            }
            if (element != null) {
                CDISearchRequestor requestor = new CDISearchRequestor();
                JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
                IJavaSearchScope scope = factory.createWorkspaceScope(true);
                String description = factory.getWorkspaceScopeDescription(true);
                ElementQuerySpecification specification = new ElementQuerySpecification((IJavaElement)element, 2, scope, description);
                participant.search((ISearchRequestor)requestor, (QuerySpecification)specification, (IProgressMonitor)new NullProgressMonitor());
                List<Match> matchesForCheck = requestor.getMatches();
                this.checkMatches(matchesForCheck, matches);
            } else {
                FiveDependentProjectsSearchParticipantTest.fail((String)"Java Element not found");
            }
        }
        catch (CoreException coreException) {
            FiveDependentProjectsSearchParticipantTest.fail((String)"Core exception");
        }
    }

    private IMethod getMethod(IType type, String name) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(name)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private void checkMatches(List<Match> matchesForCheck, List<MStructure> matchList) throws CoreException {
        for (Match match : matchesForCheck) {
            FiveDependentProjectsSearchParticipantTest.assertTrue((String)"Match must be CDIMatch", (boolean)(match instanceof CDIMatch));
            MStructure ms = this.findMatch(matchList, (CDIMatch)match);
            FiveDependentProjectsSearchParticipantTest.assertNotNull((String)("Unexpected match found (class - " + ((CDIMatch)match).getCDIElement().getClass() + " name - " + ((CDIMatch)match).getLabel() + ")"), (Object)ms);
            ms.checked = true;
        }
        for (MStructure ms : matchList) {
            FiveDependentProjectsSearchParticipantTest.assertTrue((String)("Match not found (class - " + ms.type + " name - " + ms.name), (boolean)ms.checked);
        }
    }

    protected MStructure findMatch(List<MStructure> matchList, CDIMatch match) {
        for (MStructure ms : matchList) {
            if (ms.checked || !ms.type.equals(match.getCDIElement().getClass()) || !ms.name.equals(match.getLabel())) continue;
            return ms;
        }
        return null;
    }

    public void testInjectionPointQueryParticipantInProject1() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(ClassBean.class, "Base1"));
        this.testSearchParticipant(this.project1, "src/cdi/test/search1/Bean1.java", 1, "field1", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipantInProject2() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(ClassBean.class, "Base1"));
        matches.add(new MStructure(ClassBean.class, "Base2"));
        this.testSearchParticipant(this.project2, "src/cdi/test/search2/Bean2.java", 1, "field2", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipantInProject3() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(ClassBean.class, "Base1"));
        matches.add(new MStructure(ClassBean.class, "Base2"));
        matches.add(new MStructure(ClassBean.class, "Base3"));
        this.testSearchParticipant(this.project3, "src/cdi/test/search3/Bean3.java", 1, "field3", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipantInProject4() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(ClassBean.class, "Base1"));
        matches.add(new MStructure(ClassBean.class, "Base2"));
        matches.add(new MStructure(ClassBean.class, "Base4"));
        this.testSearchParticipant(this.project4, "src/cdi/test/search4/Bean4.java", 1, "field4", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testInjectionPointQueryParticipantInProject5() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(ClassBean.class, "Base1"));
        matches.add(new MStructure(ClassBean.class, "Base2"));
        matches.add(new MStructure(ClassBean.class, "Base4"));
        matches.add(new MStructure(ClassBean.class, "Base5"));
        this.testSearchParticipant(this.project5, "src/cdi/test/search5/Bean5.java", 1, "field5", "", (IQueryParticipant)new InjectionPointQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipantInProject1() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(InjectionPointField.class, "Bean1.field1"));
        matches.add(new MStructure(InjectionPointField.class, "Bean2.field2"));
        matches.add(new MStructure(InjectionPointField.class, "Bean3.field3"));
        matches.add(new MStructure(InjectionPointField.class, "Bean4.field4"));
        matches.add(new MStructure(InjectionPointField.class, "Bean5.field5"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean1.method_1(BaseDecoratedInterface param1)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean2.method_2(BaseDecoratedInterface param2)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean3.method_3(BaseDecoratedInterface param3)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean4.method_4(BaseDecoratedInterface param4)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean5.method_5(BaseDecoratedInterface param5)"));
        this.testSearchParticipant(this.project1, "src/cdi/test/search1/Base1.java", 3, "Base1", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipantInProject2() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(InjectionPointField.class, "Bean2.field2"));
        matches.add(new MStructure(InjectionPointField.class, "Bean3.field3"));
        matches.add(new MStructure(InjectionPointField.class, "Bean4.field4"));
        matches.add(new MStructure(InjectionPointField.class, "Bean5.field5"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean2.method_2(BaseDecoratedInterface param2)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean3.method_3(BaseDecoratedInterface param3)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean4.method_4(BaseDecoratedInterface param4)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean5.method_5(BaseDecoratedInterface param5)"));
        this.testSearchParticipant(this.project2, "src/cdi/test/search2/Base2.java", 3, "Base2", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipantInProject3() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(InjectionPointField.class, "Bean3.field3"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean3.method_3(BaseDecoratedInterface param3)"));
        this.testSearchParticipant(this.project3, "src/cdi/test/search3/Base3.java", 3, "Base3", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipantInProject4() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(InjectionPointField.class, "Bean4.field4"));
        matches.add(new MStructure(InjectionPointField.class, "Bean5.field5"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean4.method_4(BaseDecoratedInterface param4)"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean5.method_5(BaseDecoratedInterface param5)"));
        this.testSearchParticipant(this.project4, "src/cdi/test/search4/Base4.java", 3, "Base4", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testCDIBeanQueryParticipantInProject5() {
        ArrayList<MStructure> matches = new ArrayList<MStructure>();
        matches.add(new MStructure(InjectionPointField.class, "Bean5.field5"));
        matches.add(new MStructure(InjectionPointParameter.class, "Bean5.method_5(BaseDecoratedInterface param5)"));
        this.testSearchParticipant(this.project5, "src/cdi/test/search5/Base5.java", 3, "Base5", "", (IQueryParticipant)new CDIBeanQueryParticipant(), matches);
    }

    public void testELReferencesQueryParticipantForNamedBean() throws CoreException {
        ArrayList<QueryParticipantTestUtils.MatchStructure> matches = new ArrayList<QueryParticipantTestUtils.MatchStructure>();
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest2/src/cdi/test/search2/Check2.java", "customer"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest3/src/cdi/test/search3/Check3.java", "customer"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest4/src/cdi/test/search4/Check4.java", "customer"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest5/src/cdi/test/search5/Check5.java", "customer"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest2/WebContent/test.jsp", "customer"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest3/WebContent/test.jsp", "customer"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest4/WebContent/test.jsp", "customer"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/CDITest5/WebContent/test.jsp", "customer"));
        QueryParticipantTestUtils.testSearchParticipant((IProject)this.project2, (String)"src/cdi/test/search2/Bean2.java", (int)3, (String)"customer", (String)"", (IQueryParticipant)new ELReferencesQueryParticipant(), matches);
    }

    class CDISearchRequestor
    implements ISearchRequestor {
        ArrayList<Match> matches = new ArrayList();

        CDISearchRequestor() {
        }

        public void reportMatch(Match match) {
            this.matches.add(match);
        }

        public List<Match> getMatches() {
            return this.matches;
        }
    }

    class MStructure {
        Class<? extends ICDIElement> type;
        String name;
        boolean checked;

        public MStructure(Class<? extends ICDIElement> type, String name) {
            this.type = type;
            this.name = name;
            this.checked = false;
        }
    }
}

