/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.validation.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.Annotation;
import org.jboss.tools.cdi.core.test.tck.TCKTest;
import org.jboss.tools.common.base.test.validation.java.BaseAsYouTypeInJavaValidationTest;

public class CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest
extends TCKTest {
    private static final String PAGE_NAME = "JavaSource/org/jboss/jsr299/tck/tests/jbt/validation/Bean_Broken.java";
    private static final String EL_VALIDATOR_PROBLEM_TYPE = "org.jboss.tools.jst.web.kb.elproblem";
    private BaseAsYouTypeInJavaValidationTest baseTest = null;
    protected IProject project;
    private static final String TEXT_LINE_TO_REPLACE = "String s2 = \"#{string.ss}\";";
    private static final int SHIFT_FROM_THE_END = -2;
    private static final String TEXT_TO_INSERT = " ";
    private static final String TEXT_LINE_TO_CHECK = "String s = \"#{string.ss}\";";
    private static final String TEXT_METHOD_BODY = "return \"\";";
    private static final String ERROR_MESSAGE = "\"ss\" cannot be resolved";

    public void setUp() throws Exception {
        this.project = this.findTestProject();
        if (this.baseTest == null) {
            this.baseTest = new BaseAsYouTypeInJavaValidationTest(this.project, EL_VALIDATOR_PROBLEM_TYPE);
        }
    }

    public void testAsYouTypeCDIAndELValidatorsMassagesProcessing() throws BadLocationException, CoreException {
        CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertNotNull((String)("Test project '" + this.getProjectNameProvider().getMainProjectName() + "' is not prepared"), (Object)this.project);
        this.baseTest.openEditor(PAGE_NAME);
        try {
            String documentContent = this.baseTest.getDocument().get();
            int start = documentContent == null ? -1 : documentContent.indexOf(TEXT_LINE_TO_REPLACE, 0);
            int length = TEXT_LINE_TO_REPLACE.length();
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertFalse((String)"No line found for line 'String s2 = \"#{string.ss}\";'", (start == -1 ? 1 : 0) != 0);
            int line = this.baseTest.getDocument().getLineOfOffset(start);
            this.baseTest.assertResourceMarkerIsCreated(this.baseTest.getFile(), this.toRegex(ERROR_MESSAGE), line + 1);
            Annotation problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, ERROR_MESSAGE, 5, true, true);
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertNotNull((String)"Problem Marker Annotation for line 'String s2 = \"#{string.ss}\";' not found!", (Object)problemAnnotation);
            String message = problemAnnotation.getText();
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [\"ss\" cannot be resolved], Found: [" + message + "]"), (String)ERROR_MESSAGE, (String)message);
            this.baseTest.getDocument().replace(start, length, "");
            problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, null, 5, true, false);
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertNull((String)"Problem Annotation has not disappeared!", (Object)problemAnnotation);
            this.baseTest.getDocument().replace(start, 0, TEXT_LINE_TO_REPLACE);
            this.checkProblemAnnotationExists(start, length, ERROR_MESSAGE);
            this.baseTest.getDocument().replace(start + length + -2, 0, TEXT_TO_INSERT);
            this.checkProblemAnnotationExists(start, length + TEXT_TO_INSERT.length(), ERROR_MESSAGE);
            documentContent = this.baseTest.getDocument().get();
            int start2 = documentContent == null ? -1 : documentContent.indexOf(TEXT_LINE_TO_CHECK, 0);
            int length2 = TEXT_LINE_TO_CHECK.length();
            this.checkProblemAnnotationExists(start2, length2, ERROR_MESSAGE);
            if (documentContent != null) {
                documentContent.indexOf(TEXT_METHOD_BODY, 0);
            }
            TEXT_METHOD_BODY.length();
            this.baseTest.getDocument().replace(start + length, 0, TEXT_TO_INSERT);
            documentContent = this.baseTest.getDocument().get();
            this.checkProblemAnnotationExists(start, length + TEXT_TO_INSERT.length(), ERROR_MESSAGE);
            this.checkProblemAnnotationExists(start2, length2, ERROR_MESSAGE);
        }
        finally {
            this.baseTest.closeEditor();
        }
    }

    public void testCommentingLinesWithAProblems() throws BadLocationException, CoreException {
        CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertNotNull((String)("Test project '" + this.getProjectNameProvider().getMainProjectName() + "' is not prepared"), (Object)this.project);
        this.baseTest.openEditor(PAGE_NAME);
        try {
            String documentContent = this.baseTest.getDocument().get();
            int start = documentContent == null ? -1 : documentContent.indexOf(TEXT_LINE_TO_REPLACE, 0);
            int length = TEXT_LINE_TO_REPLACE.length();
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertFalse((String)"No line found for line 'String s2 = \"#{string.ss}\";'", (start == -1 ? 1 : 0) != 0);
            int line = this.baseTest.getDocument().getLineOfOffset(start);
            this.baseTest.assertResourceMarkerIsCreated(this.baseTest.getFile(), this.toRegex(ERROR_MESSAGE), line + 1);
            Annotation problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, ERROR_MESSAGE, 5, true, true);
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertNotNull((String)"Problem Marker Annotation for line 'String s2 = \"#{string.ss}\";' not found!", (Object)problemAnnotation);
            String message = problemAnnotation.getText();
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [\"ss\" cannot be resolved], Found: [" + message + "]"), (String)ERROR_MESSAGE, (String)message);
            int lineStartOffset = this.baseTest.getDocument().getLineOffset(line);
            String lineToReplace = "//" + documentContent.substring(lineStartOffset, start + length);
            this.baseTest.getDocument().replace(lineStartOffset, start + length - lineStartOffset, lineToReplace);
            problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, null, 5, true, false);
            CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertNull((String)"Problem Annotation has not disappeared!", (Object)problemAnnotation);
            this.baseTest.getDocument().replace(lineStartOffset, 2, "");
            this.checkProblemAnnotationExists(start, length, ERROR_MESSAGE);
        }
        finally {
            this.baseTest.closeEditor();
        }
    }

    private void checkProblemAnnotationExists(int start, int length, String errorMessage) throws BadLocationException {
        Annotation problemAnnotation = this.baseTest.waitForAnnotation(start, start + length + TEXT_TO_INSERT.length(), errorMessage, 5, false, true);
        CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertNotNull((String)("No Problem Annotation found for problematic line '" + this.baseTest.getDocument().get(start, length) + "'!"), (Object)problemAnnotation);
        String message = problemAnnotation.getText();
        CDIAsYouTypeCDIAndELValidatorsMassagesProcessingTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [" + errorMessage + "], Found: [" + message + "]"), (String)errorMessage, (String)message);
    }

    private String toRegex(String text) {
        StringBuilder result = new StringBuilder(text);
        int i = -1;
        while ((i = result.indexOf("[", i + 1)) != -1) {
            result.insert(i++, '\\');
        }
        i = -1;
        while ((i = result.indexOf("]", i + 1)) != -1) {
            result.insert(i++, '\\');
        }
        return result.toString();
    }
}

