/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.validation.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.Annotation;
import org.jboss.tools.cdi.core.test.tck.TCKTest;
import org.jboss.tools.cdi.internal.core.validation.CDIValidationMessages;
import org.jboss.tools.common.base.test.validation.java.BaseAsYouTypeInJavaValidationTest;

public class CDIAsYouTypeInJavaSupressWarningsTest
extends TCKTest {
    private static final String PAGE_NAME = "JavaSource/org/jboss/jsr299/tck/tests/jbt/validation/TestNamed.java";
    private static final String CDI_CORE_VALIDATOR_PROBLEM_TYPE = "org.jboss.tools.cdi.core.cdiproblem";
    private BaseAsYouTypeInJavaValidationTest baseTest = null;
    protected IProject project;
    private static final String SUPPRESSWARNINGS_NAME = "cdi-ambiguous-dependency";
    private static final String INJECT_ANNOTATION_NAME = "@Inject";

    public void setUp() throws Exception {
        this.project = this.findTestProject();
        if (this.baseTest == null) {
            this.baseTest = new BaseAsYouTypeInJavaValidationTest(this.project, CDI_CORE_VALIDATOR_PROBLEM_TYPE);
        }
    }

    public void testAsYouTypeInJavaValidation() throws BadLocationException, CoreException {
        CDIAsYouTypeInJavaSupressWarningsTest.assertNotNull((String)("Test project '" + this.getProjectNameProvider().getMainProjectName() + "' is not prepared"), (Object)this.project);
        this.baseTest.openEditor(PAGE_NAME);
        try {
            this.doAsYouTypeValidationMarkerAnnotationsRemovalTest();
        }
        finally {
            this.baseTest.closeEditor();
        }
    }

    public void doAsYouTypeValidationMarkerAnnotationsRemovalTest() throws BadLocationException, CoreException {
        String documentContent = this.baseTest.getDocument().get();
        int start = documentContent == null ? -1 : documentContent.indexOf(SUPPRESSWARNINGS_NAME, 0);
        CDIAsYouTypeInJavaSupressWarningsTest.assertFalse((String)"No annotation for 'cdi-ambiguous-dependency' found in document", (start == -1 ? 1 : 0) != 0);
        int length = SUPPRESSWARNINGS_NAME.length();
        int injectStart = documentContent == null ? -1 : documentContent.indexOf(INJECT_ANNOTATION_NAME, start);
        INJECT_ANNOTATION_NAME.length();
        int line = this.baseTest.getDocument().getLineOfOffset(injectStart);
        this.baseTest.assertNoResourceMarkerIsCreated(this.baseTest.getFile(), this.toRegex(CDIValidationMessages.AMBIGUOUS_INJECTION_POINTS[this.getVersionIndex()]), line + 1);
        Annotation problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, CDIValidationMessages.AMBIGUOUS_INJECTION_POINTS[this.getVersionIndex()], 5, true, false);
        CDIAsYouTypeInJavaSupressWarningsTest.assertNull((String)"Problem Marker Annotation found for '@Inject'!", (Object)problemAnnotation);
        this.baseTest.getDocument().replace(start, length, "xyz");
        problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, null, 5, false, true);
        CDIAsYouTypeInJavaSupressWarningsTest.assertNotNull((String)"Problem Annotation didn't appeare!", (Object)problemAnnotation);
        String message = problemAnnotation.getText();
        CDIAsYouTypeInJavaSupressWarningsTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [" + CDIValidationMessages.AMBIGUOUS_INJECTION_POINTS[this.getVersionIndex()] + "], Found: [" + message + "]"), (String)CDIValidationMessages.AMBIGUOUS_INJECTION_POINTS[this.getVersionIndex()], (String)message);
        this.baseTest.getDocument().replace(start, 3, SUPPRESSWARNINGS_NAME);
        problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, CDIValidationMessages.AMBIGUOUS_INJECTION_POINTS[this.getVersionIndex()], 5, false, false);
        CDIAsYouTypeInJavaSupressWarningsTest.assertNull((String)"Problem Annotation didn't disappeare!", (Object)problemAnnotation);
    }

    private String toRegex(String text) {
        StringBuilder result = new StringBuilder(text);
        int i = -1;
        while ((i = result.indexOf("[", i + 1)) != -1) {
            result.insert(i++, '\\');
        }
        i = -1;
        while ((i = result.indexOf("]", i + 1)) != -1) {
            result.insert(i++, '\\');
        }
        return result.toString();
    }
}

