/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.validation.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.Annotation;
import org.jboss.tools.cdi.core.test.tck.TCKTest;
import org.jboss.tools.cdi.internal.core.validation.CDIValidationMessages;
import org.jboss.tools.common.base.test.validation.java.BaseAsYouTypeInJavaValidationTest;

public class CDIAsYouTypeInJavaValidationTest
extends TCKTest {
    private static final String PAGE_NAME = "JavaSource/org/jboss/jsr299/tck/tests/jbt/validation/NPEValidation.java";
    private static final String CDI_CORE_VALIDATOR_PROBLEM_TYPE = "org.jboss.tools.cdi.core.cdiproblem";
    private BaseAsYouTypeInJavaValidationTest baseTest = null;
    protected IProject project;

    public void setUp() throws Exception {
        this.project = this.findTestProject();
        if (this.baseTest == null) {
            this.baseTest = new BaseAsYouTypeInJavaValidationTest(this.project, CDI_CORE_VALIDATOR_PROBLEM_TYPE);
        }
    }

    public void testAsYouTypeInJavaValidation() throws BadLocationException, CoreException {
        String[][] ANNOTATIONS2VALIDATE = new String[][]{{"@Inject", CDIValidationMessages.AMBIGUOUS_INJECTION_POINTS[this.getVersionIndex()]}, {"@Produces", CDIValidationMessages.PRODUCER_IN_DECORATOR[this.getVersionIndex()]}};
        CDIAsYouTypeInJavaValidationTest.assertNotNull((String)("Test project '" + this.getProjectNameProvider().getMainProjectName() + "' is not prepared"), (Object)this.project);
        int i = 0;
        while (i < ANNOTATIONS2VALIDATE.length) {
            this.baseTest.openEditor(PAGE_NAME);
            try {
                this.doAsYouTypeValidationMarkerAnnotationsRemovalTest(ANNOTATIONS2VALIDATE[i][0], ANNOTATIONS2VALIDATE[i][1]);
            }
            finally {
                this.baseTest.closeEditor();
            }
            ++i;
        }
    }

    public void doAsYouTypeValidationMarkerAnnotationsRemovalTest(String annotation, String errorMessage) throws BadLocationException, CoreException {
        String documentContent = this.baseTest.getDocument().get();
        int start = documentContent == null ? -1 : documentContent.indexOf(annotation, 0);
        CDIAsYouTypeInJavaValidationTest.assertFalse((String)("No annotation " + annotation + " found in document"), (start == -1 ? 1 : 0) != 0);
        int length = annotation.length();
        int line = this.baseTest.getDocument().getLineOfOffset(start);
        this.baseTest.assertResourceMarkerIsCreated(this.baseTest.getFile(), this.toRegex(errorMessage), line + 1);
        Annotation problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, errorMessage, 5, true, true);
        CDIAsYouTypeInJavaValidationTest.assertNotNull((String)("Problem Marker Annotation for " + annotation + " not found!"), (Object)problemAnnotation);
        String message = problemAnnotation.getText();
        CDIAsYouTypeInJavaValidationTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [" + errorMessage + "], Found: [" + message + "]"), (String)errorMessage, (String)message);
        this.baseTest.getDocument().replace(start, length, "");
        problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, null, 5, true, false);
        CDIAsYouTypeInJavaValidationTest.assertNull((String)"Problem Marker Annotation has not disappeared!", (Object)problemAnnotation);
        this.baseTest.getDocument().replace(start, 0, annotation);
        problemAnnotation = this.baseTest.waitForAnnotation(start, start + length, errorMessage, 5, false, true);
        CDIAsYouTypeInJavaValidationTest.assertNotNull((String)("Couldn't find the following problem annotation for " + annotation + ": Text: " + errorMessage + " at position:" + start + "(start), " + (start + length) + "(end)."), (Object)problemAnnotation);
        message = problemAnnotation.getText();
        CDIAsYouTypeInJavaValidationTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [" + errorMessage + "], Found: [" + message + "]"), (String)errorMessage, (String)message);
        CDIAsYouTypeInJavaValidationTest.assertNotNull((String)("No Problem Annotation found for wrong annotation " + annotation + "!"), (Object)problemAnnotation);
    }

    private String toRegex(String text) {
        StringBuilder result = new StringBuilder(text);
        int i = -1;
        while ((i = result.indexOf("[", i + 1)) != -1) {
            result.insert(i++, '\\');
        }
        i = -1;
        while ((i = result.indexOf("]", i + 1)) != -1) {
            result.insert(i++, '\\');
        }
        return result.toString();
    }
}

