/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.wizard;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringWizardDialog;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.internal.core.refactoring.AddQualifiersToBeanProcessor;
import org.jboss.tools.cdi.internal.core.refactoring.ValuedQualifier;
import org.jboss.tools.cdi.ui.test.testmodel.CDIBean;
import org.jboss.tools.cdi.ui.test.testmodel.CDIInjectionPoint;
import org.jboss.tools.cdi.ui.test.testmodel.CDIProject;
import org.jboss.tools.cdi.ui.test.testmodel.CDIQualifierDeclaration;
import org.jboss.tools.cdi.ui.wizard.AddQualifiersToBeanWizard;

public class AddQualifiersToBeanWizardTest
extends TestCase {
    private CDIProject project;
    private ArrayList<ValuedQualifier> availableCheck;
    private ArrayList<ValuedQualifier> deployedCheck;
    private AddQualifiersToBeanProcessor processor;
    private AddQualifiersToBeanWizard wizard;
    private Dialog dialog;

    protected void setUp() throws Exception {
        super.setUp();
        this.project = CDIProject.defaultCDIProject;
        CDIBean bean = new CDIBean(this.project, "org.test.FooBean");
        CDIInjectionPoint injectionPoint = new CDIInjectionPoint(this.project, bean);
        ArrayList<CDIBean> beans = new ArrayList<CDIBean>();
        beans.add(bean);
        this.availableCheck = new ArrayList();
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("javax.inject.Named")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("javax.enterprise.inject.New")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("org.test.Qualifier1")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("org.test.Qualifier2")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("org.test.Qualifier3")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("org.test.Qualifier4")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("org.test.Qualifier5")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("org.test.CompicatedQualifier")));
        this.availableCheck.add(new ValuedQualifier(this.project.getQualifier("org.test.OtherComplicatedQualifier")));
        this.deployedCheck = new ArrayList();
        this.deployedCheck.add(new ValuedQualifier(this.project.getQualifier("javax.enterprise.inject.Any")));
        this.deployedCheck.add(new ValuedQualifier(this.project.getQualifier("javax.enterprise.inject.Default")));
        this.processor = new AddQualifiersToBeanProcessor("", (IInjectionPoint)injectionPoint, beans, (IBean)bean);
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)this.processor);
        this.wizard = new AddQualifiersToBeanWizard(refactoring);
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        RefactoringStatus fInitialConditions = this.processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        if (fInitialConditions.hasFatalError()) {
            RefactoringStatusEntry[] refactoringStatusEntryArray = fInitialConditions.getEntries();
            int n = refactoringStatusEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                RefactoringStatusEntry entry = refactoringStatusEntryArray[n2];
                if (entry.getSeverity() == 4) {
                    AddQualifiersToBeanWizardTest.fail((String)("Fatal Error - " + entry.getMessage()));
                }
                ++n2;
            }
        } else {
            this.wizard.setInitialConditionCheckingStatus(fInitialConditions);
            this.dialog = new RefactoringWizardDialog(parent, (RefactoringWizard)this.wizard);
            this.dialog.setBlockOnOpen(false);
            this.dialog.create();
            this.dialog.open();
        }
    }

    protected void tearDown() throws Exception {
        this.dialog.close();
        super.tearDown();
    }

    private void checkQualifierLists(List<ValuedQualifier> checkQualifiers, List<IQualifier> actualQualifiers) {
        for (ValuedQualifier vq : checkQualifiers) {
            if (actualQualifiers.contains(vq.getQualifier())) continue;
            AddQualifiersToBeanWizardTest.fail((String)("Qualifier - " + vq.getQualifier().getSourceType().getFullyQualifiedName() + " not found"));
        }
        for (IQualifier q : actualQualifiers) {
            if (checkQualifiers.contains(new ValuedQualifier(q))) continue;
            AddQualifiersToBeanWizardTest.fail((String)("Wrong Qualifier - " + q.getSourceType().getFullyQualifiedName() + " found"));
        }
    }

    private void checkValuedQualifierLists(List<ValuedQualifier> checkQualifiers, List<ValuedQualifier> actualQualifiers) {
        for (ValuedQualifier vq : checkQualifiers) {
            if (actualQualifiers.contains(vq)) continue;
            AddQualifiersToBeanWizardTest.fail((String)("Qualifier - " + vq.getQualifier().getSourceType().getFullyQualifiedName() + " not found"));
        }
        for (ValuedQualifier q : actualQualifiers) {
            if (checkQualifiers.contains(q)) continue;
            AddQualifiersToBeanWizardTest.fail((String)("Wrong Qualifier - " + q.getQualifier().getSourceType().getFullyQualifiedName() + " found"));
        }
    }

    public void testAddQualifier() {
        List available = this.wizard.getAvailableQualifiers();
        this.checkQualifierLists(this.availableCheck, available);
        List deployed = this.wizard.getDeployedQualifiers();
        this.checkValuedQualifierLists(this.deployedCheck, deployed);
        ValuedQualifier qualifier = new ValuedQualifier(this.project.getQualifier("org.test.Qualifier1"));
        ValuedQualifier defaultQualifier = new ValuedQualifier(this.project.getQualifier("javax.enterprise.inject.Default"));
        this.wizard.deploy(qualifier);
        available = this.wizard.getAvailableQualifiers();
        this.availableCheck.remove(qualifier);
        this.checkQualifierLists(this.availableCheck, available);
        deployed = this.wizard.getDeployedQualifiers();
        this.deployedCheck.add(qualifier);
        this.deployedCheck.remove(defaultQualifier);
        this.checkValuedQualifierLists(this.deployedCheck, deployed);
    }

    public void testAddAndRemoveQualifier() {
        List available = this.wizard.getAvailableQualifiers();
        this.checkQualifierLists(this.availableCheck, available);
        List deployed = this.wizard.getDeployedQualifiers();
        this.checkValuedQualifierLists(this.deployedCheck, deployed);
        ValuedQualifier qualifier = new ValuedQualifier(this.project.getQualifier("org.test.Qualifier2"));
        ValuedQualifier defaultQualifier = new ValuedQualifier(this.project.getQualifier("javax.enterprise.inject.Default"));
        this.wizard.deploy(qualifier);
        available = this.wizard.getAvailableQualifiers();
        this.availableCheck.remove(qualifier);
        this.checkQualifierLists(this.availableCheck, available);
        deployed = this.wizard.getDeployedQualifiers();
        this.deployedCheck.add(qualifier);
        this.deployedCheck.remove(defaultQualifier);
        this.checkValuedQualifierLists(this.deployedCheck, deployed);
        this.wizard.remove(qualifier);
        available = this.wizard.getAvailableQualifiers();
        this.availableCheck.add(qualifier);
        this.checkQualifierLists(this.availableCheck, available);
        deployed = this.wizard.getDeployedQualifiers();
        this.deployedCheck.remove(qualifier);
        this.deployedCheck.add(defaultQualifier);
        this.checkValuedQualifierLists(this.deployedCheck, deployed);
    }

    public void testAddNamedQualifier() {
        List available = this.wizard.getAvailableQualifiers();
        this.checkQualifierLists(this.availableCheck, available);
        List deployed = this.wizard.getDeployedQualifiers();
        this.checkValuedQualifierLists(this.deployedCheck, deployed);
        ValuedQualifier named = new ValuedQualifier(this.project.getQualifier("javax.inject.Named"));
        this.wizard.deploy(named);
        available = this.wizard.getAvailableQualifiers();
        this.availableCheck.remove(named);
        this.checkQualifierLists(this.availableCheck, available);
        deployed = this.wizard.getDeployedQualifiers();
        this.deployedCheck.add(named);
        this.checkValuedQualifierLists(this.deployedCheck, deployed);
    }

    public void testValuedQualifier() {
        ValuedQualifier oneQualifier = new ValuedQualifier(this.project.getQualifier("org.test.CompicatedQualifier"));
        String value = oneQualifier.getValue();
        AddQualifiersToBeanWizardTest.assertEquals((String)"type = \"default\", realChanky = false, number = 0, bTs = 0, posibility = 0.0, ch = ' '", (String)value);
    }

    public void testValuedQualifierWithDeclaration() {
        ValuedQualifier anotherQualifier = new ValuedQualifier(this.project.getQualifier("org.test.OtherComplicatedQualifier"), (IQualifierDeclaration)new CDIQualifierDeclaration());
        String value = anotherQualifier.getValue();
        AddQualifiersToBeanWizardTest.assertEquals((String)"name = \"John\", size = 5, p = 0.5, ch = 'Q', b = 6", (String)value);
    }
}

