/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.wizard;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.tools.cdi.ui.wizard.NewBeanCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewDecoratorCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewInterceptorCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewStereotypeCreationWizard;
import org.jboss.tools.cdi.xml.ui.editor.form.CDINewClassWizardFactory;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.wizards.INewClassWizard;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class NewCDIClassWizardFactoryTest
extends TestCase {
    IProject tck;

    public void testClassWizardFactory() throws Exception {
        this.tck = ResourcesPlugin.getWorkspace().getRoot().getProject("tck");
        IFile file = this.tck.getFile("WebContent/WEB-INF/beans.xml");
        NewCDIClassWizardFactoryTest.assertNotNull((Object)file);
        CDINewClassWizardFactory factory = new CDINewClassWizardFactory();
        XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)file);
        NewCDIClassWizardFactoryTest.assertNotNull((Object)o);
        XModelObject decorators = o.getChildByPath("Decorators");
        XModelObject decorator = decorators.getChildByPath("com.acme.NonExistantDecoratorClass");
        NewCDIClassWizardFactoryTest.assertNotNull((Object)decorator);
        XAttribute clsAttr = decorator.getModelEntity().getAttribute("class");
        NewCDIClassWizardFactoryTest.assertNotNull((Object)clsAttr);
        INewClassWizard wizard = factory.createWizard(decorators, clsAttr);
        NewCDIClassWizardFactoryTest.assertTrue((boolean)(wizard instanceof NewDecoratorCreationWizard));
        XModelObject alternatives = o.getChildByPath("Alternatives");
        XModelObject stereotype = alternatives.getChildByPath("org.jboss.jsr299.tck.tests.policy.broken.not.policy.stereotype.Mock");
        NewCDIClassWizardFactoryTest.assertNotNull((Object)stereotype);
        XAttribute stereotypeAttr = stereotype.getModelEntity().getAttribute("stereotype");
        NewCDIClassWizardFactoryTest.assertNotNull((Object)stereotypeAttr);
        wizard = factory.createWizard(alternatives, stereotypeAttr);
        NewCDIClassWizardFactoryTest.assertTrue((boolean)(wizard instanceof NewStereotypeCreationWizard));
        wizard = factory.createWizard(alternatives, clsAttr);
        NewCDIClassWizardFactoryTest.assertTrue((boolean)(wizard instanceof NewBeanCreationWizard));
        XModelObject interceptors = o.getChildByPath("Interceptors");
        XModelObject interceptor = interceptors.getChildByPath("com.acme.Foo");
        NewCDIClassWizardFactoryTest.assertNotNull((Object)interceptor);
        wizard = factory.createWizard(interceptors, clsAttr);
        NewCDIClassWizardFactoryTest.assertTrue((boolean)(wizard instanceof NewInterceptorCreationWizard));
        wizard = factory.createWizard(interceptor, clsAttr);
        NewCDIClassWizardFactoryTest.assertTrue((boolean)(wizard instanceof NewInterceptorCreationWizard));
    }
}

