/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jsf.ui.internal.project.facet.JSFFacetInstallPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.ui.wizard.CDIProjectWizard;
import org.jboss.tools.test.util.WorkbenchUtils;

public class NewCDIWebProjectWizardTest
extends TestCase {
    CDIProjectWizard wizard;
    WizardDialog dialog;

    public NewCDIWebProjectWizardTest() {
        super("New CDI Web Project tests");
    }

    protected void setUp() throws Exception {
        this.wizard = (CDIProjectWizard)WorkbenchUtils.findWizardByDefId((String)"org.jboss.tools.cdi.ui.wizard.NewCDIProjectWizard");
        this.dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.wizard);
        this.dialog.create();
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.cleanDefferedEvents();
    }

    private void cleanDefferedEvents() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testCDIProjectNewWizardInstanceIsCreated() {
        try {
            IWizardPage startCDIPrjWzPg = this.wizard.getStartingPage();
            this.wizard.getDataModel().setStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME", "testName");
            NewCDIWebProjectWizardTest.assertNotNull((String)"Cannot create start wizard page", (Object)startCDIPrjWzPg);
            IWizardPage javaModuleWizPg = this.wizard.getNextPage(startCDIPrjWzPg);
            NewCDIWebProjectWizardTest.assertNotNull((String)"Cannot create java project wizard page", (Object)javaModuleWizPg);
            IWizardPage webModuleWizPg = this.wizard.getNextPage(javaModuleWizPg);
            NewCDIWebProjectWizardTest.assertNotNull((String)"Cannot create dynamic web project wizard page", (Object)webModuleWizPg);
            IWizardPage cdiWizPg = this.wizard.getNextPage(webModuleWizPg);
            NewCDIWebProjectWizardTest.assertNotNull((String)"Cannot create cdi facet wizard page", (Object)cdiWizPg);
            IWizardPage jsfCapabilitiesWizPg = this.wizard.getNextPage(cdiWizPg);
            NewCDIWebProjectWizardTest.assertNotNull((String)"Cannot create JSF capabilities wizard page", (Object)jsfCapabilitiesWizPg);
        }
        finally {
            this.wizard.performCancel();
            this.dialog.close();
        }
    }

    public void testCDIProjectNewWizardFinishDisableByDefaul() {
        try {
            this.disableLibraryConfiguration();
            this.cleanDefferedEvents();
            boolean canFinish = this.wizard.canFinish();
            NewCDIWebProjectWizardTest.assertFalse((String)"Finish button is enabled at first wizard page before all requerd fileds are valid.", (boolean)canFinish);
        }
        finally {
            this.wizard.performCancel();
            this.dialog.close();
        }
    }

    public void testCDIProjectNewWizardFinissEnabled() {
        try {
            this.disableLibraryConfiguration();
            this.cleanDefferedEvents();
            this.wizard.getDataModel().setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)"testCDIProject");
            this.cleanDefferedEvents();
            NewCDIWebProjectWizardTest.assertTrue((String)"Finish button is disabled at first wizard page in spite of valid project name.", (boolean)this.wizard.canFinish());
        }
        finally {
            this.wizard.performCancel();
            this.dialog.close();
        }
    }

    public void testCDI10ProjectCreated() throws Exception {
        this.assertCDIProjectCreated(IJ2EEFacetConstants.DYNAMIC_WEB_30, "beans.xml", "template.jboss.tools.cdi10");
    }

    public void testCDI12ProjectCreated() throws Exception {
        this.assertCDIProjectCreated(IJ2EEFacetConstants.DYNAMIC_WEB_31, "beans11.xml", "template.jboss.tools.cdi12");
    }

    public void assertCDIProjectCreated(IProjectFacetVersion webVersion, String beansXmlTemplateFileName, String cdiTemplateName) throws Exception {
        try {
            this.disableLibraryConfiguration();
            this.cleanDefferedEvents();
            String projectName = "testCDIProject" + webVersion.getVersionString();
            this.wizard.getDataModel().setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            this.wizard.setWebVersionCombo(webVersion);
            this.cleanDefferedEvents();
            this.wizard.performFinish();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            NewCDIWebProjectWizardTest.assertTrue((boolean)project.exists());
            NewCDIWebProjectWizardTest.assertNotNull((String)"CDI is not enabled", (Object)CDICorePlugin.getCDI((IProject)project, (boolean)false));
            IFile beansXml = project.getFile((IPath)new Path("WebContent/WEB-INF/beans.xml"));
            NewCDIWebProjectWizardTest.assertTrue((boolean)beansXml.exists());
            File beansXmlTemplateFile = new File(CDIUtil.getTemplatesFolder(), beansXmlTemplateFileName);
            File resultBeanXmlFile = beansXml.getLocation().toFile();
            NewCDIWebProjectWizardTest.assertTrue((boolean)beansXmlTemplateFile.exists());
            NewCDIWebProjectWizardTest.assertTrue((String)"Created beans.xml is not correct", (boolean)FileUtils.getFileUtils().contentEquals(beansXmlTemplateFile, resultBeanXmlFile));
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)cdiTemplateName);
            for (IProjectFacetVersion facet : template.getInitialPreset().getProjectFacets()) {
                NewCDIWebProjectWizardTest.assertTrue((String)("Created project \"" + projectName + "\" does not have facet \"" + facet.getProjectFacet().getId() + "\" version \"" + facet.getVersionString() + "\""), (boolean)facetedProject.hasProjectFacet(facet));
            }
        }
        finally {
            this.dialog.close();
        }
    }

    private void disableLibraryConfiguration() {
        IWizardPage[] iWizardPageArray = this.wizard.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof JSFFacetInstallPage) {
                JSFFacetInstallPage cfr_ignored_0 = (JSFFacetInstallPage)page;
                Control control = page.getControl();
                if (control instanceof Composite) {
                    this.processComposite((Composite)control);
                }
            }
            ++n2;
        }
    }

    private void processComposite(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Combo) {
                Combo combo = (Combo)child;
                int index = -1;
                int i = 0;
                while (i < combo.getItemCount()) {
                    String item = combo.getItem(i);
                    if ("Disable Library Configuration".equals(item)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index >= 0) {
                    combo.select(index);
                    try {
                        Method method = Widget.class.getDeclaredMethod("sendEvent", Integer.TYPE);
                        if (method != null) {
                            method.setAccessible(true);
                            method.invoke((Object)combo, 13);
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (child instanceof Composite) {
                this.processComposite((Composite)child);
            }
            ++n2;
        }
    }
}

