/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.wizard;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.wizard.NewAnnotationLiteralCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewAnnotationLiteralWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewBeanWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewBeansXMLCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewCDIElementWizard;
import org.jboss.tools.cdi.ui.wizard.NewDecoratorWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewInterceptorBindingWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewInterceptorWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewQualifierWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewScopeWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewStereotypeWizardPage;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.WorkbenchUtils;

public class NewCDIWizardTest
extends TestCase {
    static String PACK_NAME = "test";
    static String QUALIFIER_NAME = "MyQualifier";
    static String HAIRY_PACK_NAME = "org.jboss.jsr299.tck.tests.definition.qualifier";
    static String HAIRY_QUALIFIER = "Hairy";
    static String STEREOTYPE_NAME = "MyStereotype";
    static String STEREOTYPE2_NAME = "MyStereotype2";
    static String SCOPE_NAME = "MyScope";
    static String INTERCEPTOR_BINDING_NAME = "MyInterceptorBinding";
    static String INTERCEPTOR_BINDING2_NAME = "MyInterceptorBinding2";
    static String EXISTING_PACK_NAME = "org.jboss.jsr299.tck.tests.jbt.validation.target";
    static String EXISTING_INTERCEPTOR_BINDING_NAME = "InterceptorBindingWTypeTarget";
    static String INTERCEPTOR_NAME = "MyInterceptor";
    static String DECORATOR_NAME = "MapDecorator<K,V>";
    static String BEAN_NAME = "MyBean";

    public void testNewQualifierWizard() {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewQualifierCreationWizard", PACK_NAME, QUALIFIER_NAME);
        try {
            NewQualifierWizardPage page = (NewQualifierWizardPage)context.page;
            page.setInherited(true);
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Qualifier"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Inherited"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Target({ TYPE, METHOD, PARAMETER, FIELD })"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Retention(RUNTIME)"));
        }
        finally {
            context.close();
        }
    }

    public void testNewStereotypeWizard() {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewStereotypeCreationWizard", PACK_NAME, STEREOTYPE_NAME);
        try {
            NewStereotypeWizardPage page = (NewStereotypeWizardPage)context.page;
            page.setInherited(true);
            page.setTarget("METHOD,FIELD");
            page.setNamed(true);
            page.setAlternative(true);
            page.setToBeRegisteredInBeansXML(true);
            NewCDIWizardTest.assertTrue((boolean)page.isToBeRegisteredInBeansXML());
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Stereotype"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Inherited"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Named"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Target({ METHOD, FIELD })"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Retention(RUNTIME)"));
            IProject tck = ResourcesPlugin.getWorkspace().getRoot().getProject("tck");
            IFile f = tck.getFile("WebContent/WEB-INF/beans.xml");
            XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)f);
            XModelObject c = o.getChildByPath("Alternatives/" + PACK_NAME + "." + STEREOTYPE_NAME);
            NewCDIWizardTest.assertNotNull((Object)c);
        }
        finally {
            context.close();
        }
        context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewStereotypeCreationWizard", PACK_NAME, STEREOTYPE2_NAME);
        try {
            context.tck.build(10, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ICDIProject cdi = CDICorePlugin.getCDIProject((IProject)context.tck, (boolean)true);
        IStereotype s = cdi.getStereotype(String.valueOf(PACK_NAME) + "." + STEREOTYPE_NAME);
        IStereotype d = cdi.getStereotype("javax.decorator.Decorator");
        NewCDIWizardTest.assertNotNull((Object)s);
        NewCDIWizardTest.assertNotNull((Object)d);
        try {
            NewStereotypeWizardPage page = (NewStereotypeWizardPage)context.page;
            page.setInherited(true);
            page.setTarget("METHOD,FIELD");
            page.setNamed(true);
            page.addStereotype(d);
            String message = page.getErrorMessage();
            NewCDIWizardTest.assertNull((Object)message);
            message = page.getMessage();
            NewCDIWizardTest.assertNotNull((Object)message);
            int messageType = page.getMessageType();
            NewCDIWizardTest.assertEquals((int)2, (int)messageType);
            String testmessage = NLS.bind((String)CDIUIMessages.MESSAGE_STEREOTYPE_IS_NOT_COMPATIBLE, (Object)d.getSourceType().getElementName());
            NewCDIWizardTest.assertEquals((String)testmessage, (String)message);
            page.addStereotype(s);
            message = page.getErrorMessage();
            testmessage = NLS.bind((String)CDIUIMessages.MESSAGE_STEREOTYPE_CANNOT_BE_APPLIED_TO_TYPE, (Object)s.getSourceType().getElementName());
            NewCDIWizardTest.assertEquals((String)testmessage, (String)message);
        }
        finally {
            context.close();
        }
    }

    public void testNewScopeWizard() {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewScopeCreationWizard", PACK_NAME, SCOPE_NAME);
        try {
            NewScopeWizardPage cfr_ignored_0 = (NewScopeWizardPage)context.page;
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("@NormalScope"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Inherited"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Target({ TYPE, METHOD, FIELD })"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Retention(RUNTIME)"));
        }
        finally {
            context.close();
        }
    }

    public void testNewInterceptorBindingWizard() {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewInterceptorBindingCreationWizard", PACK_NAME, INTERCEPTOR_BINDING_NAME);
        try {
            NewInterceptorBindingWizardPage page = (NewInterceptorBindingWizardPage)context.page;
            page.setTarget("TYPE");
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("@InterceptorBinding"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Inherited"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Target({ TYPE })"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Retention(RUNTIME)"));
        }
        finally {
            context.close();
        }
    }

    public void testNewInterceptorBindingWizardWithBinding() throws CoreException {
        IProject tck = ResourcesPlugin.getWorkspace().getRoot().getProject("tck");
        tck.build(6, (IProgressMonitor)new NullProgressMonitor());
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewInterceptorBindingCreationWizard", PACK_NAME, INTERCEPTOR_BINDING2_NAME);
        try {
            NewInterceptorBindingWizardPage page = (NewInterceptorBindingWizardPage)context.page;
            ICDIProject cdi = CDICorePlugin.getCDIProject((IProject)context.tck, (boolean)true);
            IInterceptorBinding s = cdi.getInterceptorBinding(String.valueOf(EXISTING_PACK_NAME) + "." + EXISTING_INTERCEPTOR_BINDING_NAME);
            NewCDIWizardTest.assertNotNull((Object)s);
            page.addInterceptorBinding(s);
            String message = page.getErrorMessage();
            NewCDIWizardTest.assertNull((Object)message);
            message = page.getMessage();
            NewCDIWizardTest.assertNotNull((Object)message);
            int messageType = page.getMessageType();
            NewCDIWizardTest.assertEquals((int)2, (int)messageType);
            String testmessage = NLS.bind((String)CDIUIMessages.MESSAGE_INTERCEPTOR_BINDING_IS_NOT_COMPATIBLE, (Object)s.getSourceType().getElementName());
            NewCDIWizardTest.assertEquals((String)testmessage, (String)message);
            page.setTarget("TYPE");
            message = page.getErrorMessage();
            NewCDIWizardTest.assertNull((Object)message);
            message = page.getMessage();
            NewCDIWizardTest.assertNull((Object)message);
        }
        finally {
            context.close();
        }
    }

    public void testNewInterceptorWizard() throws CoreException {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewInterceptorCreationWizard", PACK_NAME, INTERCEPTOR_NAME);
        ICDIProject cdi = CDICorePlugin.getCDIProject((IProject)context.tck, (boolean)true);
        IInterceptorBinding a = cdi.getInterceptorBinding(String.valueOf(EXISTING_PACK_NAME) + "." + EXISTING_INTERCEPTOR_BINDING_NAME);
        NewCDIWizardTest.assertNotNull((Object)a);
        try {
            NewInterceptorWizardPage page = (NewInterceptorWizardPage)context.page;
            page.addInterceptorBinding((ICDIAnnotation)a);
            NewCDIWizardTest.assertTrue((boolean)page.isToBeRegisteredInBeansXML());
            context.setTypeName("com.acme", "Foo");
            NewCDIWizardTest.assertFalse((boolean)page.isToBeRegisteredInBeansXML());
            context.setTypeName(PACK_NAME, INTERCEPTOR_NAME);
            NewCDIWizardTest.assertTrue((boolean)page.isToBeRegisteredInBeansXML());
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Interceptor"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@" + EXISTING_INTERCEPTOR_BINDING_NAME));
            IProject tck = ResourcesPlugin.getWorkspace().getRoot().getProject("tck");
            IFile f = tck.getFile("WebContent/WEB-INF/beans.xml");
            XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)f);
            XModelObject c = o.getChildByPath("Interceptors/" + PACK_NAME + "." + INTERCEPTOR_NAME);
            NewCDIWizardTest.assertNotNull((Object)c);
        }
        finally {
            context.close();
        }
    }

    public void testNewDecoratorWizard() {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewDecoratorCreationWizard", PACK_NAME, DECORATOR_NAME);
        CDICorePlugin.getCDIProject((IProject)context.tck, (boolean)true);
        try {
            NewDecoratorWizardPage page = (NewDecoratorWizardPage)context.page;
            ArrayList<String> interfacesNames = new ArrayList<String>();
            interfacesNames.add("java.util.Map<K,V>");
            page.setSuperInterfaces(interfacesNames, true);
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Decorator"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Delegate"));
        }
        finally {
            context.close();
        }
    }

    public void testNewBeanWizard() throws Exception {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewBeanCreationWizard", PACK_NAME, BEAN_NAME);
        ICDIProject cdi = CDICorePlugin.getCDIProject((IProject)context.tck, (boolean)true);
        try {
            NewBeanWizardPage page = (NewBeanWizardPage)context.page;
            page.setBeanName("myNewBean");
            NewCDIWizardTest.assertEquals((int)0, (int)page.getMessageType());
            page.setScope("javax.enterprise.context.SessionScoped");
            String message = page.getMessage();
            NewCDIWizardTest.assertEquals((String)CDIUIMessages.MESSAGE_BEAN_SHOULD_BE_SERIALIZABLE, (String)message);
            NewCDIWizardTest.assertEquals((int)2, (int)page.getMessageType());
            page.setScope("javax.enterprise.context.ApplicationScoped");
            NewCDIWizardTest.assertEquals((int)0, (int)page.getMessageType());
            cdi.getNature().setBeanDiscoveryMode(2);
            page.setScope("");
            message = page.getErrorMessage();
            NewCDIWizardTest.assertEquals((String)CDIUIMessages.SCOPE_SHOULD_BE_SET_IN_ARCHIVE_WITH_DISCOVERY_MODE_ANNOTATED, (String)message);
            page.setScope("javax.enterprise.context.ApplicationScoped");
            NewCDIWizardTest.assertEquals((int)0, (int)page.getMessageType());
            cdi.getNature().setBeanDiscoveryMode(3);
            page.setScope("");
            NewCDIWizardTest.assertEquals((int)0, (int)page.getMessageType());
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("@Named"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("\"myNewBean\""));
            IType type = (IType)context.wizard.getCreatedElement();
            int f = type.getFlags();
            NewCDIWizardTest.assertTrue((boolean)Modifier.isPublic(f));
            NewCDIWizardTest.assertFalse((boolean)Modifier.isAbstract(f));
        }
        finally {
            context.close();
        }
    }

    public void testNewAnnotationLiteralWizard() {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewAnnotationLiteralCreationWizard", PACK_NAME, String.valueOf(HAIRY_QUALIFIER) + "Literal");
        CDICorePlugin.getCDIProject((IProject)context.tck, (boolean)true);
        try {
            NewAnnotationLiteralWizardPage page = (NewAnnotationLiteralWizardPage)context.page;
            page.setQualifier(String.valueOf(HAIRY_PACK_NAME) + "." + HAIRY_QUALIFIER);
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("AnnotationLiteral<" + HAIRY_QUALIFIER + ">"));
        }
        finally {
            context.close();
        }
    }

    public void testNewAnnotationLiteralWizardWithMembers() {
        WizardContext context = new WizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewAnnotationLiteralCreationWizard", PACK_NAME, "NewLiteral");
        CDICorePlugin.getCDIProject((IProject)context.tck, (boolean)true);
        try {
            NewAnnotationLiteralWizardPage page = (NewAnnotationLiteralWizardPage)context.page;
            page.setQualifier("javax.enterprise.inject.New");
            context.wizard.performFinish();
            String text = context.getNewTypeContent();
            NewCDIWizardTest.assertTrue((boolean)text.contains("AnnotationLiteral<New>"));
            NewCDIWizardTest.assertTrue((boolean)text.contains("private final Class<?> value;"));
        }
        finally {
            context.close();
        }
    }

    public void testNewBeansXMLWizard() throws CoreException {
        NewBeansXMLWizardContext context = new NewBeansXMLWizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewBeansXMLCreationWizard");
        try {
            WizardNewFileCreationPage page = (WizardNewFileCreationPage)context.wizard.getPage("newFilePage1");
            String s = page.getFileName();
            NewCDIWizardTest.assertEquals((String)"beans.xml", (String)s);
            NewCDIWizardTest.assertFalse((boolean)context.wizard.canFinish());
            page.setFileName("beans2.xml");
            NewCDIWizardTest.assertTrue((boolean)context.wizard.canFinish());
            String c = page.getContainerFullPath().toString();
            NewCDIWizardTest.assertEquals((String)"/tck/WebContent/WEB-INF", (String)c);
            NewCDIWizardTest.assertEquals((String)CDIVersion.CDI_1_0.toString(), (String)context.wizard.getVersion());
            context.wizard.performFinish();
            IFile f = context.tck.getParent().getFile(page.getContainerFullPath().append(page.getFileName()));
            NewCDIWizardTest.assertTrue((boolean)f.exists());
            String text = FileUtil.readStream((InputStream)f.getContents());
            NewCDIWizardTest.assertTrue((text.indexOf("http://java.sun.com/xml/ns/javaee") > 0 ? 1 : 0) != 0);
        }
        finally {
            context.close();
        }
    }

    public void testNewBeansXMLWizard11() throws CoreException {
        NewBeansXMLWizardContext context = new NewBeansXMLWizardContext();
        context.init("org.jboss.tools.cdi.ui.wizard.NewBeansXMLCreationWizard");
        try {
            WizardNewFileCreationPage page = (WizardNewFileCreationPage)context.wizard.getPage("newFilePage1");
            String s = page.getFileName();
            NewCDIWizardTest.assertEquals((String)"beans.xml", (String)s);
            NewCDIWizardTest.assertFalse((boolean)context.wizard.canFinish());
            page.setFileName("beans3.xml");
            NewCDIWizardTest.assertTrue((boolean)context.wizard.canFinish());
            String c = page.getContainerFullPath().toString();
            NewCDIWizardTest.assertEquals((String)"/tck/WebContent/WEB-INF", (String)c);
            NewCDIWizardTest.assertEquals((String)CDIVersion.CDI_1_0.toString(), (String)context.wizard.getVersion());
            context.wizard.setVersion(CDIVersion.CDI_1_1);
            context.wizard.performFinish();
            IFile f = context.tck.getParent().getFile(page.getContainerFullPath().append(page.getFileName()));
            NewCDIWizardTest.assertTrue((boolean)f.exists());
            String text = FileUtil.readStream((InputStream)f.getContents());
            NewCDIWizardTest.assertTrue((text.indexOf("1.1") > 0 ? 1 : 0) != 0);
        }
        finally {
            context.close();
        }
    }

    static class NewBeansXMLWizardContext {
        NewBeansXMLCreationWizard wizard;
        IProject tck;
        IJavaProject jp;
        WizardDialog dialog;

        NewBeansXMLWizardContext() {
        }

        public void init(String wizardId) {
            this.wizard = (NewBeansXMLCreationWizard)WorkbenchUtils.findWizardByDefId((String)wizardId);
            this.tck = ResourcesPlugin.getWorkspace().getRoot().getProject("tck");
            this.jp = EclipseUtil.getJavaProject((IProject)this.tck);
            this.wizard.init(CDIUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.jp));
            this.dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.wizard);
            this.wizard.setOpenEditorAfterFinish(false);
            this.dialog.setBlockOnOpen(false);
            this.dialog.open();
        }

        public void close() {
            this.dialog.close();
        }
    }

    static class WizardContext {
        NewElementWizard wizard;
        IProject tck;
        IJavaProject jp;
        WizardDialog dialog;
        NewTypeWizardPage page;
        String packName;
        String typeName;

        WizardContext() {
        }

        public void init(String wizardId, String packName, String typeName) {
            this.wizard = (NewElementWizard)WorkbenchUtils.findWizardByDefId((String)wizardId);
            this.tck = ResourcesPlugin.getWorkspace().getRoot().getProject("tck");
            this.jp = EclipseUtil.getJavaProject((IProject)this.tck);
            this.wizard.init(CDIUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.jp));
            if (this.wizard instanceof NewCDIElementWizard) {
                ((NewCDIElementWizard)this.wizard).setOpenEditorAfterFinish(false);
            } else if (this.wizard instanceof NewAnnotationLiteralCreationWizard) {
                ((NewAnnotationLiteralCreationWizard)this.wizard).setOpenEditorAfterFinish(false);
            }
            this.dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.wizard);
            this.dialog.setBlockOnOpen(false);
            this.dialog.open();
            this.page = (NewTypeWizardPage)this.dialog.getSelectedPage();
            this.setTypeName(packName, typeName);
        }

        public void setTypeName(String packName, String typeName) {
            this.packName = packName;
            this.typeName = typeName;
            this.page.setTypeName(typeName, true);
            IPackageFragment pack = this.page.getPackageFragmentRoot().getPackageFragment(packName);
            this.page.setPackageFragment(pack, true);
        }

        public String getNewTypeContent() {
            IType type = null;
            try {
                String tn = this.typeName;
                int q = tn.indexOf("<");
                if (q >= 0) {
                    tn = tn.substring(0, q);
                }
                type = this.jp.findType(String.valueOf(this.packName) + "." + tn);
            }
            catch (JavaModelException e) {
                JUnitUtils.fail((String)("Cannot find type " + this.typeName), (Exception)((Object)e));
            }
            IFile file = (IFile)type.getResource();
            NewCDIWizardTest.assertNotNull((Object)file);
            String text = null;
            try {
                text = FileUtil.readStream((InputStream)file.getContents());
            }
            catch (CoreException e) {
                JUnitUtils.fail((String)("Cannot read from " + file), (Exception)((Object)e));
            }
            return text;
        }

        public void close() {
            this.dialog.close();
        }
    }
}

