/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.test.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.test.tck.TCKTest;
import org.jboss.tools.cdi.ui.wizard.OpenCDINamedBeanDialog;
import org.jboss.tools.test.util.JobUtils;

public class OpenCDINamedBeanDialogTest
extends TCKTest {
    public void testCDINamedBeanDialogSearch() throws CoreException {
        this.find("spi", "SpiderSize", "OtherSpiderProducer.java", true);
        this.find("alk", "alkalineBatarry", "BatarryBeanProducer.java", true);
        this.find("lady", "ladybirdSpider", "SpiderProducer.java", true);
    }

    public void testCDINamedBeanDialogSearchShortHand() throws CoreException {
        this.find("s*ze", "SpiderSize", "OtherSpiderProducer.java", true);
        this.find("*dSp*r", "ladybirdSpider", "SpiderProducer.java", true);
        this.find("foo?", "foo3", "TestNamed.java", true);
    }

    private void find(String pattern, String beanName, String editorName, boolean wait) throws CoreException {
        OpenCDINamedBeanDialog dialog = new OpenCDINamedBeanDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true);
        dialog.setBlockOnOpen(false);
        dialog.setInitialPattern(pattern);
        dialog.open();
        IBean bean = null;
        try {
            dialog.startSearch();
            if (wait) {
                JobUtils.waitForIdle();
                JobUtils.delay((long)2000L);
            }
            dialog.stopSearchAndShowResults();
            Object[] objects = dialog.getResult();
            OpenCDINamedBeanDialogTest.assertNotNull((String)("Search dialog returned null when searching for " + pattern), (Object)objects);
            OpenCDINamedBeanDialogTest.assertTrue((String)("Component " + beanName + " not found"), (objects.length != 0 ? 1 : 0) != 0);
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                OpenCDINamedBeanDialog.CDINamedBeanWrapper wrapper = (OpenCDINamedBeanDialog.CDINamedBeanWrapper)o;
                OpenCDINamedBeanDialogTest.assertNotNull((Object)wrapper.getBean());
                String foundName = wrapper.getBeanName();
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(foundName);
                if (beanName.equals(foundName)) {
                    bean = wrapper.getBean();
                    break;
                }
                ++n2;
            }
            OpenCDINamedBeanDialogTest.assertNotNull((String)("Bean " + beanName + " not found with " + pattern + ". Found beans: {" + sb.toString() + "}"), bean);
        }
        finally {
            dialog.okPressed();
            dialog.close();
        }
        bean.open();
        IEditorPart resultEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        OpenCDINamedBeanDialogTest.assertTrue((String)("Unexpected editor is opened for CDI Named Bean '" + bean.getName() + "': " + resultEditor.getTitle()), (boolean)editorName.equals(resultEditor.getTitle()));
    }

    private IBean findNamedBean(Object[] objects, String beanName) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            OpenCDINamedBeanDialog.CDINamedBeanWrapper wrapper = (OpenCDINamedBeanDialog.CDINamedBeanWrapper)o;
            OpenCDINamedBeanDialogTest.assertNotNull((Object)wrapper.getBean());
            if (beanName.equals(wrapper.getBeanName())) {
                return wrapper.getBean();
            }
            ++n2;
        }
        return null;
    }
}

