/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.jst.web.ui.internal.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JSPForwardHyperlinkPartitioner
extends AbstractHyperlinkPartitioner {
    public static final String JSP_FORWARD_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_FORWARD";
    private static final String EL_DOLLAR_PREFIX = "${";
    private static final String EL_SUFFIX = "}";
    private static final String EL_SHARP_PREFIX = "#{";

    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IHyperlinkRegion r = this.getRegion(document, offset);
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = JSP_FORWARD_PARTITION;
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(r.getOffset(), r.getLength(), axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, int offset) {
        return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)offset)) + "/";
    }

    public IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            int elStart;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            String text = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = sb.length();
            while (bStart < bEnd && (sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\t' || sb.charAt(bStart) == '\n' || sb.charAt(bStart) == '\r' || sb.charAt(bStart) == ' ')) {
                ++bStart;
            }
            while (bEnd - 1 > bStart && (sb.charAt(bEnd - 1) == '\"' || sb.charAt(bEnd - 1) == '\'' || sb.charAt(bEnd - 1) == '\t' || sb.charAt(bEnd - 1) == '\n' || sb.charAt(bEnd - 1) == '\r' || sb.charAt(bEnd - 1) == ' ')) {
                --bEnd;
            }
            if (start + bStart > offset || start + bEnd - 1 < offset) {
                return null;
            }
            int n2 = elStart = sb.indexOf(EL_SHARP_PREFIX) == -1 ? sb.indexOf(EL_DOLLAR_PREFIX) : sb.indexOf(EL_SHARP_PREFIX);
            if (elStart != -1 && elStart >= bStart && elStart < bEnd) {
                int elEnd = sb.indexOf(EL_SUFFIX, elStart);
                bStart = elEnd == -1 || elEnd > bEnd ? bEnd : elEnd + 1;
            }
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '\\' && sb.charAt(bStart) != '/' && sb.charAt(bStart) != ':' && sb.charAt(bStart) != '-' && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '_' && sb.charAt(bStart) != '%' && sb.charAt(bStart) != '?' && sb.charAt(bStart) != '&' && sb.charAt(bStart) != '=') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            bEnd = bStart;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '\\' && sb.charAt(bEnd) != '/' && sb.charAt(bEnd) != ':' && sb.charAt(bEnd) != '-' && sb.charAt(bEnd) != '.' && sb.charAt(bEnd) != '_' && sb.charAt(bEnd) != '%' && sb.charAt(bEnd) != '?' && sb.charAt(bEnd) != '&' && sb.charAt(bEnd) != '=') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset + 1 || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(propStart, propLength);
            return hyperlinkRegion;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return false;
            }
            IHyperlinkRegion r = this.getRegion(document, region.getOffset());
            if (r == null) {
                return false;
            }
            Attr attr = (Attr)n;
            String attrName = attr.getNodeName();
            if (!"var".equals(attrName) && !"basename".equals(attrName)) {
                return false;
            }
            Element lbTag = attr.getOwnerElement();
            String name = lbTag.getTagName();
            int column = name.indexOf(":");
            if (column == -1) {
                return false;
            }
            String prefix = name.substring(0, column);
            if (prefix == null || prefix.trim().length() == 0) {
                return false;
            }
            TaglibManagerWrapper tmw = new TaglibManagerWrapper();
            tmw.init(document, region.getOffset());
            if (!tmw.exists()) {
                return false;
            }
            if (!prefix.equals(tmw.getCorePrefix())) {
                return false;
            }
            Attr lbTagVar = lbTag.getAttributeNode("var");
            Attr lbTagBasename = lbTag.getAttributeNode("basename");
            if (lbTagVar == null || lbTagVar.getNodeValue() == null || lbTagVar.getNodeValue().trim().length() == 0) {
                return false;
            }
            return lbTagBasename != null && lbTagBasename.getNodeValue() != null && lbTagBasename.getNodeValue().trim().length() != 0;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }
}

