/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractComponent;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;

public class TLDTagHyperlink
extends AbstractHyperlink {
    protected AbstractComponent tag;
    protected XModelObject xmodelObject;
    protected String xmodelObjectName = null;
    protected IFile file = null;

    public TLDTagHyperlink(AbstractComponent tag, IRegion region) {
        this.tag = tag;
        this.setRegion(region);
        this.file = TLDTagHyperlink.getFile(tag);
        this.xmodelObject = TLDTagHyperlink.getXModelObject((KbObject)tag);
        if (this.xmodelObject != null && this.file != null) {
            String fileName = this.file.getName();
            String libraryName = TLDTagHyperlink.getFileName(this.xmodelObject);
            String objectName = this.xmodelObject.getAttributeValue("name");
            if (objectName == null) {
                objectName = this.xmodelObject.getAttributeValue("tag-name");
            }
            this.xmodelObjectName = fileName;
            if (libraryName != null && !libraryName.equals(fileName)) {
                this.xmodelObjectName = String.valueOf(this.xmodelObjectName) + " : " + libraryName;
            }
            if (objectName != null && !objectName.equals(libraryName)) {
                this.xmodelObjectName = String.valueOf(this.xmodelObjectName) + " : " + objectName;
            }
        }
    }

    public String getObjectName() {
        return this.xmodelObjectName;
    }

    public static IFile getFile(AbstractComponent tag) {
        ITagLibrary tagLib = tag.getTagLib();
        IResource r = tagLib.getResource();
        if (r instanceof IFile) {
            return (IFile)r;
        }
        return null;
    }

    public static XModelObject getXModelObject(KbObject tag) {
        Object id = tag.getId();
        if (id instanceof XModelObject) {
            return (XModelObject)id;
        }
        return null;
    }

    public static String getFileName(XModelObject xmodelObject) {
        FileAnyImpl fai = null;
        XModelObject f = xmodelObject;
        while (f != null && f.getFileType() != 1) {
            f = f.getParent();
        }
        if (f instanceof FileAnyImpl) {
            fai = (FileAnyImpl)f;
        }
        return FileAnyImpl.toFileName(fai);
    }

    public AbstractComponent getComponent() {
        return this.tag;
    }

    protected void doHyperlink(IRegion region) {
        if (this.xmodelObjectName != null) {
            int q = FindObjectHelper.findModelObject((XModelObject)this.xmodelObject, (int)FindObjectHelper.IN_EDITOR_ONLY);
            if (q == 1) {
                this.openFileFailed();
            }
        } else if (this.file != null) {
            IEditorPart part = null;
            part = TLDTagHyperlink.openFileInEditor((IFile)this.file);
            if (part == null) {
                this.openFileFailed();
            }
        } else {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        if (this.xmodelObjectName != null) {
            return NLS.bind((String)JSFTextExtMessages.Open, (Object)this.xmodelObjectName);
        }
        if (this.file != null) {
            return NLS.bind((String)JSFTextExtMessages.Open, (Object)this.file.getName());
        }
        return NLS.bind((String)JSFTextExtMessages.Open, (Object)"");
    }
}

