/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;

public class ValidatorHyperlink
extends AbstractHyperlink {
    protected void doHyperlink(IRegion region) {
        if (region == null) {
            this.openFileFailed();
            return;
        }
        IFile file = this.getFile();
        XModel xModel = ValidatorHyperlink.getXModel((IFile)file);
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        String validatorID = this.getValidatorId(this.getHyperlinkRegion());
        if (validatorID == null) {
            this.openFileFailed();
            return;
        }
        Properties p = new Properties();
        p.put("file", file);
        provider.getList(xModel, "jsf.open.validator", validatorID, p);
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    private String getValidatorId(IRegion region) {
        if (this.getDocument() == null || region == null) {
            return null;
        }
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    public String getHyperlinkText() {
        String validatorId = this.getValidatorId(this.getHyperlinkRegion());
        if (validatorId == null) {
            return MessageFormat.format(Messages.OpenA, JSFTextExtMessages.Validator);
        }
        return MessageFormat.format(JSFTextExtMessages.OpenValidatorForId, validatorId);
    }
}

