/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICoreBuilder;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.extension.CDIExtensionManager;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.BeansXMLDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.lib.ClassPathMonitor;
import org.jboss.tools.common.java.ParametedTypeFactory;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;

public class CDICoreNature
implements IProjectNature {
    public static String NATURE_ID = "org.jboss.tools.cdi.core.cdinature";
    IProject project = null;
    ICDIProject cdiProjectDelegate;
    ParametedTypeFactory typeFactory = new ParametedTypeFactory();
    ClassPathMonitor classPath = new ClassPathMonitor(this);
    DefinitionContext definitions = new DefinitionContext();
    ProjectValidationContext validationContext = null;
    boolean isBuilt = false;
    private boolean isStorageResolved = false;
    Set<CDICoreNature> dependsOn = new HashSet<CDICoreNature>();
    Set<CDICoreNature> usedBy = new HashSet<CDICoreNature>();
    private CDIExtensionManager extensions = new CDIExtensionManager();
    private CDIVersion version = CDIVersion.CDI_1_0;
    private int beanDiscoveryMode = 3;
    boolean isBuildOn = false;
    static String EXTERNAL_TOOL_BUILDER = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    public long fullBuildTime;
    public List<Long> statistics;
    boolean projectDependenciesLoaded = false;

    public CDICoreNature() {
        this.extensions.setProject(this);
        this.definitions.setProject(this);
    }

    public void configure() throws CoreException {
        this.addToBuildSpec(CDICoreBuilder.BUILDER_ID);
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec(CDICoreBuilder.BUILDER_ID);
        this.dispose();
    }

    public IProject getProject() {
        return this.project;
    }

    public IType getType(String qualifiedName) {
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)this.getProject());
        if (jp == null) {
            return null;
        }
        try {
            return EclipseJavaUtil.findType((IJavaProject)jp, (String)qualifiedName);
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
            return null;
        }
    }

    public void setProject(IProject project) {
        this.project = project;
        this.classPath.init();
        this.updateVersion();
    }

    public CDIVersion getVersion() {
        return this.version;
    }

    public int getBeanDiscoveryMode() {
        return this.beanDiscoveryMode;
    }

    public void setBeanDiscoveryMode(int value) {
        this.beanDiscoveryMode = value;
    }

    boolean updateVersion() {
        CDIVersion version = CDIUtil.getCDIVersion(this.getProject());
        boolean changed = version != this.version;
        this.version = version;
        return changed;
    }

    public void setCDIProject(ICDIProject cdiProject) {
        this.cdiProjectDelegate = cdiProject;
        cdiProject.setNature(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CDICoreNature> getCDIProjects() {
        HashSet<CDICoreNature> result = new HashSet<CDICoreNature>();
        CDICoreNature cDICoreNature = this;
        synchronized (cDICoreNature) {
            result.addAll(this.dependsOn);
        }
        return result;
    }

    public synchronized int countDirectDependencies(Set<CDICoreNature> projects) {
        int result = 0;
        for (CDICoreNature r : this.dependsOn) {
            if (!projects.contains(r)) continue;
            ++result;
        }
        return result;
    }

    public CDIExtensionManager getExtensionManager() {
        return this.extensions;
    }

    public Set<CDICoreNature> getCDIProjects(boolean hierarchy) {
        if (hierarchy && this.dependsOnOtherProjects()) {
            HashSet<CDICoreNature> result = new HashSet<CDICoreNature>();
            this.getAllCDIProjects(result);
            return result;
        }
        return this.getCDIProjects();
    }

    synchronized void getAllCDIProjects(Set<CDICoreNature> result) {
        for (CDICoreNature n : this.dependsOn) {
            if (result.contains(n)) continue;
            result.add(n);
            n.getAllCDIProjects(result);
        }
    }

    public List<TypeDefinition> getAllTypeDefinitions() {
        if (!this.dependsOnOtherProjects()) {
            return this.getDefinitions().getTypeDefinitions();
        }
        List<TypeDefinition> ds = this.getDefinitions().getTypeDefinitions();
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        result.addAll(ds);
        HashSet<String> keys = new HashSet<String>();
        for (TypeDefinition d : ds) {
            keys.add(d.getKey());
        }
        for (CDICoreNature p : this.getCDIProjects(true)) {
            List<TypeDefinition> ds2 = p.getDefinitions().getTypeDefinitions();
            for (TypeDefinition d : ds2) {
                String key = d.getKey();
                if (keys.contains(key)) continue;
                keys.add(key);
                result.add(d);
            }
        }
        return result;
    }

    public synchronized boolean dependsOnOtherProjects() {
        return !this.dependsOn.isEmpty();
    }

    public List<AnnotationDefinition> getAllAnnotations() {
        return this.getDefinitions().getAllAnnotationsWithDependencies();
    }

    public Set<String> getAllVetoedTypes() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.definitions.getVetoedTypes());
        for (CDICoreNature n : this.getCDIProjects(true)) {
            result.addAll(n.getDefinitions().getVetoedTypes());
        }
        return result;
    }

    public Set<BeansXMLDefinition> getAllBeanXMLDefinitions() {
        if (!this.dependsOnOtherProjects()) {
            return this.getDefinitions().getBeansXMLDefinitions();
        }
        Set<BeansXMLDefinition> ds = this.getDefinitions().getBeansXMLDefinitions();
        HashSet<BeansXMLDefinition> result = new HashSet<BeansXMLDefinition>();
        result.addAll(ds);
        HashSet<IPath> paths = new HashSet<IPath>();
        for (BeansXMLDefinition d : ds) {
            IPath t = d.getPath();
            if (t == null) continue;
            paths.add(t);
        }
        for (CDICoreNature p : this.getCDIProjects(true)) {
            Set<BeansXMLDefinition> ds2 = p.getDefinitions().getBeansXMLDefinitions();
            for (BeansXMLDefinition d : ds2) {
                IPath t = d.getPath();
                if (t == null || paths.contains(t)) continue;
                paths.add(t);
                result.add(d);
            }
        }
        return result;
    }

    public Set<CDICoreNature> getDependentProjects() {
        return this.usedBy;
    }

    public CDICoreNature[] getAllDependentProjects(boolean resolve) {
        HashMap<CDICoreNature, Integer> set = new HashMap<CDICoreNature, Integer>();
        this.getAllDependentProjects(set, 0);
        if (resolve) {
            for (CDICoreNature n : set.keySet()) {
                n.resolve();
            }
        }
        CDICoreNature[] result = set.keySet().toArray(new CDICoreNature[set.size()]);
        Arrays.sort(result, new D(set));
        return result;
    }

    public CDICoreNature[] getAllDependentProjects() {
        return this.getAllDependentProjects(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllDependentProjects(Map<CDICoreNature, Integer> result, int level) {
        if (level > 10) {
            return;
        }
        CDICoreNature[] array = null;
        CDICoreNature cDICoreNature = this;
        synchronized (cDICoreNature) {
            array = this.usedBy.toArray(new CDICoreNature[0]);
        }
        CDICoreNature[] cDICoreNatureArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            CDICoreNature n3 = cDICoreNatureArray[n2];
            if (!result.containsKey(n3) || result.get(n3) < level) {
                result.put(n3, level);
                n3.getAllDependentProjects(result, level + 1);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCDIProject(final CDICoreNature p) {
        CDICoreNature cDICoreNature = this;
        synchronized (cDICoreNature) {
            if (this.dependsOn.contains(p)) {
                return;
            }
        }
        this.addUsedCDIProject(p);
        p.addDependentCDIProject(this);
        if (!p.isStorageResolved() && p.getProject() != null) {
            XJob.addRunnableWithPriority((XJob.XRunnable)new XJob.XRunnable(){

                public void run() {
                    p.resolve();
                    if (p.getDelegate() != null) {
                        p.getDelegate().update(true);
                    }
                }

                public String getId() {
                    return "Build CDI Project " + p.getProject().getName();
                }
            });
        }
    }

    public synchronized void removeCDIProject(CDICoreNature p) {
        if (!this.dependsOn.contains(p)) {
            return;
        }
        p.usedBy.remove(this);
        this.dependsOn.remove(p);
        this.definitions.clean(p.getProject());
    }

    synchronized void addUsedCDIProject(CDICoreNature p) {
        this.dependsOn.add(p);
    }

    public synchronized void addDependentCDIProject(CDICoreNature p) {
        this.usedBy.add(p);
    }

    public DefinitionContext getDefinitions() {
        return this.definitions;
    }

    public ICDIProject getDelegate() {
        return this.cdiProjectDelegate;
    }

    public ParametedTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public ClassPathMonitor getClassPath() {
        return this.classPath;
    }

    public boolean isStorageResolved() {
        return this.isStorageResolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveStorage(boolean load) {
        if (this.isStorageResolved) {
            return;
        }
        if (load) {
            this.load();
        } else {
            this.loadProjectDependenciesFromKBProject();
            CDICoreNature cDICoreNature = this;
            synchronized (cDICoreNature) {
                this.isStorageResolved = true;
            }
        }
    }

    public void resolve() {
        this.resolveStorage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.isStorageResolved) {
            return;
        }
        CDICoreNature cDICoreNature = this;
        synchronized (cDICoreNature) {
            if (this.isStorageResolved) {
                return;
            }
            this.isStorageResolved = true;
        }
        try {
            new CDICoreBuilder(this);
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        this.postponeFiring();
        try {
            this.loadProjectDependenciesFromKBProject();
        }
        finally {
            this.fireChanges();
        }
    }

    synchronized boolean requestForBuild() {
        if (this.isBuildOn) {
            try {
                this.wait(100000L);
            }
            catch (InterruptedException interruptedException) {
                CDICorePlugin.getDefault().logWarning("Interrupted waiting for build of " + this.project);
                this.notify();
                return false;
            }
        }
        if (!this.isBuildOn) {
            this.isBuildOn = true;
            return true;
        }
        CDICorePlugin.getDefault().logWarning("Could not wait for build of " + this.project);
        return false;
    }

    synchronized void releaseBuild() {
        this.isBuildOn = false;
        this.notify();
    }

    public void clean() {
        File file = this.getStorageFile();
        if (file != null && file.isFile()) {
            file.delete();
        }
        this.isBuilt = false;
        this.classPath.clean();
        this.postponeFiring();
        this.definitions.clean();
        if (this.cdiProjectDelegate != null) {
            this.cdiProjectDelegate.update(true);
        }
        this.fireChanges();
    }

    public void cleanTypeFactory() {
        CDICoreNature[] ps;
        this.typeFactory.clean();
        CDICoreNature[] cDICoreNatureArray = ps = this.getAllDependentProjects();
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            CDICoreNature n3 = cDICoreNatureArray[n2];
            n3.typeFactory.clean();
            ++n2;
        }
    }

    public void store() throws IOException {
        this.isBuilt = true;
        this.getStorageFile();
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand command = null;
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length && command == null) {
            if (commands[i].getBuilderName().equals(builderID)) {
                command = commands[i];
            }
            ++i;
        }
        if (command == null) {
            command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] oldCommands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            Object handle;
            String builderName = commands[i].getBuilderName();
            if (builderName.equals(builderID) || builderName.equals(EXTERNAL_TOOL_BUILDER) && (handle = commands[i].getArguments().get(LAUNCH_CONFIG_HANDLE)) != null && handle.toString().indexOf(builderID) >= 0) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    private File getStorageFile() {
        IPath path = CDICorePlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects/" + this.project.getName());
        return file;
    }

    public void clearStorage() {
        File f = this.getStorageFile();
        if (f == null || !f.exists()) {
            return;
        }
        FileUtil.clear((File)f);
        f.delete();
    }

    public boolean hasNoStorage() {
        if (this.isBuilt) {
            return false;
        }
        File f = this.getStorageFile();
        return f == null || !f.exists();
    }

    public void postponeFiring() {
    }

    public void fireChanges() {
    }

    public void pathRemoved(IPath source) {
        this.definitions.getWorkingCopy().clean(source);
    }

    public ProjectValidationContext getValidationContext() {
        if (this.validationContext == null) {
            this.validationContext = new ProjectValidationContext();
        }
        return this.validationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProjectDependencies() {
        CDICoreNature cDICoreNature = this;
        synchronized (cDICoreNature) {
            this.dependsOn.clear();
            this.usedBy.clear();
            this.projectDependenciesLoaded = false;
        }
        this.loadProjectDependenciesFromKBProject();
    }

    public void loadProjectDependencies() {
        this.loadProjectDependenciesFromKBProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProjectDependenciesFromKBProject() {
        if (this.projectDependenciesLoaded) {
            return;
        }
        CDICoreNature cDICoreNature = this;
        synchronized (cDICoreNature) {
            if (this.projectDependenciesLoaded) {
                return;
            }
            this.projectDependenciesLoaded = true;
        }
        this._loadProjectDependencies();
    }

    private void _loadProjectDependencies() {
        KbProject kb = (KbProject)KbProjectFactory.getKbProject((IProject)this.project, (boolean)true, (boolean)true);
        if (kb == null) {
            return;
        }
        for (KbProject kb1 : kb.getKbProjects()) {
            IProject project = kb1.getProject();
            if (project == null || !project.isAccessible()) continue;
            KbProjectFactory.getKbProject((IProject)project, (boolean)true, (boolean)true);
            CDICoreNature sp = CDICorePlugin.getCDI(project, false);
            if (sp == null) continue;
            this.addUsedCDIProject(sp);
            sp.addDependentCDIProject(this);
        }
        KbProject[] kbProjectArray = kb.getDependentKbProjects();
        int n = kbProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            KbProject kb2 = kbProjectArray[n2];
            IProject project = kb2.getProject();
            if (project != null && project.isAccessible()) {
                KbProjectFactory.getKbProject((IProject)project, (boolean)true, (boolean)true);
                CDICoreNature sp = CDICorePlugin.getCDI(project, false);
                if (sp != null) {
                    this.addDependentCDIProject(sp);
                }
            }
            ++n2;
        }
    }

    public synchronized void dispose() {
        CDICoreNature[] us;
        CDICoreNature[] ds;
        CDICoreNature[] cDICoreNatureArray = ds = this.dependsOn.toArray(new CDICoreNature[this.dependsOn.size()]);
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            CDICoreNature d = cDICoreNatureArray[n2];
            this.removeCDIProject(d);
            ++n2;
        }
        CDICoreNature[] cDICoreNatureArray2 = us = this.usedBy.toArray(new CDICoreNature[this.usedBy.size()]);
        int n3 = us.length;
        n = 0;
        while (n < n3) {
            CDICoreNature u = cDICoreNatureArray2[n];
            u.removeCDIProject(this);
            ++n;
        }
        this.classPath.dispose();
        this.definitions.clean();
        this.typeFactory.clean();
        if (this.cdiProjectDelegate instanceof CDIProject) {
            ((CDIProject)this.cdiProjectDelegate).dispose();
        }
        this.cdiProjectDelegate.setNature(null);
    }

    private static class D
    implements Comparator<CDICoreNature> {
        Map<CDICoreNature, Integer> set;

        D(Map<CDICoreNature, Integer> set) {
            this.set = set;
        }

        @Override
        public int compare(CDICoreNature o1, CDICoreNature o2) {
            return this.set.get(o1) - this.set.get(o2);
        }
    }
}

