/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.validation.ValidationSeverityPreferences;

public class CDIPreferences
extends ValidationSeverityPreferences {
    public static final Set<String> SEVERITY_OPTION_NAMES = new HashSet<String>();
    private static CDIPreferences INSTANCE = new CDIPreferences();
    public static final String WARNING_GROUP_ID = "cdi";
    public static final String STEREOTYPE_DECLARES_NON_EMPTY_NAME = INSTANCE.createSeverityOption("stereotypeDeclaresNonEmptyName", new String[]{"non-empty-named"});
    public static final String RESOURCE_PRODUCER_FIELD_SETS_EL_NAME = INSTANCE.createSeverityOption("resourceProducerFieldSetsElName", new String[]{"named-producer"});
    public static final String PARAM_INJECTION_DECLARES_EMPTY_NAME = INSTANCE.createSeverityOption("paramInjectionDeclaresEmptyName", new String[]{"empty-named"});
    public static final String INTERCEPTOR_OR_DECORATOR_HAS_NAME = INSTANCE.createSeverityOption("interceptorHasName", new String[]{"named"});
    public static final String AMBIGUOUS_EL_NAMES = INSTANCE.createSeverityOption("ambiguousElNames", new String[]{"ambiguous-name"});
    public static final String UNSATISFIED_OR_AMBIGUOUS_INJECTION_POINTS = INSTANCE.createSeverityOption("unsatisfiedInjectionPoints", new String[]{"ambiguous-dependency"});
    public static final String UNPROXYABLE_BEAN_TYPE = INSTANCE.createSeverityOption("unproxyableBeanType", new String[]{"ambiguous-dependency"});
    public static final String ILLEGAL_TYPE_IN_TYPED_DECLARATION = INSTANCE.createSeverityOption("illegalTypeInTypedDeclaration", new String[]{"typed"});
    public static final String PRODUCER_METHOD_RETURN_TYPE_HAS_WILDCARD_OR_VARIABLE = INSTANCE.createSeverityOption("producerMethodReturnTypeHasWildcard", new String[]{"typed-producer"});
    public static final String INJECT_RESOLVES_TO_NULLABLE_BEAN = INSTANCE.createSeverityOption("injectResolvesToNullableBean", new String[]{"nullable"});
    public static final String PRODUCER_FIELD_TYPE_DOES_NOT_MATCH_JAVA_EE_OBJECT = INSTANCE.createSeverityOption("producerFieldTypeDoesNotMatchJavaEeObject", new String[]{"not-match-object"});
    public static final String INJECTION_TYPE_IS_VARIABLE = INSTANCE.createSeverityOption("injectionTypeIsVariable", new String[]{"type-variable"});
    public static final String STEREOTYPE_IS_ANNOTATED_TYPED = INSTANCE.createSeverityOption("stereotypeIsAnnotatedTyped", new String[]{"typed"});
    public static final String MISSING_NONBINDING_IN_QUALIFIER_TYPE_MEMBER = INSTANCE.createSeverityOption("missingNonbindingInQualifierTypeMember", new String[]{"nonbinding"});
    public static final String MISSING_NONBINDING_IN_INTERCEPTOR_BINDING_TYPE_MEMBER = INSTANCE.createSeverityOption("missingNonbindingInInterceptorBindingTypeMember", new String[]{"nonbinding"});
    public static final String MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE = INSTANCE.createSeverityOption("missingOrIncorrectTargetOrRetentionInAnnotationType", new String[]{"target"});
    public static final String NOT_PASSIVATION_CAPABLE_BEAN = INSTANCE.createSeverityOption("notPassivationCapableBean", new String[]{"not-passivation-capable"});
    public static final String MULTIPLE_SCOPE_TYPE_ANNOTATIONS = INSTANCE.createSeverityOption("multipleScopeTypeAnnotations", new String[]{"multiple-scopes"});
    public static final String MISSING_SCOPE_WHEN_THERE_IS_NO_DEFAULT_SCOPE = INSTANCE.createSeverityOption("missingScopeWhenThereIsNoDefaultScope", new String[]{"default-scope"});
    public static final String STEREOTYPE_DECLARES_MORE_THAN_ONE_SCOPE = INSTANCE.createSeverityOption("stereotypeDeclaresMoreThanOneScope", new String[]{"multiple-scopes"});
    public static final String ILLEGAL_SCOPE_FOR_BEAN = INSTANCE.createSeverityOption("illegalScopeForManagedBean", new String[]{"scope"});
    public static final String ILLEGAL_SCOPE_WHEN_TYPE_INJECTIONPOINT_IS_INJECTED = INSTANCE.createSeverityOption("illegalScopeWhenTypeInjectionPointIsInjected", new String[]{"scope"});
    public static final String ILLEGAL_SCOPE_FOR_INTERCEPTOR_OR_DECORATOR = INSTANCE.createSeverityOption("illegalScopeForInterceptor", new String[]{"scope"});
    public static final String PRODUCER_ANNOTATED_INJECT = INSTANCE.createSeverityOption("producerAnnotatedInject", new String[]{"annotated-inject"});
    public static final String PRODUCER_PARAMETER_ILLEGALLY_ANNOTATED = INSTANCE.createSeverityOption("producerParameterIllegallyAnnotated", new String[]{"annotated-parameter"});
    public static final String OBSERVER_ANNOTATED_INJECT = INSTANCE.createSeverityOption("observerAnnotatedInject", new String[]{"annotated-observer"});
    public static final String OBSERVER_PARAMETER_ILLEGALLY_ANNOTATED = INSTANCE.createSeverityOption("observerParameterIllegallyAnnotated", new String[]{"annotated-parameter"});
    public static final String ILLEGAL_PRODUCER_METHOD_IN_SESSION_BEAN = INSTANCE.createSeverityOption("illegalProducerMethodInSessionBean", new String[]{"annotated-produces"});
    public static final String MULTIPLE_DISPOSING_PARAMETERS = INSTANCE.createSeverityOption("multipleDisposingParameters", new String[]{"multiple-disposes"});
    public static final String DISPOSER_ANNOTATED_INJECT = INSTANCE.createSeverityOption("disposerAnnotatedInject", new String[]{"annotated-disposer"});
    public static final String ILLEGAL_DISPOSER_IN_SESSION_BEAN = INSTANCE.createSeverityOption("illegalDisposerInSessionBean", new String[]{"annotated-disposer"});
    public static final String NO_PRODUCER_MATCHING_DISPOSER = INSTANCE.createSeverityOption("noProducerMatchingDisposer", new String[]{"missing-producer"});
    public static final String MULTIPLE_DISPOSERS_FOR_PRODUCER = INSTANCE.createSeverityOption("multipleDisposersForProducer", new String[]{"multiple-disposers"});
    public static final String MULTIPLE_INJECTION_CONSTRUCTORS = INSTANCE.createSeverityOption("multipleInjectionConstructors", new String[]{"constructor"});
    public static final String CONSTRUCTOR_PARAMETER_ILLEGALLY_ANNOTATED = INSTANCE.createSeverityOption("constructorParameterIllegallyAnnotated", new String[]{"constructor"});
    public static final String GENERIC_METHOD_ANNOTATED_INJECT = INSTANCE.createSeverityOption("genericMethodAnnotatedInject", new String[]{"generic"});
    public static final String MULTIPLE_OBSERVING_PARAMETERS = INSTANCE.createSeverityOption("multipleObservingParameters", new String[]{"multiple-observers"});
    public static final String ILLEGAL_OBSERVER_IN_SESSION_BEAN = INSTANCE.createSeverityOption("illegalObserverInSessionBean", new String[]{"observer"});
    public static final String ILLEGAL_CONDITIONAL_OBSERVER = INSTANCE.createSeverityOption("illegalConditionalObserver", new String[]{"observer"});
    public static final String BOTH_INTERCEPTOR_AND_DECORATOR = INSTANCE.createSeverityOption("bothInterceptorAndDecorator", new String[]{"interceptor-decorator"});
    public static final String SESSION_BEAN_ANNOTATED_INTERCEPTOR_OR_DECORATOR = INSTANCE.createSeverityOption("sessionBeanAnnotatedInterceptorOrDecorator", new String[]{"interceptor-decorator"});
    public static final String PRODUCER_IN_INTERCEPTOR_OR_DECORATOR = INSTANCE.createSeverityOption("producerInInterceptorOrDecorator", new String[]{"producer"});
    public static final String DISPOSER_IN_INTERCEPTOR_OR_DECORATOR = INSTANCE.createSeverityOption("disposerInInterceptorOrDecorator", new String[]{"disposer"});
    public static final String MULTIPLE_OR_MISSING_DELEGATE = INSTANCE.createSeverityOption("multipleDelegate", new String[]{"ambiguous-delegate"});
    public static final String ILLEGAL_INJECTION_POINT_DELEGATE = INSTANCE.createSeverityOption("illegalInjectionPointDelegate", new String[]{"delegate"});
    public static final String ILLEGAL_BEAN_DECLARING_DELEGATE = INSTANCE.createSeverityOption("illegalBeanDeclaringDelegate", new String[]{"delegate"});
    public static final String DELEGATE_HAS_ILLEGAL_TYPE = INSTANCE.createSeverityOption("delegateHasIllegalType", new String[]{"delegate-type"});
    public static final String ILLEGAL_LIFECYCLE_CALLBACK_INTERCEPTOR_BINDING = INSTANCE.createSeverityOption("illegalLifecycleCallbackInterceptorBinding", new String[]{"interceptor"});
    public static final String ILLEGAL_INTERCEPTOR_BINDING_METHOD = INSTANCE.createSeverityOption("illegalInterceptorBindingMethod", new String[]{"interceptor-binding"});
    public static final String CONFLICTING_INTERCEPTOR_BINDINGS = INSTANCE.createSeverityOption("conflictingInterceptorBindings", new String[]{"ambiguous-interceptor-binding"});
    public static final String OBSERVER_IN_INTERCEPTOR_OR_DECORATOR = INSTANCE.createSeverityOption("observerInInterceptorOrDecorator", new String[]{"observer"});
    public static final String INTERCEPTOR_OR_DECORATOR_IS_ALTERNATIVE = INSTANCE.createSeverityOption("interceptorOrDecoratorIsAlternative", new String[]{"alternative"});
    public static final String MISSING_INTERCEPTOR_BINDING = INSTANCE.createSeverityOption("missingInterceptorBinding", new String[]{"missing-interceptor-binding"});
    public static final String DECORATOR_RESOLVES_TO_FINAL_BEAN = INSTANCE.createSeverityOption("decoratorResolvesToFinalBean", new String[]{"final"});
    public static final String ILLEGAL_SPECIALIZING_BEAN = INSTANCE.createSeverityOption("illegalSpecializingManagedBean", new String[]{"static"});
    public static final String MISSING_TYPE_IN_SPECIALIZING_BEAN = INSTANCE.createSeverityOption("missingTypeInSpecializingBean", new String[]{"specializes"});
    public static final String CONFLICTING_NAME_IN_SPECIALIZING_BEAN = INSTANCE.createSeverityOption("conflictingNameInSpecializingBean", new String[]{"specializes-named"});
    public static final String INTERCEPTOR_ANNOTATED_SPECIALIZES = INSTANCE.createSeverityOption("interceptorAnnotatedSpecializes", new String[]{"specializes"});
    public static final String INCONSISTENT_SPECIALIZATION = INSTANCE.createSeverityOption("inconsistentSpecialization", new String[]{"inconsistent-specialization"});
    public static final String ILLEGAL_INJECTING_USERTRANSACTION_TYPE = INSTANCE.createSeverityOption("illegalInjectingUserTransactionType", new String[]{"user-transaction"});
    public static final String ILLEGAL_INJECTING_INJECTIONPOINT_TYPE = INSTANCE.createSeverityOption("illegalInjectingInjectionPointType", new String[]{"injection-point"});
    public static final String ILLEGAL_QUALIFIER_IN_STEREOTYPE = INSTANCE.createSeverityOption("illegalQualifierInStereotype", new String[]{"stereotype"});
    public static final String MISSING_BEANS_XML = INSTANCE.createSeverityOption("missingBeansXml");
    public static final String ILLEGAL_TYPE_NAME_IN_BEANS_XML = INSTANCE.createSeverityOption("illegalTypeInBeansXml");
    public static final String DUPLICATE_TYPE_IN_BEANS_XML = INSTANCE.createSeverityOption("duplicateTypeInBeansXml");

    public static CDIPreferences getInstance() {
        return INSTANCE;
    }

    private CDIPreferences() {
    }

    public String getWarningGroupID() {
        return WARNING_GROUP_ID;
    }

    protected String createSeverityOption(String shortName) {
        String name = String.valueOf(this.getPluginId()) + ".validator.problem." + shortName;
        SEVERITY_OPTION_NAMES.add(name);
        return name;
    }

    protected String getPluginId() {
        return "org.jboss.tools.cdi.core";
    }

    protected Set<String> getSeverityOptionNames() {
        return SEVERITY_OPTION_NAMES;
    }

    public static boolean shouldValidateCore(IProject project) {
        return true;
    }

    public static boolean shouldValidateBeansXml(IProject project) {
        return !"ignore".equals(INSTANCE.getProjectPreference(project, ILLEGAL_TYPE_NAME_IN_BEANS_XML)) || !"ignore".equals(INSTANCE.getProjectPreference(project, DUPLICATE_TYPE_IN_BEANS_XML));
    }

    public static boolean isValidationEnabled(IProject project) {
        return INSTANCE.isEnabled(project);
    }

    public static int getMaxNumberOfProblemMarkersPerFile(IProject project) {
        return INSTANCE.getMaxNumberOfProblemMarkersPerResource(project);
    }
}

