/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IInterceptorBindingDeclaration;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.CDIElement;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.StereotypeElement;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaReference;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ITypeDeclaration;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.TypeDeclaration;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.FileUtil;

public abstract class AbstractBeanElement
extends CDIElement
implements IAnnotated {
    protected AbstractMemberDefinition definition;

    @Override
    public boolean exists() {
        return this.getDefinition().exists();
    }

    public void setDefinition(AbstractMemberDefinition definition) {
        this.definition = definition;
    }

    public AbstractMemberDefinition getDefinition() {
        return this.definition;
    }

    public List<IAnnotationDeclaration> getAnnotations() {
        if (this.definition != null) {
            return this.definition.getAnnotations();
        }
        return Collections.emptyList();
    }

    public IAnnotationDeclaration getAnnotation(String annotationTypeName) {
        if (this.definition != null) {
            return this.definition.getAnnotation(annotationTypeName);
        }
        return null;
    }

    public IJavaSourceReference getAnnotationPosition(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName);
    }

    public boolean isAnnotationPresent(String annotationTypeName) {
        return this.definition != null && this.definition.isAnnotationPresent(annotationTypeName);
    }

    protected AnnotationDeclaration findNamedAnnotation() {
        AnnotationDeclaration named = this.getDefinition().getNamedAnnotation();
        if (named != null) {
            return named;
        }
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations(true)) {
            StereotypeElement s = (StereotypeElement)d.getStereotype();
            if (s == null || s.getNameDeclaration() == null) continue;
            return s.getNameDeclaration();
        }
        return null;
    }

    public boolean isAlternative() {
        if (this.getDefinition().getAlternativeAnnotation() != null) {
            return true;
        }
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            IStereotype s = d.getStereotype();
            if (s == null || !s.isAlternative()) continue;
            return true;
        }
        return false;
    }

    public Collection<IStereotypeDeclaration> getStereotypeDeclarations() {
        return this.getStereotypeDeclarations(false);
    }

    public Collection<IStereotypeDeclaration> getStereotypeDeclarations(boolean includeInherited) {
        HashSet<IStereotypeDeclaration> result = new HashSet<IStereotypeDeclaration>();
        HashSet<IStereotype> ss = new HashSet<IStereotype>();
        for (IAnnotationDeclaration d : this.definition.getAnnotations()) {
            if (!(d instanceof IStereotypeDeclaration)) continue;
            IStereotypeDeclaration sd = (IStereotypeDeclaration)d;
            result.add(sd);
            if (sd.getStereotype() == null) continue;
            ss.add(sd.getStereotype());
        }
        HashSet<IStereotypeDeclaration> delta1 = result;
        HashSet<IStereotypeDeclaration> delta2 = new HashSet<IStereotypeDeclaration>();
        while (!delta1.isEmpty()) {
            for (IStereotypeDeclaration d : delta1) {
                IStereotype s = d.getStereotype();
                if (s == null) continue;
                for (IStereotypeDeclaration d1 : s.getStereotypeDeclarations()) {
                    if (d1.getStereotype() == null || result.contains(d1) || delta2.contains(d1)) continue;
                    delta2.add(d1);
                }
            }
            if (delta2.isEmpty()) break;
            for (IStereotypeDeclaration d : delta2) {
                result.add(d);
                if (d.getStereotype() == null) continue;
                ss.add(d.getStereotype());
            }
            delta1 = delta2;
            delta2 = new HashSet();
        }
        if (includeInherited) {
            Set<IStereotypeDeclaration> ds = this.getInheritedStereotypDeclarations();
            for (IStereotypeDeclaration d : ds) {
                if (d.getStereotype() == null || ss.contains(d.getStereotype())) continue;
                result.add(d);
            }
        }
        return result;
    }

    public Set<IStereotypeDeclaration> getInheritedStereotypDeclarations() {
        return Collections.emptySet();
    }

    public Collection<IQualifierDeclaration> getQualifierDeclarations() {
        return this.getQualifierDeclarations(false);
    }

    public Collection<IQualifierDeclaration> getQualifierDeclarations(boolean includeInherited) {
        ArrayList<IQualifierDeclaration> result = new ArrayList<IQualifierDeclaration>();
        HashSet<IQualifier> qs = new HashSet<IQualifier>();
        for (IAnnotationDeclaration a : this.definition.getAnnotations()) {
            if (!(a instanceof IQualifierDeclaration)) continue;
            IQualifierDeclaration q = (IQualifierDeclaration)a;
            result.add(q);
            if (q.getQualifier() == null) continue;
            qs.add(q.getQualifier());
        }
        if (includeInherited) {
            for (IQualifierDeclaration d : this.getInheritedQualifierDeclarations()) {
                if (d.getQualifier() == null || qs.contains(d.getQualifier())) continue;
                result.add(d);
            }
        }
        return result;
    }

    protected Collection<IQualifierDeclaration> getInheritedQualifierDeclarations() {
        return Collections.emptyList();
    }

    protected Collection<IInterceptorBindingDeclaration> getInheritedInterceptorBindingDeclarations() {
        return Collections.emptyList();
    }

    public Collection<IQualifier> getQualifiers() {
        IQualifier any = this.getCDIProject().getQualifier("javax.enterprise.inject.Any");
        IQualifier def = this.getCDIProject().getQualifier("javax.enterprise.inject.Default");
        IQualifier name = this.getCDIProject().getQualifier("javax.inject.Named");
        HashSet<IQualifier> result = new HashSet<IQualifier>();
        for (IQualifierDeclaration d : this.getQualifierDeclarations(true)) {
            IQualifier q = d.getQualifier();
            if (q == null) continue;
            result.add(q);
        }
        if (this instanceof IInjectionPoint) {
            if (def != null && result.isEmpty()) {
                result.add(def);
            }
        } else if (this instanceof IBean) {
            if (def != null && (result.isEmpty() || name != null && result.size() == 1 && result.contains(name))) {
                result.add(def);
            }
            if (any != null) {
                result.add(any);
            }
        }
        return result;
    }

    public Collection<IInterceptorBindingDeclaration> getInterceptorBindingDeclarations(boolean includeInherited) {
        Collection<IInterceptorBindingDeclaration> result = ClassBean.getInterceptorBindingDeclarations(this.definition);
        if (includeInherited) {
            HashSet<IInterceptorBinding> qs = new HashSet<IInterceptorBinding>();
            for (IInterceptorBindingDeclaration d : result) {
                if (d.getInterceptorBinding() == null) continue;
                qs.add(d.getInterceptorBinding());
            }
            for (IInterceptorBindingDeclaration d : this.getInheritedInterceptorBindingDeclarations()) {
                if (d.getInterceptorBinding() == null || qs.contains(d.getInterceptorBinding())) continue;
                result.add(d);
            }
        }
        return result;
    }

    public Collection<IScopeDeclaration> getScopeDeclarations() {
        return AbstractBeanElement.getScopeDeclarations(this.getCDIProject().getNature(), this.definition.getAnnotations());
    }

    public static Collection<IScopeDeclaration> getScopeDeclarations(CDICoreNature n, List<? extends IAnnotationDeclaration> ds) {
        ArrayList<IScopeDeclaration> result = new ArrayList<IScopeDeclaration>(1);
        for (IAnnotationDeclaration iAnnotationDeclaration : ds) {
            int k = n.getDefinitions().getAnnotationKind(iAnnotationDeclaration.getType());
            if (k <= 0 || (k & 0x20) <= 0 || !(iAnnotationDeclaration instanceof IScopeDeclaration)) continue;
            result.add((IScopeDeclaration)iAnnotationDeclaration);
        }
        return result;
    }

    public Collection<ITypeDeclaration> getRestrictedTypeDeclarations(Collection<IParametedType> alltypes) {
        AnnotationDeclaration typed = this.getDefinition().getTypedAnnotation();
        if (typed == null) {
            return new ArrayList<ITypeDeclaration>(0);
        }
        HashMap<String, IParametedType> map = new HashMap<String, IParametedType>();
        for (IParametedType t : alltypes) {
            map.put(t.getType().getFullyQualifiedName(), t);
        }
        ArrayList<ITypeDeclaration> result = new ArrayList<ITypeDeclaration>();
        int s = typed.getStartPosition();
        int l = typed.getLength();
        try {
            IType declaringType;
            Object value;
            String txt = null;
            if (s >= 0 && typed.getResource() instanceof IFile) {
                String content;
                AbstractTypeDefinition td = this.getDefinition().getTypeDefinition();
                if (this.getDefinition().getOriginalDefinition() != null) {
                    ITextSourceReference r = this.getDefinition().getOriginalDefinition();
                    String content2 = FileUtil.readStream((IFile)((IFile)r.getResource()));
                    if (content2 != null && content2.length() > s + l) {
                        txt = content2.substring(s);
                    }
                } else if (td != null && (content = td.getContent()) != null && content.length() > s + l) {
                    txt = content.substring(s, s + l);
                }
            }
            if ((value = typed.getMemberValue(null)) == null) {
                return result;
            }
            IMember member = (IMember)this.definition.getMember();
            IType iType = declaringType = member instanceof IType ? (IType)member : member.getDeclaringType();
            if (value instanceof Object[]) {
                Object[] os = (Object[])value;
                int i = 0;
                while (i < os.length) {
                    ParametedType p;
                    String rawTypeName = os[i].toString();
                    String typeName = rawTypeName;
                    if (!typeName.endsWith(";")) {
                        typeName = "Q" + typeName + ";";
                    }
                    if ((p = this.getCDIProject().getNature().getTypeFactory().getParametedType((IMember)declaringType, typeName)) != null) {
                        IParametedType other;
                        int q;
                        int offset = 0;
                        int length = 0;
                        if (txt != null && (q = txt.indexOf(rawTypeName)) >= 0) {
                            offset = s + q;
                            length = rawTypeName.length();
                        }
                        IParametedType iParametedType = other = p.getType() == null ? null : (IParametedType)map.get(p.getType().getFullyQualifiedName());
                        if (other != null) {
                            String s2;
                            String s1 = p.getSignature();
                            if (!s1.equals(s2 = other.getSignature()) && Signature.getArrayCount((String)s1) == Signature.getArrayCount((String)s2)) {
                                p.setSignature(s2);
                            }
                            result.add((ITypeDeclaration)new TypeDeclaration((ParametedType)other, typed.getResource(), offset, length));
                        } else {
                            result.add((ITypeDeclaration)new TypeDeclaration(p, typed.getResource(), offset, length));
                        }
                    }
                    ++i;
                }
            } else if (value != null) {
                ParametedType p;
                String rawTypeName = value.toString();
                String typeName = rawTypeName;
                if (!typeName.endsWith(";")) {
                    typeName = "Q" + typeName + ";";
                }
                if ((p = this.getCDIProject().getNature().getTypeFactory().getParametedType((IMember)declaringType, typeName)) != null) {
                    IParametedType other;
                    int q;
                    int offset = 0;
                    int length = 0;
                    if (txt != null && (q = txt.indexOf(rawTypeName)) >= 0) {
                        offset = s + q;
                        length = rawTypeName.length();
                    }
                    IParametedType iParametedType = other = p.getType() == null ? null : (IParametedType)map.get(p.getType().getFullyQualifiedName());
                    if (other != null) {
                        String s2;
                        String s1 = p.getSignature();
                        if (!s1.equals(s2 = other.getSignature()) && Signature.getArrayCount((String)s1) == Signature.getArrayCount((String)s2)) {
                            p.setSignature(s2);
                        }
                        result.add((ITypeDeclaration)new TypeDeclaration((ParametedType)other, typed.getResource(), offset, length));
                    } else {
                        result.add((ITypeDeclaration)new TypeDeclaration(p, typed.getResource(), offset, length));
                    }
                }
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return result;
    }

    public void open() {
        if (this.getDefinition().getOriginalDefinition() != null) {
            ObjectMultiPageEditor mpe;
            ITextEditor textEditor;
            IEditorPart part = null;
            ITextSourceReference source = this.getDefinition().getOriginalDefinition();
            IFile resource = (IFile)source.getResource();
            IWorkbenchWindow window = CDICorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            try {
                part = IDE.openEditor((IWorkbenchPage)page, (IFile)resource);
            }
            catch (PartInitException e) {
                CDICorePlugin.getDefault().logError(e);
            }
            if (part instanceof EditorPartWrapper) {
                part = ((EditorPartWrapper)part).getEditor();
            }
            if (part instanceof ObjectMultiPageEditor && (textEditor = (ITextEditor)(mpe = (ObjectMultiPageEditor)part).getAdapter(ITextEditor.class)) != null) {
                mpe.setActiveEditor((IEditorPart)textEditor);
                part = textEditor;
            }
            if (part != null) {
                part.getEditorSite().getSelectionProvider().setSelection((ISelection)new TextSelection(source.getStartPosition(), source.getLength()));
            }
        } else if (this instanceof IJavaReference) {
            IMember member = ((IJavaReference)this).getSourceMember();
            try {
                JavaUI.openInEditor((IJavaElement)member);
            }
            catch (PartInitException e) {
                CommonPlugin.getDefault().logError((Throwable)e);
            }
            catch (JavaModelException e) {
                CommonPlugin.getDefault().logError((Throwable)e);
            }
        }
    }
}

