/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.internal.core.impl.CDIElement;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationMemberDefinition;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaSourceReference;

public class CDIAnnotationElement
extends CDIElement
implements ICDIAnnotation,
IAnnotated {
    protected AnnotationDefinition definition;
    Collection<IMethod> nonbindingMethods = null;

    public void setDefinition(AnnotationDefinition definition) {
        this.definition = definition;
    }

    public AnnotationDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public Collection<IMethod> getNonBindingMethods() {
        if (this.nonbindingMethods == null) {
            AbstractCollection result = new ArrayList<IMethod>();
            for (AnnotationMemberDefinition m : this.definition.getMethods()) {
                if (m.getNonbindingAnnotation() == null) continue;
                result.add(m.getMethod());
            }
            if (result.size() > 5) {
                result = new HashSet<IMethod>(result);
            }
            this.nonbindingMethods = result;
        }
        return this.nonbindingMethods;
    }

    public IType getSourceType() {
        return this.definition.getType();
    }

    @Override
    public IAnnotationDeclaration getInheritedDeclaration() {
        return this.definition.getInheritedAnnotation();
    }

    public List<IAnnotationDeclaration> getAnnotationDeclarations() {
        ArrayList<IAnnotationDeclaration> result = new ArrayList<IAnnotationDeclaration>();
        result.addAll(this.definition.getAnnotations());
        return result;
    }

    public IAnnotationDeclaration getAnnotationDeclaration(String typeName) {
        return this.definition.getAnnotation(typeName);
    }

    public List<IAnnotationDeclaration> getAnnotations() {
        return this.definition.getAnnotations();
    }

    public IAnnotationDeclaration getAnnotation(String annotationTypeName) {
        return this.definition.getAnnotation(annotationTypeName);
    }

    public IJavaSourceReference getAnnotationPosition(String annotationTypeName) {
        return this.definition.getAnnotationPosition(annotationTypeName);
    }

    public boolean isAnnotationPresent(String annotationTypeName) {
        return this.definition.isAnnotationPresent(annotationTypeName);
    }

    public String toString() {
        String type = this.getSourceType() == null ? "" : this.getSourceType().getFullyQualifiedName();
        return String.valueOf(super.toString()) + " type=" + type;
    }

    @Override
    public String getElementName() {
        return this.definition.getType().getElementName();
    }
}

