/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IExcluded;

public class Excluded
implements IExcluded {
    static List<String> EMPTY = new ArrayList<String>();
    private Filter filter = NoTypeFilter.INSTANCE;
    private List<String> typesAvailable = EMPTY;
    private List<String> typesNotAvailable = EMPTY;
    private IPath source = null;

    public Excluded(IPath source) {
        this.source = source;
    }

    @Override
    public IPath getSource() {
        return this.source;
    }

    @Override
    public boolean isExcluded(String typeName) {
        return this.filter.isExcluded(typeName);
    }

    @Override
    public boolean isEnabled(ICDIProject project) {
        IType type;
        for (String typeName : this.typesAvailable) {
            type = project.getNature().getType(typeName);
            if (type != null && type.exists()) continue;
            return false;
        }
        for (String typeName : this.typesNotAvailable) {
            type = project.getNature().getType(typeName);
            if (type == null || !type.exists()) continue;
            return false;
        }
        return true;
    }

    public void setFilter(String filter) {
        if (filter.equals("**")) {
            this.filter = AnyTypeFilter.INSTANCE;
        } else if (filter.equals("*")) {
            this.filter = DefaultTypeFilter.INSTANCE;
        } else if (filter.endsWith("**")) {
            this.filter = new ParentPackageFilter();
            this.filter.setValue(filter.substring(0, filter.length() - 2));
        } else if (filter.endsWith("*")) {
            this.filter = new CurrentPackageFilter();
            this.filter.setValue(filter.substring(0, filter.length() - 1));
        } else {
            this.filter = new ExactTypeFilter();
            this.filter.setValue(filter);
        }
    }

    public void addAvailableType(String typeName) {
        if (this.typesAvailable == EMPTY) {
            this.typesAvailable = new ArrayList<String>();
        }
        this.typesAvailable.add(typeName);
    }

    public void addNotAvailableType(String typeName) {
        if (this.typesNotAvailable == EMPTY) {
            this.typesNotAvailable = new ArrayList<String>();
        }
        this.typesNotAvailable.add(typeName);
    }

    static class AnyTypeFilter
    extends Filter {
        static Filter INSTANCE = new AnyTypeFilter();

        AnyTypeFilter() {
        }

        @Override
        public boolean isExcluded(String typeName) {
            return true;
        }
    }

    static class CurrentPackageFilter
    extends Filter {
        CurrentPackageFilter() {
        }

        @Override
        public boolean isExcluded(String typeName) {
            return typeName.startsWith(this.value) && typeName.lastIndexOf(46) == this.value.length() - 1;
        }
    }

    static class DefaultTypeFilter
    extends Filter {
        static Filter INSTANCE = new DefaultTypeFilter();

        DefaultTypeFilter() {
        }

        @Override
        public boolean isExcluded(String typeName) {
            return typeName.indexOf(46) < 0;
        }
    }

    static class ExactTypeFilter
    extends Filter {
        ExactTypeFilter() {
        }

        @Override
        public boolean isExcluded(String typeName) {
            return this.value.equals(typeName);
        }
    }

    static abstract class Filter {
        protected String value;

        public void setValue(String value) {
            this.value = value;
        }

        public abstract boolean isExcluded(String var1);

        public int hashCode() {
            return this.getClass().hashCode() + (this.value == null ? 0 : 10 * this.value.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            if (this.getClass() != other.getClass()) {
                return false;
            }
            return this.value == null ? other.value == null : this.value.equals(other.value);
        }
    }

    static class NoTypeFilter
    extends Filter {
        static Filter INSTANCE = new AnyTypeFilter();

        NoTypeFilter() {
        }

        @Override
        public boolean isExcluded(String typeName) {
            return false;
        }
    }

    static class ParentPackageFilter
    extends Filter {
        ParentPackageFilter() {
        }

        @Override
        public boolean isExcluded(String typeName) {
            return typeName.startsWith(this.value);
        }
    }
}

