/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IInterceptorBindingDeclaration;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.CDIAnnotationElement;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.ProducerField;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaSourceReference;

public class StereotypeElement
extends CDIAnnotationElement
implements IStereotype {
    public AnnotationDeclaration getAlternativeDeclaration() {
        return this.definition.getAlternativeAnnotation();
    }

    public AnnotationDeclaration getNameDeclaration() {
        return this.definition.getNamedAnnotation();
    }

    @Override
    public Collection<IInterceptorBindingDeclaration> getInterceptorBindingDeclarations(boolean includeInherited) {
        return ClassBean.getInterceptorBindingDeclarations(this.definition);
    }

    @Override
    public Collection<IInterceptorBinding> getInterceptorBindings() {
        return CDIUtil.getAllInterceptorBindings(this);
    }

    @Override
    public Collection<IStereotypeDeclaration> getStereotypeDeclarations() {
        ArrayList<IStereotypeDeclaration> result = new ArrayList<IStereotypeDeclaration>();
        for (IAnnotationDeclaration d : this.definition.getAnnotations()) {
            if (!(d instanceof IStereotypeDeclaration)) continue;
            result.add((IStereotypeDeclaration)d);
        }
        return result;
    }

    @Override
    public boolean isAlternative() {
        if (this.getAlternativeDeclaration() != null) {
            return true;
        }
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            IStereotype s = d.getStereotype();
            if (s == null || !s.isAlternative()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IScope getScope() {
        Collection<IScopeDeclaration> ss = this.getScopeDeclarations();
        if (!ss.isEmpty()) {
            return ss.iterator().next().getScope();
        }
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            IStereotype s = d.getStereotype();
            IScope result = s.getScope();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Collection<IScopeDeclaration> getScopeDeclarations() {
        return ProducerField.getScopeDeclarations(this.getCDIProject().getNature(), this.definition.getAnnotations());
    }

    @Override
    public List<IAnnotationDeclaration> getAnnotations() {
        if (this.definition != null) {
            return this.definition.getAnnotations();
        }
        return Collections.emptyList();
    }

    @Override
    public IAnnotationDeclaration getAnnotation(String annotationTypeName) {
        if (this.definition != null) {
            return this.definition.getAnnotation(annotationTypeName);
        }
        return null;
    }

    @Override
    public IJavaSourceReference getAnnotationPosition(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName);
    }

    @Override
    public boolean isAnnotationPresent(String annotationTypeName) {
        return this.definition != null && this.definition.isAnnotationPresent(annotationTypeName);
    }
}

