/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.InterceptorBindingDeclaration;
import org.jboss.tools.cdi.internal.core.impl.QualifierDeclaration;
import org.jboss.tools.cdi.internal.core.impl.ScopeDeclaration;
import org.jboss.tools.cdi.internal.core.impl.StereotypeDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.EmptyMap;
import org.jboss.tools.cdi.internal.core.impl.definition.IAnnotationMap;
import org.jboss.tools.cdi.internal.core.impl.definition.PackageDefinition;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.java.impl.JavaAnnotation;
import org.jboss.tools.common.text.ITextSourceReference;

public abstract class AbstractMemberDefinition
implements IAnnotated {
    public static int FLAG_NO_ANNOTATIONS = 1;
    public static int FLAG_ALL_MEMBERS = 2;
    CDICoreNature project;
    protected List<IAnnotationDeclaration> annotations = new ArrayList<IAnnotationDeclaration>(2);
    protected IAnnotatable member;
    private IAnnotationMap annotationsByType = EmptyMap.instance;
    protected ITextSourceReference originalDefinition = null;

    protected void setAnnotatable(IAnnotatable member, IType contextType, IRootDefinitionContext context, int flags) {
        this.member = member;
        try {
            this.init(contextType, context, flags);
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    public CDICoreNature getDeclaringProject() {
        return this.project;
    }

    public void setOriginalDefinition(ITextSourceReference def) {
        this.originalDefinition = def;
    }

    public IAnnotatable getMember() {
        return this.member;
    }

    public AbstractTypeDefinition getTypeDefinition() {
        return null;
    }

    public PackageDefinition getPackageDefinition() {
        PackageDefinition result = null;
        AbstractTypeDefinition t = this.getTypeDefinition();
        if (t != null) {
            String qn = t.getQualifiedName();
            int d = qn.lastIndexOf(46);
            String packageName = d < 0 ? "" : qn.substring(0, d);
            result = this.project.getDefinitions().getPackageDefinition(packageName);
        }
        return result;
    }

    protected void init(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        this.project = context.getProject();
        if ((flags & FLAG_NO_ANNOTATIONS) == 0) {
            IAnnotation[] ts = this.member.getAnnotations();
            int i = 0;
            while (i < ts.length) {
                JavaAnnotation ja = new JavaAnnotation(ts[i], contextType);
                this.addAnnotation((IJavaAnnotation)ja, context);
                ++i;
            }
        }
    }

    public void addAnnotation(IJavaAnnotation ja, IRootDefinitionContext context) {
        AnnotationDeclaration a = new AnnotationDeclaration();
        a.setProject(context.getProject());
        a.setDeclaration(ja);
        this.addAnnotation(a, context);
        this.addDependency((IMember)ja.getType(), context);
    }

    protected void addDependency(IMember reference, IRootDefinitionContext context) {
        if (reference == null || reference.isBinary()) {
            return;
        }
        IResource resource = this.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile target = (IFile)resource;
        IFile source = (IFile)reference.getResource();
        if (target.exists() && source != null && source.exists()) {
            context.addDependency(source.getFullPath(), target.getFullPath());
        }
    }

    private void addAnnotation(AnnotationDeclaration a, IRootDefinitionContext context) {
        AnnotationDeclaration b = null;
        int kind = context.getAnnotationKind(a.getType());
        if (kind > 0 && (kind & 8) > 0) {
            b = new StereotypeDeclaration(a);
            this.annotations.add((IAnnotationDeclaration)b);
        }
        if (kind > 0 && (kind & 0x10) > 0) {
            b = new InterceptorBindingDeclaration(a);
            this.annotations.add((IAnnotationDeclaration)b);
        }
        if (kind > 0 && (kind & 4) > 0) {
            b = new QualifierDeclaration(a);
            this.annotations.add((IAnnotationDeclaration)b);
        }
        if (kind > 0 && (kind & 0x20) > 0) {
            b = new ScopeDeclaration(a);
            this.annotations.add((IAnnotationDeclaration)b);
        }
        if (b == null) {
            this.annotations.add((IAnnotationDeclaration)a);
        } else {
            a = b;
        }
        if (a.getTypeName() != null) {
            this.annotationsByType = this.annotationsByType.put(a.getTypeName(), a);
        }
    }

    public void annotationKindChanged(String typeName, IRootDefinitionContext context) {
        AnnotationDeclaration a = this.getAnnotation(typeName);
        if (a == null) {
            return;
        }
        Iterator<IAnnotationDeclaration> it = this.annotations.iterator();
        while (it.hasNext()) {
            IAnnotationDeclaration a1 = it.next();
            if (!typeName.equals(a1.getTypeName())) continue;
            it.remove();
        }
        this.addAnnotation(new AnnotationDeclaration(a), context);
    }

    public void removeAnnotation(IAnnotationDeclaration a) {
        String name = ((AnnotationDeclaration)a).getTypeName();
        AnnotationDeclaration b = this.getAnnotation(name);
        if (a == b) {
            this.annotationsByType = this.annotationsByType.remove(name);
            this.annotations.remove(a);
        }
    }

    public List<IAnnotationDeclaration> getAnnotations() {
        return this.annotations;
    }

    public AnnotationDeclaration getAnnotation(String typeName) {
        return this.annotationsByType.get(typeName);
    }

    public IJavaSourceReference getAnnotationPosition(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName);
    }

    public boolean isAnnotationPresent(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName) != null;
    }

    public AnnotationDeclaration getNamedAnnotation() {
        return this.getAnnotation("javax.inject.Named");
    }

    public AnnotationDeclaration getTypedAnnotation() {
        return this.getAnnotation("javax.enterprise.inject.Typed");
    }

    public AnnotationDeclaration getAlternativeAnnotation() {
        return this.getAnnotation("javax.enterprise.inject.Alternative");
    }

    public AnnotationDeclaration getSpecializesAnnotation() {
        return this.getAnnotation("javax.enterprise.inject.Specializes");
    }

    public IResource getResource() {
        return ((IJavaElement)this.member).getResource();
    }

    public ITextSourceReference getOriginalDefinition() {
        return this.originalDefinition;
    }

    public boolean exists() {
        return this.member instanceof IJavaElement && ((IJavaElement)this.member).exists();
    }
}

