/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDICoreMessages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.internal.core.refactoring.CDIRefactoringProcessor;
import org.jboss.tools.cdi.internal.core.refactoring.ValuedQualifier;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.refactoring.FileChangeFactory;

public class AddQualifiersToBeanProcessor
extends CDIRefactoringProcessor {
    protected IBean selectedBean;
    protected IInjectionPoint injectionPoint;
    protected List<IBean> beans;
    protected ArrayList<ValuedQualifier> qualifiers;

    public AddQualifiersToBeanProcessor(String label, IInjectionPoint injectionPoint, List<IBean> beans, IBean bean) {
        super(label);
        this.selectedBean = bean;
        this.injectionPoint = injectionPoint;
        this.beans = beans;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.status = new RefactoringStatus();
        if (this.injectionPoint == null) {
            this.status.addFatalError(CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_INJECTION_POINT_NOT_FOUND);
            return this.status;
        }
        IFile injectionPointFile = (IFile)this.injectionPoint.getClassBean().getResource();
        this.isFileCorrect(injectionPointFile);
        return this.status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        if (this.selectedBean == null) {
            this.status.addFatalError(CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_BEAN_NOT_FOUND);
            return this.status;
        }
        IFile beanFile = (IFile)this.selectedBean.getBeanClass().getResource();
        if (!this.isFileCorrect(beanFile)) {
            return this.status;
        }
        return this.status;
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.rootChange = new CompositeChange(this.getLabel());
        IFile file = (IFile)this.selectedBean.getBeanClass().getResource();
        ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)file);
        if (original == null) {
            return this.rootChange;
        }
        ICompilationUnit compilationUnit = original.getWorkingCopy(pm);
        TextFileChange fileChange = FileChangeFactory.getFileChange((IFile)file);
        MultiTextEdit edit = new MultiTextEdit();
        CDIMarkerResolutionUtils.addQualifiersToBean(this.qualifiers, this.selectedBean, compilationUnit, edit);
        IFile file2 = (IFile)this.injectionPoint.getClassBean().getResource();
        ICompilationUnit original2 = this.injectionPoint.getClassBean().getBeanClass().getCompilationUnit();
        ICompilationUnit compilationUnit2 = original2.getWorkingCopy(pm);
        if (!original.equals(original2)) {
            compilationUnit.discardWorkingCopy();
            if (edit.getChildrenSize() > 0) {
                fileChange.setEdit((TextEdit)edit);
                this.rootChange.add((Change)fileChange);
            }
            fileChange = FileChangeFactory.getFileChange((IFile)file2);
            edit = new MultiTextEdit();
        } else {
            compilationUnit2 = compilationUnit;
        }
        CDIMarkerResolutionUtils.addQualifiersToInjectionPoint(this.qualifiers, this.injectionPoint, compilationUnit2, edit);
        if (edit.getChildrenSize() > 0) {
            fileChange.setEdit((TextEdit)edit);
            this.rootChange.add((Change)fileChange);
        }
        compilationUnit.discardWorkingCopy();
        return this.rootChange;
    }

    @Override
    protected void createRootChange() {
    }

    public IBean getSelectedBean() {
        return this.selectedBean;
    }

    public IInjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public List<IBean> getBeans() {
        return this.beans;
    }

    public void setSelectedBean(IBean bean) {
        this.selectedBean = bean;
    }

    public void setDeployedQualifiers(ArrayList<ValuedQualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }
}

