/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;

public class ValuedQualifier {
    private IQualifier qualifier;
    private List<Pair> pairs = new ArrayList<Pair>();

    public ValuedQualifier(IQualifier qualifier, IQualifierDeclaration declaration) {
        this.qualifier = qualifier;
        if (declaration != null) {
            IMemberValuePair[] iMemberValuePairArray = declaration.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair mvp = iMemberValuePairArray[n2];
                Pair pair = new Pair();
                pair.name = mvp.getMemberName();
                pair.value = mvp.getValue();
                if (mvp.getValueKind() == 9) {
                    pair.type = "String";
                } else if (mvp.getValueKind() == 4) {
                    pair.type = "char";
                } else if (mvp.getValueKind() == 11) {
                    pair.type = "Class";
                } else if (mvp.getValueKind() == 8) {
                    pair.type = "boolean";
                } else if (mvp.getValueKind() == 2) {
                    pair.type = "byte";
                } else if (mvp.getValueKind() == 6) {
                    pair.type = "double";
                } else if (mvp.getValueKind() == 5) {
                    pair.type = "float";
                } else if (mvp.getValueKind() == 1) {
                    pair.type = "int";
                } else if (mvp.getValueKind() == 7) {
                    pair.type = "long";
                } else if (mvp.getValueKind() == 12) {
                    pair.type = "name";
                } else if (mvp.getValueKind() == 3) {
                    pair.type = "short";
                } else if (mvp.getValueKind() == 13) {
                    pair.type = "name";
                }
                this.pairs.add(pair);
                ++n2;
            }
        } else {
            IType type = qualifier.getSourceType();
            try {
                if (type.isAnnotation()) {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IMethod method = iMethodArray[n3];
                        IMemberValuePair mvp = method.getDefaultValue();
                        Pair pair = new Pair();
                        pair.type = Signature.getSignatureSimpleName((String)method.getReturnType());
                        pair.name = method.getElementName();
                        if (mvp != null && mvp.getValue() != null) {
                            pair.value = mvp.getValue();
                            pair.required = false;
                        } else {
                            pair.required = true;
                            pair.value = pair.type.equals("boolean") ? "false" : (pair.type.equals("int") || pair.type.equals("short") || pair.type.equals("long") ? "0" : (pair.type.equals("float") ? "0" : (pair.type.equals("double") ? "0.0" : (pair.type.equals("char") ? Character.valueOf(' ') : (pair.type.equals("byte") ? "0" : (pair.type.equals("String") ? "default" : "String"))))));
                        }
                        this.pairs.add(pair);
                        ++n3;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public ValuedQualifier(IQualifier qualifier) {
        this(qualifier, null);
    }

    public boolean isEditable() {
        for (Pair pair : this.pairs) {
            if (!pair.name.equals("value") || !pair.type.equals("String")) continue;
            return true;
        }
        return false;
    }

    public List<Pair> getValuePairs() {
        return this.pairs;
    }

    public IQualifier getQualifier() {
        return this.qualifier;
    }

    public String getValue() {
        return this.generateValue();
    }

    public Object getValue(String name) {
        for (Pair pair : this.pairs) {
            if (!pair.name.equals(name)) continue;
            return pair.value;
        }
        return null;
    }

    public String getStringValue() {
        for (Pair pair : this.pairs) {
            if (!pair.name.equals("value") || !pair.type.equals("String")) continue;
            return (String)pair.value;
        }
        return "";
    }

    private String generateValue() {
        String text = "";
        boolean first = true;
        for (Pair pair : this.pairs) {
            if (!pair.required) continue;
            if (!first) {
                text = String.valueOf(text) + ", ";
            }
            if (!"value".equals(pair.name) || this.pairs.size() > 1) {
                text = String.valueOf(text) + pair.name + " = ";
            }
            if ("char".equals(pair.type)) {
                text = String.valueOf(text) + "'" + pair.value + "'";
            } else if ("String".equals(pair.type)) {
                text = String.valueOf(text) + "\"" + pair.value + "\"";
            } else {
                text = String.valueOf(text) + pair.value;
                if (!CDIMarkerResolutionUtils.primitives.contains(pair.type)) {
                    text = String.valueOf(text) + ".class";
                }
            }
            first = false;
        }
        return text;
    }

    public void setValue(String name, String value) {
        for (Pair pair : this.pairs) {
            if (!pair.name.equals(name)) continue;
            pair.value = value;
            pair.required = true;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof ValuedQualifier && this.getQualifier().getSourceType().getFullyQualifiedName().equals(((ValuedQualifier)obj).getQualifier().getSourceType().getFullyQualifiedName());
    }

    public boolean fullyEquals(Object obj) {
        if (obj instanceof ValuedQualifier && this.getQualifier().getSourceType().getFullyQualifiedName().equals(((ValuedQualifier)obj).getQualifier().getSourceType().getFullyQualifiedName())) {
            for (Pair pair : ((ValuedQualifier)obj).getValuePairs()) {
                if (pair.value.equals(this.getValue(pair.name)) && pair.value != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class Pair {
        public boolean required = true;
        public String type = "";
        public String name = "";
        public Object value;

        private Pair() {
        }
    }
}

