/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.jsf.template.selectitem;

import org.jboss.tools.jsf.vpe.jsf.template.selectitem.AbstractSelectItemTemplate;
import org.jboss.tools.jsf.vpe.jsf.template.selectitem.SelectItemType;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractCheckboxSelectItemTemplate
extends AbstractSelectItemTemplate {
    private static final String TYPE_CHECKBOX = "checkbox";
    private String dir;
    private String disabled;
    private String enabledClass;
    private String disabledClass;

    protected AbstractCheckboxSelectItemTemplate(SelectItemType selectItemType) {
        super(selectItemType);
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        this.readParentAttributes(sourceNode.getParentNode());
        Element element = (Element)sourceNode;
        nsIDOMElement input = visualDocument.createElement("input");
        nsIDOMElement label = visualDocument.createElement("label");
        nsIDOMElement div = visualDocument.createElement("div");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)div);
        div.setAttribute("title", this.getTitle(sourceNode));
        input.setAttribute("type", TYPE_CHECKBOX);
        if (this.attrPresents(this.dir)) {
            input.setAttribute("dir", this.dir);
        }
        if (this.attrPresents(this.disabled) && "true".equalsIgnoreCase(this.disabled)) {
            label.setAttribute("class", this.disabledClass);
        } else if (this.attrPresents(this.enabledClass)) {
            label.setAttribute("class", this.enabledClass);
        }
        div.appendChild((nsIDOMNode)input);
        div.appendChild((nsIDOMNode)label);
        this.processOutputAttribute(pageContext, visualDocument, element, label, creationData);
        return creationData;
    }

    private boolean attrPresents(String attr) {
        return attr != null && attr.length() != 0;
    }

    private String getTitle(Node sourceNode) {
        String tagString = " <" + sourceNode.getNodeName();
        NamedNodeMap attrs = sourceNode.getAttributes();
        if (attrs != null) {
            tagString = String.valueOf(tagString) + (attrs.getLength() > 0 ? " " : "");
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                tagString = String.valueOf(tagString) + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"" + (i < attrs.getLength() - 1 ? " " : "");
                ++i;
            }
        }
        tagString = String.valueOf(tagString) + (sourceNode.hasChildNodes() ? "" : "/") + "> ";
        return tagString;
    }

    private void readParentAttributes(Node sourceNode) {
        if (sourceNode == null) {
            return;
        }
        Element source = (Element)sourceNode;
        this.dir = source.getAttribute("dir");
        this.disabled = source.getAttribute("disabled");
        this.enabledClass = source.getAttribute("enabledClass");
        this.disabledClass = source.getAttribute("disabledClass");
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

