/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.jsf.template.selectitem;

import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.jsf.vpe.jsf.template.selectitem.AbstractSelectItemTemplate;
import org.jboss.tools.jsf.vpe.jsf.template.selectitem.SelectItemType;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractRadioSelectItemTemplate
extends AbstractSelectItemTemplate {
    public static final String ITEM_DISABLED = "itemDisabled";
    private static final String ATTR_TYPE_VALUE = "radio";
    private static final String ATTR_NAME_VALUE = "radio_name_";
    private static final String SPAN_STYLE_VALUE = "-moz-user-modify: read-write;";
    private String dir;

    protected AbstractRadioSelectItemTemplate(SelectItemType selectItemType) {
        super(selectItemType);
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element element = (Element)sourceNode;
        nsIDOMElement div = visualDocument.createElement("div");
        boolean disabledItem = this.selectItemType.isDisabledItem(element);
        div.setAttribute("title", this.getTitle(sourceNode));
        nsIDOMElement radio = visualDocument.createElement("input");
        if (disabledItem) {
            radio.setAttribute(ITEM_DISABLED, "true");
        }
        nsIDOMElement label = visualDocument.createElement("label");
        if (disabledItem) {
            label.setAttribute(ITEM_DISABLED, "true");
        }
        div.appendChild((nsIDOMNode)radio);
        div.appendChild((nsIDOMNode)label);
        if (element != null) {
            this.dir = element.getAttribute("dir");
        }
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)div);
        div.setAttribute("style", SPAN_STYLE_VALUE);
        radio.setAttribute("type", ATTR_TYPE_VALUE);
        radio.setAttribute("title", this.getTitle(sourceNode));
        radio.setAttribute("name", ATTR_NAME_VALUE + this.getNameSuffix(sourceNode));
        if (this.attrPresents(this.dir)) {
            radio.setAttribute("dir", this.dir);
        }
        this.processOutputAttribute(pageContext, visualDocument, element, label, creationData);
        return creationData;
    }

    private String getTitle(Node sourceNode) {
        String tagString = " <" + sourceNode.getNodeName();
        NamedNodeMap attrs = sourceNode.getAttributes();
        if (attrs != null) {
            tagString = String.valueOf(tagString) + (attrs.getLength() > 0 ? " " : "");
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                tagString = String.valueOf(tagString) + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"" + (i < attrs.getLength() - 1 ? " " : "");
                ++i;
            }
        }
        tagString = String.valueOf(tagString) + (sourceNode.hasChildNodes() ? "" : "/") + "> ";
        return tagString;
    }

    private String getNameSuffix(Node sourceNode) {
        String name_suffix = "";
        Node parent = sourceNode.getParentNode();
        if (parent != null && parent.getNodeType() == 1) {
            ElementImpl element = (ElementImpl)parent;
            name_suffix = String.valueOf(element.getStartOffset());
        }
        return name_suffix;
    }

    private boolean attrPresents(String attr) {
        return attr != null && attr.length() != 0;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

