/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.model.installer.internal;

import java.io.File;
import java.util.HashMap;
import org.jboss.tools.rsp.api.dao.CommandLineDetails;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IPath;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.Path;
import org.jboss.tools.rsp.eclipse.core.runtime.Status;
import org.jboss.tools.rsp.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.rsp.eclipse.debug.core.ArgumentUtils;
import org.jboss.tools.rsp.eclipse.debug.core.ILaunch;
import org.jboss.tools.rsp.eclipse.debug.core.Launch;
import org.jboss.tools.rsp.eclipse.debug.core.model.IProcess;
import org.jboss.tools.rsp.eclipse.jdt.launching.IVMInstall;
import org.jboss.tools.rsp.eclipse.jdt.launching.IVMInstallRegistry;
import org.jboss.tools.rsp.eclipse.jdt.launching.VMInstallRegistry;
import org.jboss.tools.rsp.foundation.core.launchers.CommandConfig;
import org.jboss.tools.rsp.foundation.core.launchers.GenericProcessRunner;
import org.jboss.tools.rsp.foundation.core.tasks.TaskModel;
import org.jboss.tools.rsp.launching.utils.NativeEnvironmentUtils;
import org.jboss.tools.rsp.launching.utils.OSUtils;
import org.jboss.tools.rsp.runtime.core.model.DownloadRuntime;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesModel;
import org.jboss.tools.rsp.runtime.core.model.IRuntimeInstaller;
import org.jboss.tools.rsp.runtime.core.model.installer.internal.DownloadRuntimeOperationUtilFactory;
import org.jboss.tools.rsp.runtime.core.util.internal.DownloadRuntimeOperationUtility;

public class JavaJarRuntimeInstaller
implements IRuntimeInstaller {
    public static final String ID = "installer-jar";
    private IDownloadRuntimesModel downloadRuntimesModel;
    static final String JAVA_HOME_PROPERTY_KEY = "java.home";

    public JavaJarRuntimeInstaller() {
    }

    public JavaJarRuntimeInstaller(IDownloadRuntimesModel downloadRuntimesModel) {
        this.downloadRuntimesModel = downloadRuntimesModel;
    }

    @Override
    public IStatus installRuntime(DownloadRuntime downloadRuntime, String unzipDirectory, String downloadDirectory, boolean deleteOnExit, TaskModel taskModel, IProgressMonitor monitor) {
        String user = (String)taskModel.getObject("dl.runtime.username");
        String pass = (String)taskModel.getObject("dl.runtime.password");
        monitor.beginTask("Install Runtime '" + downloadRuntime.getName() + "' ...", 100);
        monitor.worked(1);
        try {
            DownloadRuntimeOperationUtility opUtil = DownloadRuntimeOperationUtilFactory.createDownloadRuntimeOperationUtility(taskModel, this.downloadRuntimesModel);
            File f = opUtil.download(unzipDirectory, downloadDirectory, this.getDownloadUrl(downloadRuntime, taskModel), deleteOnExit, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            ILaunch launch = this.createExternalToolsLaunchConfiguration(f, unzipDirectory);
            IProcess[] processes = launch.getProcesses();
            boolean finished = false;
            while (!monitor.isCanceled() && !finished) {
                boolean checkFinished = true;
                int i = 0;
                while (i < processes.length) {
                    checkFinished &= processes[i].isTerminated();
                    ++i;
                }
                finished = checkFinished;
                this.safeSleep(500L);
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void safeSleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String getDownloadUrl(DownloadRuntime downloadRuntime, TaskModel taskModel) {
        if (downloadRuntime != null) {
            String dlUrl = downloadRuntime.getUrl();
            if (dlUrl == null) {
                return (String)taskModel.getObject("dl.runtime.url");
            }
            return dlUrl;
        }
        return null;
    }

    private ILaunch createExternalToolsLaunchConfiguration(File downloadedFile, String unzipDirectory) {
        IVMInstall install = this.createVMRegistry().getDefaultVMInstall();
        IPath javaBin = this.getJavaBin(install);
        Path workingDir = new Path(downloadedFile.getAbsolutePath());
        JavaJarInstallationLauncher launcher = new JavaJarInstallationLauncher(javaBin, (IPath)workingDir, (IPath)new Path(downloadedFile.getAbsolutePath()), (IPath)new Path(unzipDirectory));
        ILaunch l2 = launcher.createLaunch("run");
        return l2;
    }

    private IVMInstallRegistry createVMRegistry() {
        VMInstallRegistry reg = new VMInstallRegistry();
        reg.addActiveVM();
        return reg;
    }

    private IPath getJavaBin(IVMInstall install) {
        File javaHome = null;
        if (install != null) {
            javaHome = install.getInstallLocation();
        } else {
            String jHome = System.getProperty(JAVA_HOME_PROPERTY_KEY);
            javaHome = new File(jHome);
        }
        Path path = new Path(javaHome.getAbsolutePath());
        path = OSUtils.isWindows() ? path.append("bin").append("java.exe") : path.append("bin").append("java");
        return path;
    }

    private static class JavaJarInstallationLauncher {
        private ILaunch launch;
        private CommandLineDetails launchedDetails = null;
        private GenericProcessRunner runner;
        private IPath javaBin;
        private IPath workingDirectory;
        private IPath unzipDir;
        private IPath downloadedFile;

        public JavaJarInstallationLauncher(IPath javaBin, IPath workingDirectory, IPath downloadedFile, IPath unzipDir) {
            this.workingDirectory = workingDirectory;
            this.javaBin = javaBin;
            this.downloadedFile = downloadedFile;
            this.unzipDir = unzipDir;
        }

        public ILaunch launch(String mode) throws CoreException {
            this.getLaunchCommand(mode);
            this.configureRunner();
            this.runner.run(this.launch, (IProgressMonitor)new NullProgressMonitor());
            return this.launch;
        }

        public CommandLineDetails getLaunchCommand(String mode) throws CoreException {
            IStatus preReqs = this.checkPrereqs(mode);
            if (!preReqs.isOK()) {
                throw new CoreException(preReqs);
            }
            this.launch = this.createLaunch(mode);
            this.configureRunner();
            this.launchedDetails = this.runner.getCommandLineDetails(this.launch, (IProgressMonitor)new NullProgressMonitor());
            return this.launchedDetails;
        }

        public CommandLineDetails getLaunchedDetails() {
            return this.launchedDetails;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        private ILaunch createLaunch(String mode) {
            return new Launch((Object)this, mode, null);
        }

        protected IStatus checkPrereqs(String mode) {
            return Status.OK_STATUS;
        }

        public String getProgramArguments() {
            return "-DINSTALL_PATH=\"" + this.unzipDir + "\"  -jar " + this.downloadedFile.toOSString();
        }

        public GenericProcessRunner configureRunner() {
            if (this.runner == null) {
                this.runner = new GenericProcessRunner(this.getCommandConfig());
            }
            return this.runner;
        }

        protected CommandConfig getCommandConfig() {
            String cmd = this.javaBin.toOSString();
            String args = this.getProgramArguments();
            String[] parsed = ArgumentUtils.parseArguments((String)args);
            String wd = this.getWorkingDirectory();
            String[] env = NativeEnvironmentUtils.getDefault().getEnvironment(new HashMap(), true);
            CommandConfig details = new CommandConfig(cmd, wd, parsed, env);
            return details;
        }

        public String getWorkingDirectory() {
            return this.workingDirectory.toOSString();
        }
    }
}

