/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.model.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.rsp.runtime.core.model.DownloadRuntime;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesModel;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesProvider;
import org.jboss.tools.rsp.runtime.core.model.IRuntimeInstaller;
import org.jboss.tools.rsp.runtime.core.model.installer.RuntimesInstallerModel;

public class DownloadRuntimesModel
implements IDownloadRuntimesModel {
    private Map<String, DownloadRuntime> cachedDownloadRuntimes = null;
    private Map<String, Map<String, DownloadRuntime>> cachedDownloadRuntimesByProvider = null;
    private List<IDownloadRuntimesProvider> downloadRuntimeProviders = new ArrayList<IDownloadRuntimesProvider>();
    private RuntimesInstallerModel installers = new RuntimesInstallerModel(this);
    private File dataLocationRoot = null;

    @Override
    public void addDownloadRuntimeProvider(IDownloadRuntimesProvider provider) {
        this.downloadRuntimeProviders.add(provider);
        this.clearCache();
    }

    @Override
    public void removeDownloadRuntimeProvider(IDownloadRuntimesProvider provider) {
        this.downloadRuntimeProviders.remove(provider);
        this.clearCache();
    }

    @Override
    public DownloadRuntime findDownloadRuntime(String id, IProgressMonitor monitor) {
        Map<String, DownloadRuntime> runtimes = this.getOrLoadDownloadRuntimes(monitor);
        return this.findDownloadRuntime(id, runtimes);
    }

    @Override
    public Map<String, DownloadRuntime> getOrLoadDownloadRuntimes(IProgressMonitor monitor) {
        this.ensureCacheLoaded(monitor);
        return new HashMap<String, DownloadRuntime>(this.getDownloadRuntimesCache());
    }

    private void ensureCacheLoaded(IProgressMonitor monitor) {
        Map<String, DownloadRuntime> cached = this.getDownloadRuntimesCache();
        if (cached == null) {
            this.cacheDownloadRuntimes(monitor);
        }
    }

    private synchronized void setDownloadRuntimesCache(Map<String, DownloadRuntime> cache) {
        this.cachedDownloadRuntimes = cache;
    }

    private synchronized void setByProviderRuntimesCache(Map<String, Map<String, DownloadRuntime>> cache) {
        this.cachedDownloadRuntimesByProvider = cache;
    }

    private synchronized Map<String, DownloadRuntime> getDownloadRuntimesCache() {
        return this.cachedDownloadRuntimes == null ? null : new HashMap<String, DownloadRuntime>(this.cachedDownloadRuntimes);
    }

    private synchronized void clearCache() {
        this.cachedDownloadRuntimes = null;
        this.cachedDownloadRuntimesByProvider = null;
    }

    private DownloadRuntime findDownloadRuntime(String id, Map<String, DownloadRuntime> runtimes) {
        if (id == null) {
            return null;
        }
        DownloadRuntime rt = runtimes.get(id);
        if (rt != null) {
            return rt;
        }
        Collection<DownloadRuntime> rts = runtimes.values();
        for (DownloadRuntime runtime : rts) {
            if (!this.matchesInAlternativeId(id, runtime)) continue;
            return runtime;
        }
        return null;
    }

    private boolean matchesInAlternativeId(String id, DownloadRuntime runtime) {
        String alternativeId = runtime.getProperty("PROPERTY_ALTERNATE_ID");
        return alternativeId instanceof String && id.equals(alternativeId);
    }

    private void cacheDownloadRuntimes(IProgressMonitor monitor) {
        HashMap<String, DownloadRuntime> map = new HashMap<String, DownloadRuntime>();
        HashMap<String, Map<String, DownloadRuntime>> byProvider = new HashMap<String, Map<String, DownloadRuntime>>();
        IDownloadRuntimesProvider[] providers = this.getDownloadRuntimeProviders();
        monitor.beginTask("Loading Download Runtime Providers", providers.length * 100);
        int i = 0;
        while (i < providers.length && !monitor.isCanceled()) {
            SubProgressMonitor subMon = new SubProgressMonitor(monitor, 100);
            HashMap<String, DownloadRuntime> byProviderInner = new HashMap<String, DownloadRuntime>();
            byProvider.put(providers[i].getId(), byProviderInner);
            DownloadRuntime[] runtimes = providers[i].getDownloadableRuntimes((IProgressMonitor)subMon);
            if (runtimes != null) {
                int j = 0;
                while (j < runtimes.length) {
                    if (runtimes[j] != null) {
                        map.put(runtimes[j].getId(), runtimes[j]);
                        byProviderInner.put(runtimes[j].getId(), runtimes[j]);
                    }
                    ++j;
                }
            }
            subMon.done();
            ++i;
        }
        this.setDownloadRuntimesCache(map);
        this.setByProviderRuntimesCache(byProvider);
    }

    @Override
    public IDownloadRuntimesProvider[] getDownloadRuntimeProviders() {
        return this.downloadRuntimeProviders.toArray(new IDownloadRuntimesProvider[this.downloadRuntimeProviders.size()]);
    }

    @Override
    public IDownloadRuntimesProvider findProviderForRuntime(String id, IProgressMonitor monitor) {
        this.ensureCacheLoaded(monitor);
        return this.findProviderForRuntime(id);
    }

    @Override
    public IDownloadRuntimesProvider findProviderForRuntime(String id) {
        if (id == null || id.isEmpty() || this.cachedDownloadRuntimesByProvider == null) {
            return null;
        }
        Set<String> providerKeys = this.cachedDownloadRuntimesByProvider.keySet();
        for (String k : providerKeys) {
            Map<String, DownloadRuntime> val = this.cachedDownloadRuntimesByProvider.get(k);
            if (val == null || !val.containsKey(id)) continue;
            return this.findDownloadRuntimeProvider(k);
        }
        return null;
    }

    private IDownloadRuntimesProvider findDownloadRuntimeProvider(String id) {
        IDownloadRuntimesProvider[] all = this.getDownloadRuntimeProviders();
        int i = 0;
        while (i < all.length) {
            if (id.equals(all[i].getId())) {
                return all[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setDataLocation(File loc) {
        this.dataLocationRoot = loc;
    }

    @Override
    public File getDataLocation() {
        return this.dataLocationRoot;
    }

    @Override
    public IRuntimeInstaller getRuntimeInstaller(String installationMethod) {
        return this.installers.getRuntimeInstaller(installationMethod);
    }
}

