/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.ide.eclipse.as.core.server.bean.IServerBeanTypeProvider;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanExtensionManager {
    public static ServerBeanExtensionManager instance = null;
    private TypeProviderWrapper[] wrappers;

    public static ServerBeanExtensionManager getDefault() {
        if (instance == null) {
            instance = new ServerBeanExtensionManager();
        }
        return instance;
    }

    public ServerBeanType[] getAllTypes() {
        if (this.wrappers == null) {
            this.load();
        }
        return this.getAll(this.wrappers);
    }

    private void load() {
        ArrayList<TypeProviderWrapper> wrappers = new ArrayList<TypeProviderWrapper>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.wtp.core", "serverBeanTypeProvider");
        int i = 0;
        while (i < cf.length) {
            wrappers.add(new TypeProviderWrapper(cf[i]));
            ++i;
        }
        Collections.sort(wrappers, new Comparator<TypeProviderWrapper>(){

            @Override
            public int compare(TypeProviderWrapper o1, TypeProviderWrapper o2) {
                return o1.getWeight() - o2.getWeight();
            }
        });
        this.wrappers = wrappers.toArray(new TypeProviderWrapper[wrappers.size()]);
    }

    private ServerBeanType[] getAll(TypeProviderWrapper[] providers) {
        ArrayList<ServerBeanType> list = new ArrayList<ServerBeanType>();
        int i = 0;
        while (i < providers.length) {
            IServerBeanTypeProvider p = providers[i].getProvider();
            if (p != null) {
                list.addAll(Arrays.asList(p.getServerBeanTypes()));
            }
            ++i;
        }
        return list.toArray(new ServerBeanType[list.size()]);
    }

    private class TypeProviderWrapper {
        private IConfigurationElement element;
        private IServerBeanTypeProvider provider;
        private int weight;
        private Throwable errorLoadingProvider;

        public TypeProviderWrapper(IConfigurationElement el) {
            this.element = el;
            String weightS = el.getAttribute("weight");
            int weight = 0;
            if (weightS != null) {
                try {
                    weight = Integer.parseInt(weightS);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }

        private IServerBeanTypeProvider getProvider() {
            if (this.provider == null && this.errorLoadingProvider == null) {
                try {
                    this.provider = (IServerBeanTypeProvider)this.element.createExecutableExtension("class");
                }
                catch (CoreException ce) {
                    this.errorLoadingProvider = ce;
                }
            }
            return this.provider;
        }
    }
}

