/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.Messages;

public class FileUtil {
    private static final int BUFFER = 65536;

    public static void safeDelete(File file) {
        FileUtil.safeDelete(file, null);
    }

    public static void safeDelete(File file, IFileUtilListener listener) {
        block12: {
            block11: {
                if (file.isDirectory()) {
                    File[] children = file.listFiles();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            FileUtil.safeDelete(children[i], listener);
                            ++i;
                        }
                    }
                    if (file.exists()) {
                        try {
                            boolean tmp = file.delete();
                            if (listener != null) {
                                listener.folderDeleted(file, tmp, null);
                            }
                        }
                        catch (SecurityException sex) {
                            if (listener == null) break block11;
                            listener.folderDeleted(file, false, sex);
                        }
                    }
                }
            }
            if (file.exists()) {
                try {
                    boolean tmp = file.delete();
                    if (listener != null) {
                        listener.fileDeleted(file, tmp, null);
                    }
                }
                catch (SecurityException sex) {
                    if (listener == null) break block12;
                    listener.fileDeleted(file, false, sex);
                }
            }
        }
    }

    public static void completeDelete(File file) {
        FileUtil.completeDelete(file, null);
    }

    public static void completeDelete(File file, IFileUtilListener listener) {
        FileUtil.completeDelete(file, null, listener);
    }

    public static void completeDelete(File file, File archiveRoot, IFileUtilListener listener) {
        FileUtil.safeDelete(file, listener);
        while (!file.getParentFile().equals(archiveRoot) && file.getParentFile().listFiles().length == 0) {
            file = file.getParentFile();
            try {
                boolean tmp = file.delete();
                if (listener == null) continue;
                listener.folderDeleted(file, tmp, null);
            }
            catch (SecurityException sex) {
                if (listener == null) continue;
                listener.folderDeleted(file, false, sex);
            }
        }
    }

    public static boolean fileSafeCopy(File src, File dest) {
        return FileUtil.fileSafeCopy(src, dest, null);
    }

    public static boolean fileSafeCopy(File src, File dest, IFileUtilListener listener) {
        File parent = dest.getParentFile();
        parent.mkdirs();
        if (dest.exists()) {
            FileUtil.safeDelete(dest);
        }
        if (src.isDirectory()) {
            File[] subFiles = src.listFiles();
            boolean copied = true;
            dest.mkdirs();
            int i = 0;
            while (i < subFiles.length) {
                File newDest = new File(dest, subFiles[i].getName());
                copied = copied && FileUtil.fileSafeCopy(subFiles[i], newDest, listener);
                ++i;
            }
            return copied;
        }
        try {
            FileInputStream fis = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            if (listener != null) {
                listener.fileCopied(src, dest, true, null);
            }
            return true;
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fileCopied(src, dest, false, e);
            }
            return false;
        }
    }

    public static void touch(FileFilter filter, File root, boolean recurse) {
        File[] children;
        if (filter.accept(root)) {
            root.setLastModified(new Date().getTime());
        }
        if (recurse && root.isDirectory() && (children = root.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                FileUtil.touch(filter, children[i], recurse);
                ++i;
            }
        }
    }

    public static void copyDir(File from, File to) {
        FileUtil.copyDir(from, to, false);
    }

    public static void copyDir(File from, File to, boolean mkdirs) {
        FileUtil.copyDir(from, to, mkdirs, true);
    }

    public static void copyDir(File from, File to, boolean mkdirs, boolean includeSubdirs) {
        FileUtil.copyDir(from, to, includeSubdirs, mkdirs, false);
    }

    public static void copyDir(File from, boolean includeSubdirs, File to) {
        FileUtil.copyDir(from, to, includeSubdirs, false, false);
    }

    public static void copyDir(File from, File to, boolean includeSubdirs, boolean mkdirs, boolean overwriteOnlyOlderFiles) {
        FileUtil.copyDir(from, to, includeSubdirs, mkdirs, overwriteOnlyOlderFiles, null);
    }

    public static void copyDir(File from, File to, boolean includeSubdirs, boolean mkdirs, boolean overwriteOnlyOlderFiles, FileFilter filter) {
        if (filter != null && !filter.accept(from)) {
            return;
        }
        if (mkdirs) {
            to.mkdirs();
        }
        if (from == null || !from.isDirectory() || !to.isDirectory()) {
            return;
        }
        File[] fs = from.listFiles();
        if (fs == null) {
            return;
        }
        int i = 0;
        while (i < fs.length) {
            String n = fs[i].getName();
            File c = new File(to, n);
            if (!(fs[i].isDirectory() && !includeSubdirs || filter != null && !filter.accept(new File(from, n)))) {
                if (fs[i].isDirectory()) {
                    c.mkdirs();
                    FileUtil.copyDir(fs[i], c, includeSubdirs, mkdirs, overwriteOnlyOlderFiles, filter);
                } else if (overwriteOnlyOlderFiles && fs[i].isFile() && c.isFile()) {
                    FileUtil.copyFile(fs[i], c, false, c.lastModified() < fs[i].lastModified());
                } else {
                    FileUtil.copyFile(fs[i], c);
                }
            }
            ++i;
        }
    }

    public static boolean copyFile(File source, File dest, boolean mkdirs) {
        return FileUtil.copyFile(source, dest, mkdirs, true);
    }

    public static boolean copyFile(File source, File dest) {
        return FileUtil.copyFile(source, dest, false, true);
    }

    public static boolean copyFile(File source, File dest, boolean mkdirs, boolean overwrite) {
        if (mkdirs) {
            dest.getParentFile().mkdirs();
        }
        if (!source.isFile()) {
            return false;
        }
        if (dest.isFile() && !FileUtil.isSameFile(dest)) {
            dest.delete();
        }
        if (dest.isFile() && !overwrite) {
            return false;
        }
        if (!dest.exists()) {
            try {
                dest.createNewFile();
            }
            catch (IOException e1) {
                ASWTPToolsPlugin.log(e1);
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(source), 16384);
            os = new BufferedOutputStream(new FileOutputStream(dest), 16384);
            FileUtil.copyStream(is, os);
            return true;
        }
        catch (IOException e) {
            ASWTPToolsPlugin.log(e);
            return false;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                ASWTPToolsPlugin.log(e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                ASWTPToolsPlugin.log(e);
            }
        }
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[16384];
        while (true) {
            int r;
            if ((r = is.read(buffer)) > 0) {
                os.write(buffer, 0, r);
                continue;
            }
            if (r == -1) break;
        }
        os.flush();
    }

    public static boolean isSameFile(File f) {
        if (!f.exists()) {
            return false;
        }
        String fn = f.getName();
        try {
            String cn = f.getCanonicalFile().getName();
            return fn.equals(cn);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void writeTo(InputStream in, String fileName) throws IOException {
        FileUtil.writeTo(in, new File(fileName));
    }

    public static void writeTo(InputStream in, File file) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            FileUtil.writeTo(in, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void writeTo(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[65536];
        int avail = in.read(buffer);
        while (avail > 0) {
            out.write(buffer, 0, avail);
            avail = in.read(buffer);
        }
    }

    public static void setContents(File file, String contents) throws IOException, CoreException {
        byte[] buffer = new byte[65536];
        ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes());
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            int avail = in.read(buffer);
            while (avail > 0) {
                out.write(buffer, 0, avail);
                avail = in.read(buffer);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getContents(IFile file) throws IOException, CoreException {
        return FileUtil.getContents(file.getLocation().toFile());
    }

    public static String getContents(File aFile) throws IOException {
        return new String(FileUtil.getBytesFromFile(aFile));
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void setContents(IFile file, int val) throws IOException, CoreException {
        FileUtil.setContents(file, "" + val);
    }

    public static void setContents(IFile file, String val) throws IOException, CoreException {
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(val.getBytes()), false, null);
        } else {
            file.setContents((InputStream)new ByteArrayInputStream(val.getBytes()), false, false, (IProgressMonitor)new NullProgressMonitor());
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static int countFiles(File root) {
        int count = 0;
        if (!root.isDirectory()) {
            return 1;
        }
        File[] children = root.listFiles();
        int i = 0;
        while (i < children.length) {
            count += FileUtil.countFiles(children[i]);
            ++i;
        }
        return count;
    }

    public static int countAllResources(File root) {
        int count = 0;
        if (!root.isDirectory()) {
            return 1;
        }
        File[] children = root.listFiles();
        int i = 0;
        while (i < children.length) {
            count += FileUtil.countAllResources(children[i]);
            ++i;
        }
        return 1 + count;
    }

    public static class FileUtilListener
    implements IFileUtilListener {
        protected ArrayList<IStatus> errors = new ArrayList();

        @Override
        public void fileCopied(File source, File dest, boolean result, Exception e) {
            if (!result) {
                this.errors.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.CopyFileError, (Object)source.toString(), (Object)dest.toString()), (Throwable)e));
            }
        }

        @Override
        public void fileDeleted(File file, boolean result, Exception e) {
            if (!result) {
                this.errors.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.DeleteFolderError, (Object)file.toString(), (Object)e)));
            }
        }

        @Override
        public void folderDeleted(File file, boolean result, Exception e) {
            if (!result) {
                this.errors.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.DeleteFolderError, (Object)file.toString()), (Throwable)e));
            }
        }

        public IStatus[] getStatuses() {
            return this.errors.toArray(new IStatus[this.errors.size()]);
        }
    }

    public static interface IFileUtilListener {
        public void fileDeleted(File var1, boolean var2, Exception var3);

        public void folderDeleted(File var1, boolean var2, Exception var3);

        public void fileCopied(File var1, File var2, boolean var3, Exception var4);
    }
}

