/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.publish;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public final class PublishModuleFullRunner {
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private static final IStatus CANCEL_STATUS = new Status(8, "org.jboss.ide.eclipse.as.wtp.core", "Publish Canceled");
    private static final IStatus[] CANCEL_STATUS_ARR = new IStatus[]{CANCEL_STATUS};
    private IFilesystemController fsController;
    private IPath rootDirectory;

    public PublishModuleFullRunner(IFilesystemController controller, IPath rootDirectory) {
        this.fsController = controller;
        this.rootDirectory = rootDirectory;
    }

    public IStatus[] fullPublish(IModuleResource[] resources, IProgressMonitor monitor) throws CoreException {
        int count = ModuleResourceUtil.countMembers(resources, true);
        monitor = ProgressMonitorUtil.getMonitorFor(monitor);
        monitor.beginTask("Publishing " + count + " resources", 100 * count + 200);
        if (monitor.isCanceled()) {
            return CANCEL_STATUS_ARR;
        }
        this.fsController.deleteResource(this.rootDirectory, ProgressMonitorUtil.getSubMon(monitor, 100));
        if (monitor.isCanceled()) {
            return CANCEL_STATUS_ARR;
        }
        IStatus s = this.fsController.makeDirectoryIfRequired(this.rootDirectory, ProgressMonitorUtil.getSubMon(monitor, 100));
        if (monitor.isCanceled()) {
            return CANCEL_STATUS_ARR;
        }
        ArrayList<IStatus> all = new ArrayList<IStatus>();
        IStatus[] results = this.traverseResources(resources, this.rootDirectory, monitor);
        if (s != null) {
            all.add(s);
        }
        all.addAll(Arrays.asList(results));
        monitor.done();
        return results;
    }

    private IStatus[] traverseResources(IModuleResource[] resources, IPath relative, IProgressMonitor monitor) throws CoreException {
        if (resources == null) {
            return EMPTY_STATUS;
        }
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size = resources.length;
        int i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                return CANCEL_STATUS_ARR;
            }
            IStatus[] stat = this.handleSingleResource(resources[i], relative, monitor);
            this.addArrayToList(status, stat);
            ++i;
        }
        return status.toArray(new IStatus[status.size()]);
    }

    private IStatus[] handleSingleResource(IModuleResource resource, IPath path, IProgressMonitor monitor) throws CoreException {
        String name = resource.getName();
        IPath rel = resource.getModuleRelativePath();
        IPath absoluteRemote = path.append(rel).append(name);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (resource instanceof IModuleFolder) {
            IModuleResource[] children = ((IModuleFolder)resource).members();
            if (children.length == 0) {
                this.fsController.makeDirectoryIfRequired(absoluteRemote, ProgressMonitorUtil.getSubMon(monitor, 100));
            } else {
                IStatus[] stat = this.traverseResources(children, path, monitor);
                this.addArrayToList(status, stat);
            }
        } else {
            IStatus stats = this.fsController.makeDirectoryIfRequired(absoluteRemote.removeLastSegments(1), ProgressMonitorUtil.getSubMon(monitor, 10));
            status.add(stats);
            File file = ModuleResourceUtil.getFile((IModuleFile)resource);
            status.add(this.fsController.copyFile(file, absoluteRemote, ProgressMonitorUtil.getSubMon(monitor, 90)));
        }
        return status.toArray(new IStatus[status.size()]);
    }

    private void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (a != null && a.length != 0) {
            list.addAll(Arrays.asList(a));
        }
    }
}

