/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.wtp.core.modules.IJBTModule;
import org.jboss.ide.eclipse.as.wtp.core.util.IServerFilter;

public class ServerModelUtilities {
    public static IPath getRootModuleRelativePath(IServerAttributes server, IModule[] moduleTree) {
        Path working = null;
        int i = 1;
        while (i < moduleTree.length) {
            String modName = moduleTree[i].getName();
            String name = new RemotePath(modName).lastSegment();
            String suffixedName = String.valueOf(name) + ServerModelUtilities.getDefaultSuffixForModule(moduleTree[i]);
            String uri = ModuleResourceUtil.getParentRelativeURI(moduleTree, i, suffixedName);
            working = working == null ? new Path(uri) : working.append(uri);
            ++i;
        }
        return working;
    }

    public static IModule[] getParentModules(IServer server, IModule module) {
        IRuntimeType rtt = RuntimeUtils.getRuntimeType(server);
        IModule[] supported = rtt == null ? new IModule[]{} : ServerUtil.getModules((IModuleType[])rtt.getModuleTypes());
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < supported.length) {
            IModule[] childs = ServerModelUtilities.getChildModules(supported[i]);
            if (childs != null) {
                int j = 0;
                while (j < childs.length) {
                    if (childs[j].equals(module)) {
                        list.add(supported[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IModule[list.size()]);
    }

    public static ArrayList<IModule[]> getShallowChildren(IServer server, IModule[] root) {
        ArrayList<IModule[]> list = new ArrayList<IModule[]>();
        IModule[] children = server.getChildModules(root, (IProgressMonitor)new NullProgressMonitor());
        int length = children == null ? 0 : children.length;
        int i = 0;
        while (i < length) {
            ArrayList<IModule> inner = new ArrayList<IModule>();
            inner.addAll(Arrays.asList(root));
            inner.add(children[i]);
            IModule[] innerMods = inner.toArray(new IModule[inner.size()]);
            list.add(innerMods);
            ++i;
        }
        return list;
    }

    public static ArrayList<IModule[]> getDeepChildren(IServer server, IModule[] mod) {
        ArrayList<IModule[]> deep = ServerModelUtilities.getShallowChildren(server, mod);
        int i = 0;
        while (i < deep.size()) {
            IModule[] toBeSearched = deep.get(i);
            deep.addAll(ServerModelUtilities.getShallowChildren(server, toBeSearched));
            ++i;
        }
        return deep;
    }

    public static IModule[] getChildModules(IModule[] module) {
        int last = module.length - 1;
        if (module[last] != null && module[last].getModuleType() != null) {
            return ServerModelUtilities.getChildModules(module[last]);
        }
        return new IModule[0];
    }

    public static IModule[] getChildModules(IModule module) {
        try {
            ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            IModule[] children = md == null ? null : md.getChildModules();
            return children == null ? new IModule[]{} : children;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isBinaryModule(IModule[] moduleTree) {
        return moduleTree == null ? false : ServerModelUtilities.isBinaryModule(moduleTree[moduleTree.length - 1]);
    }

    public static boolean isBinaryModule(IModule module) {
        IJ2EEModule jee = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
        if (jee != null) {
            return jee.isBinary();
        }
        IJBTModule jbtMod = (IJBTModule)module.loadAdapter(IJBTModule.class, null);
        if (jbtMod != null) {
            return jbtMod.isBinary();
        }
        return false;
    }

    public static boolean isAnyDeleted(IModule[] module) {
        boolean deleted = false;
        int i = 0;
        while (i < module.length) {
            if (!module[i].exists()) {
                deleted = true;
                break;
            }
            ++i;
        }
        return deleted;
    }

    public static IServer[] findServersFor(IProject p, IServerFilter filter) {
        ArrayList<IServer> match = new ArrayList<IServer>();
        IServer[] allServers = ServerCore.getServers();
        IModule[] mods = ServerUtil.getModules((IProject)p);
        int i = 0;
        while (i < allServers.length) {
            if (filter == null || filter.accepts(allServers[i])) {
                IModule[] serversMods = allServers[i].getModules();
                int j = 0;
                while (j < mods.length) {
                    if (!ServerModelUtilities.isBinaryModule(mods[j]) && ServerModelUtilities.moduleListContainsMod(serversMods, mods[j]) && !match.contains(allServers[i])) {
                        match.add(allServers[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return match.toArray(new IServer[match.size()]);
    }

    public static boolean moduleListContainsMod(IModule[] list, IModule module) {
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(module)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getDefaultSuffixForModule(IModule module) {
        String type = null;
        if (module != null) {
            type = module.getModuleType().getId();
        }
        return ServerModelUtilities.getDefaultSuffixForModuleType(type);
    }

    public static String getDefaultSuffixForModuleType(String type) {
        String suffix = null;
        if ("jst.ear".equals(type)) {
            suffix = ".ear";
        } else if ("jst.web".equals(type) || "wst.web".equals(type)) {
            suffix = ".war";
        } else if ("jst.webfragment".equals(type)) {
            suffix = ".jar";
        } else if ("jst.utility".equals(type)) {
            suffix = ".jar";
        } else if ("jst.connector".equals(type)) {
            suffix = ".rar";
        } else if ("jst.jboss.esb".equals(type)) {
            suffix = ".esb";
        } else if ("jboss.package".equals(type)) {
            suffix = "";
        } else if ("jboss.singlefile".equals(type)) {
            suffix = "";
        } else if ("jst.jboss.sar".equals(type)) {
            suffix = ".sar";
        }
        if (suffix == null) {
            suffix = ".jar";
        }
        return suffix;
    }
}

