/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.scanner;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.tools.archives.scanner.AbstractScanner;
import org.jboss.tools.archives.scanner.DirectoryScannerIterator;
import org.jboss.tools.archives.scanner.IDirectoryScannerIterator;
import org.jboss.tools.archives.scanner.ITreeNode;
import org.jboss.tools.archives.scanner.IterableDirectoryScanner;
import org.jboss.tools.archives.scanner.internal.MatchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualDirectoryScanner<T extends ITreeNode>
extends AbstractScanner<T>
implements IterableDirectoryScanner<T> {
    protected T basedir;
    protected Vector<String> filesIncluded;
    protected Vector<String> filesNotIncluded;
    protected Vector<String> filesExcluded;
    protected Vector<String> dirsIncluded;
    protected Vector<String> dirsNotIncluded;
    protected Vector<String> dirsExcluded;
    protected Vector<String> filesDeselected;
    protected Vector<String> dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean everythingIncluded = true;
    private final String[] tokenizedEmpty = MatchPattern.tokenizePathToString("", File.separator);
    protected IDirectoryScannerIterator<T> iterator = null;
    private static Vector<String> defaultExcludes = new Vector();

    static {
        VirtualDirectoryScanner.resetDefaultExcludes();
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static String implodeStrings(String[] strings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buffer.append(strings[i]).append(',');
            ++i;
        }
        return buffer.toString();
    }

    public static boolean addDefaultExclude(String s) {
        if (defaultExcludes.indexOf(s) == -1) {
            defaultExcludes.add(s);
            return true;
        }
        return false;
    }

    public void setExcludes(String s) {
        String[] stringArray;
        if (s == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        }
        super.setExcludes(stringArray);
    }

    public void setIncludes(String s) {
        String[] stringArray;
        if (s == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        }
        super.setIncludes(stringArray);
    }

    public static boolean removeDefaultExclude(String s) {
        return defaultExcludes.remove(s);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        int i = 0;
        while (i < DEFAULTEXCLUDES.length) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
            ++i;
        }
    }

    public void setBasedir(T basedir) {
        this.basedir = basedir;
    }

    @Override
    public T getBasedir() {
        return this.basedir;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    @Override
    public void scan() throws IllegalStateException {
        this.scanPrepare();
        this.scandirWrap(this.basedir, "", true);
    }

    protected void scanPrepare() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (this.basedirMustExist() && !this.exists(this.basedir)) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.isDirectory((ITreeNode)this.basedir)) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        this.setupDefaultFilters();
        this.setupMatchPatterns();
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("", this.tokenizedEmpty)) {
            if (!this.isExcluded("", this.tokenizedEmpty)) {
                if (this.isSelected("", (ITreeNode)this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] excl = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(excl);
        Object[] notIncl = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(notIncl);
        Object[] objectArray = excl;
        int n = excl.length;
        int n2 = 0;
        while (n2 < n) {
            Object anExcl = objectArray[n2];
            if (!this.couldHoldIncluded((String)anExcl)) {
                this.scandir(this.getChild(this.basedir, (String)anExcl), String.valueOf(anExcl) + File.separator, false);
            }
            ++n2;
        }
        objectArray = notIncl;
        n = notIncl.length;
        n2 = 0;
        while (n2 < n) {
            Object aNotIncl = objectArray[n2];
            if (!this.couldHoldIncluded((String)aNotIncl)) {
                this.scandir(this.getChild(this.basedir, (String)aNotIncl), String.valueOf(aNotIncl) + File.separator, false);
            }
            ++n2;
        }
        this.haveSlowResults = true;
    }

    protected void scandir(ITreeNode dir, String vpath, boolean fast) {
        ITreeNode[] newfiles = this.listChildren(dir);
        if (newfiles == null) {
            newfiles = new ITreeNode[]{};
        }
        this.trimInapplicableEntries(newfiles, dir, vpath);
        ITreeNode[] iTreeNodeArray = newfiles;
        int n = newfiles.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode newfile = iTreeNodeArray[n2];
            String name = String.valueOf(vpath) + this.getName(newfile);
            String[] tokenizedName = MatchPattern.tokenizePathToString(name, File.separator);
            ITreeNode file = newfile;
            if (this.isDirectory(file)) {
                if (this.isIncluded(name, tokenizedName)) {
                    this.accountForIncludedDir(name, file, fast);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.scandirWrap(file, String.valueOf(name) + File.separator, fast);
                    }
                }
                if (!fast) {
                    this.scandirWrap(file, String.valueOf(name) + File.separator, fast);
                }
            } else if (this.isIncluded(name, tokenizedName)) {
                this.accountForIncludedFile(name, file);
            } else {
                this.everythingIncluded = false;
                this.filesNotIncluded.addElement(name);
            }
            ++n2;
        }
    }

    protected boolean isSelected(String name, ITreeNode file) {
        return true;
    }

    @Override
    public String[] getIncludedFiles() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    @Override
    public String[] getIncludedDirectories() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        Arrays.sort(directories);
        return directories;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    public synchronized int getIncludedFilesCount() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.filesIncluded.size();
    }

    public synchronized int getIncludedDirsCount() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.dirsIncluded.size();
    }

    public ITreeNode[] trimInapplicableEntries(ITreeNode[] newfiles, ITreeNode dir, String vpath) {
        return newfiles;
    }

    protected void scandirWrap(T dir, String vpath, boolean fast) {
        if (this.iterator == null) {
            this.scandir((ITreeNode)dir, vpath, fast);
        } else {
            this.iterator.addElementToScanList(dir, vpath);
        }
    }

    private void accountForIncludedDir(String name, T file, boolean fast) {
        this.processIncluded(name, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (this.couldHoldIncluded(name)) {
            this.scandirWrap(file, String.valueOf(name) + File.separator, fast);
        }
    }

    private void accountForIncludedFile(String name, T file) {
        this.processIncluded(name, file, this.filesIncluded, this.filesExcluded, this.filesDeselected);
    }

    protected void processIncluded(String name, T file, Vector<String> inc, Vector<String> exc, Vector<String> des) {
        if (inc.contains(name) || exc.contains(name) || des.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            exc.add(name);
            this.postExclude((ITreeNode)file, name);
        } else if (this.isSelected(name, (ITreeNode)file)) {
            included = true;
            inc.add(name);
            this.postInclude(file, name);
        } else {
            des.add(name);
        }
        this.everythingIncluded &= included;
    }

    protected void postInclude(T f, String name) {
        if (this.iterator != null) {
            this.iterator.addMatch(f, name);
        }
    }

    protected void postExclude(ITreeNode f, String name) {
    }

    @Override
    public Iterator<T> iterator() {
        this.iterator = new DirectoryScannerIterator(this);
        this.scanPrepare();
        this.scandir((ITreeNode)this.basedir, "", true);
        return this.iterator;
    }

    protected ITreeNode[] listChildren(ITreeNode node) {
        return node.listChildren();
    }

    protected ITreeNode getChild(T file, String child) {
        return file.getChild(child);
    }

    protected String getName(ITreeNode node) {
        return node.getName();
    }

    protected boolean isDirectory(ITreeNode file) {
        return !file.isLeaf();
    }

    protected boolean basedirMustExist() {
        return false;
    }

    protected boolean exists(T node) {
        return false;
    }

    @Override
    public void scanDirectory(T file, String vpath) {
        this.scandir((ITreeNode)file, vpath, true);
    }

    @Override
    public void cleanup() {
    }
}

