/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.composites;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;
import org.jboss.ide.eclipse.as.wtp.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.ui.composites.IRuntimeHomeCompositeListener;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;

public class RuntimeHomeComposite
extends Composite {
    private IWizardHandle handle;
    private TaskModel tm;
    protected Label homeDirLabel;
    protected Text homeDirText;
    protected Button homeDirButton;
    protected String homeDir;
    private IRuntimeHomeCompositeListener listener;

    public RuntimeHomeComposite(Composite parent, int style, IWizardHandle handle, TaskModel tm) {
        super(parent, style);
        this.handle = handle;
        this.tm = tm;
        this.createWidgets();
    }

    protected TaskModel getTaskModel() {
        return this.tm;
    }

    protected IWizardHandle getWizardHandle() {
        return this.handle;
    }

    public void setListener(IRuntimeHomeCompositeListener listener) {
        this.listener = listener;
    }

    public String getHomeDirectory() {
        return this.homeDir;
    }

    protected void homeDirChanged() {
        if (this.listener != null) {
            this.listener.homeChanged();
        }
    }

    protected void createWidgets() {
        this.setLayout((Layout)new FormLayout());
        this.homeDirLabel = new Label((Composite)this, 0);
        this.homeDirLabel.setText(Messages.wf_HomeDirLabel);
        this.homeDirText = new Text((Composite)this, 2048);
        this.homeDirButton = new Button((Composite)this, 0);
        this.homeDirButton.setText(Messages.browse);
        this.homeDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RuntimeHomeComposite.this.homeDir = RuntimeHomeComposite.this.homeDirText.getText();
                RuntimeHomeComposite.this.homeDirChanged();
            }
        });
        this.homeDirButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RuntimeHomeComposite.this.browseHomeDirClicked();
            }

            public void widgetSelected(SelectionEvent e) {
                RuntimeHomeComposite.this.browseHomeDirClicked();
            }
        });
        this.homeDirLabel.setLayoutData((Object)FormDataUtility.createFormData2(null, 0, this.homeDirText, -5, 0, 5, null, 0));
        this.homeDirText.setLayoutData((Object)FormDataUtility.createFormData2(this.homeDirLabel, 5, null, 0, 0, 5, this.homeDirButton, -5));
        this.homeDirButton.setLayoutData((Object)FormDataUtility.createFormData2(this.homeDirLabel, 5, null, 0, null, 0, 100, 0));
    }

    protected IRuntime getRuntimeFromTaskModel() {
        IRuntime r = (IRuntime)this.tm.getObject("runtime");
        return r;
    }

    protected void browseHomeDirClicked() {
        File directory;
        File file;
        File file2 = file = this.homeDir == null ? null : new File(this.homeDir);
        if (file != null && !file.exists()) {
            file = null;
        }
        if ((directory = RuntimeHomeComposite.getDirectory(file, this.getShell())) != null) {
            this.homeDir = directory.getAbsolutePath();
            this.homeDirText.setText(this.homeDir);
        }
    }

    protected static File getDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    public void fillHomeDir(IRuntime rt) {
        this.homeDir = rt.getLocation() == null ? this.getDefaultHomeDirectory(rt.getRuntimeType()) : rt.getLocation().toOSString();
        this.homeDirText.setText(this.homeDir);
        boolean isWC = rt instanceof IRuntimeWorkingCopy;
        if (isWC) {
            ((IRuntimeWorkingCopy)rt).setLocation((IPath)new Path(this.homeDir));
        }
        this.homeDirText.setEnabled(isWC);
        this.homeDirButton.setEnabled(isWC);
    }

    protected String getDefaultHomeDirectory(IRuntimeType rtt) {
        return "";
    }

    public boolean isHomeValid() {
        if (this.homeDir == null || this.homeDir.length() == 1 || !new File(this.homeDir).exists()) {
            return false;
        }
        ServerBeanLoader l = new ServerBeanLoader(new File(this.homeDir));
        return l.getServerBeanType() != ServerBeanType.UNKNOWN;
    }
}

