/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.RestartModuleAction;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.actions.ServerActionMessages;

public class ChangeTimeStampActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow window;
    String tooltip = null;
    IProject project = null;
    IModule[] module = null;
    IServer server = null;
    RestartModuleAction[] restartActions = null;
    private static final String ESB_PROJECT_FACET = "jst.jboss.esb";

    private static boolean isESBProject(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            JBossServerUIPlugin.log(e.getMessage(), (Exception)((Object)e));
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)ESB_PROJECT_FACET)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)ESB_PROJECT_FACET);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.project == null && action.isEnabled()) {
            action.setEnabled(false);
        }
        if (this.tooltip != null && selection instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)selection).getFirstElement();
            this.setProject(o);
            this.setModuleAndServer(o);
            this.buildActions();
            if (this.project != null) {
                action.setEnabled(this.computeEnabled());
                action.setToolTipText(NLS.bind((String)ServerActionMessages.CHANGE_TIME_STAMP, (Object)this.project.getName()));
                return;
            }
        }
        this.tooltip = ServerActionMessages.CHANGE_TIME_STAMP_DEFAULT;
        action.setToolTipText(this.tooltip);
    }

    protected void setProject(Object selection) {
        Object r;
        this.project = selection instanceof IResource ? ((IResource)selection).getProject() : (selection instanceof IAdaptable ? ((r = ((IAdaptable)selection).getAdapter(IResource.class)) instanceof IResource ? ((IResource)r).getProject() : null) : (selection instanceof ModuleServer ? ((ModuleServer)selection).module[0].getProject() : null));
    }

    void setModuleAndServer(Object selection) {
        if (selection instanceof IServer) {
            this.server = (IServer)selection;
            this.module = null;
        } else if (selection instanceof ModuleServer) {
            this.server = ((ModuleServer)selection).server;
            this.module = ((ModuleServer)selection).module;
        }
        if (this.project != null) {
            IModule[] iModuleArray;
            IModule tmp = ServerUtil.getModule((IProject)this.project);
            if (tmp == null) {
                iModuleArray = null;
            } else {
                IModule[] iModuleArray2 = new IModule[1];
                iModuleArray = iModuleArray2;
                iModuleArray2[0] = tmp;
            }
            this.module = iModuleArray;
        }
    }

    void buildActions() {
        ArrayList<RestartModuleAction> actionList = new ArrayList<RestartModuleAction>();
        if (this.module != null) {
            IServer[] targetServers = null;
            if (this.server == null) {
                List<IServer> list = ChangeTimeStampActionDelegate.getServers(this.module[0]);
                targetServers = list.toArray(new IServer[list.size()]);
            } else {
                targetServers = new IServer[]{this.server};
            }
            int i = 0;
            while (i < targetServers.length) {
                RestartModuleAction a = new RestartModuleAction(targetServers[i], this.module);
                if (a.isEnabled()) {
                    actionList.add(a);
                }
                ++i;
            }
        }
        this.restartActions = actionList.toArray(new RestartModuleAction[actionList.size()]);
    }

    protected boolean computeEnabled() {
        boolean canRestart;
        if (this.module == null) {
            return false;
        }
        if (this.project == null || !this.project.isAccessible()) {
            return false;
        }
        boolean isWar = JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project);
        boolean isEar = JavaEEProjectUtilities.isEARProject((IProject)this.project);
        boolean isEJB = JavaEEProjectUtilities.isEJBProject((IProject)this.project);
        boolean isEsb = ChangeTimeStampActionDelegate.isESBProject(this.project);
        boolean bl = canRestart = isEar || isEJB || isWar || isEsb;
        return canRestart && this.restartActions != null && this.restartActions.length > 0;
    }

    public void run(IAction action) {
        int i = 0;
        while (i < this.restartActions.length) {
            this.restartActions[i].run();
            ++i;
        }
    }

    static List<IServer> getServers(IModule module) {
        IServer[] servers;
        ArrayList<IServer> result = new ArrayList<IServer>();
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer s = iServerArray[n2];
            IModule[] modules = s.getModules();
            int j = 0;
            while (j < modules.length) {
                if (modules[j].equals(module)) {
                    result.add(s);
                }
                ++j;
            }
            ++n2;
        }
        return result;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dispose() {
        this.window = null;
    }
}

