/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.actions.ServerActionMessages;

public class DeployHandler
extends AbstractHandler {
    protected Shell shell;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = this.getSelection(event);
        this.makeDeployable(selection);
        return null;
    }

    protected ISelection getSelection(ExecutionEvent event) {
        ISelection selection = null;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof ITextEditor) {
            IEditorInput input = ((ITextEditor)part).getEditorInput();
            if (input instanceof FileEditorInput) {
                selection = new StructuredSelection((Object)((FileEditorInput)input).getFile());
            }
        } else {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            Object[] objs = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof IJavaProject) {
                    objs[i] = ((IJavaProject)objs[i]).getProject();
                }
                ++i;
            }
            selection = new StructuredSelection(objs);
        }
        return selection;
    }

    protected void makeDeployable(ISelection selection) {
        IStructuredSelection sel2 = (IStructuredSelection)selection;
        Object[] objs = sel2.toArray();
        IModule[] modules = new IModule[objs.length];
        HashSet<IProject> alreadyDeployable = new HashSet<IProject>();
        int i = 0;
        while (i < objs.length) {
            IModule[] mods;
            IProject p = null;
            if (objs[i] instanceof IResource) {
                p = ((IResource)objs[i]).getProject();
            }
            if (p != null && (mods = ServerUtil.getModules(p)) != null && mods.length > 0 && ModuleCoreNature.isFlexibleProject((IProject)p)) {
                alreadyDeployable.add(p);
            }
            ++i;
        }
        if (alreadyDeployable.size() > 0 && !this.showAreYouSureDialog(alreadyDeployable)) {
            return;
        }
        i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof IResource) {
                SingleDeployableFactory.makeDeployable((IPath)((IResource)objs[i]).getFullPath());
                modules[i] = SingleDeployableFactory.findModule((IPath)((IResource)objs[i]).getFullPath());
            }
            ++i;
        }
        this.tryToPublish(selection);
    }

    private boolean showAreYouSureDialog(HashSet<IProject> set) {
        Iterator<IProject> i = set.iterator();
        String projs = "";
        while (i.hasNext()) {
            projs = String.valueOf(projs) + i.next().getName() + ", ";
        }
        projs = projs.substring(0, projs.length() - 2);
        boolean ret = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)ServerActionMessages.DeployActionMessageBoxTitle, (String)ServerActionMessages.DeployActionMessageBoxMsg);
        return ret;
    }

    protected void makeUndeployable(ISelection selection) {
        IStructuredSelection sel2 = (IStructuredSelection)selection;
        Object[] objs = sel2.toArray();
        ArrayList<IPath> paths = new ArrayList<IPath>();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof IResource) {
                paths.add(((IResource)objs[i]).getFullPath());
            }
            ++i;
        }
        new SingleDeployableFactory.UndeployFromServerJob(paths).schedule();
    }

    protected void tryToPublish(ISelection selection) {
        IServer server;
        IServer[] deployableServersAsIServers = ServerConverter.getDeployableServersAsIServers();
        if (deployableServersAsIServers.length == 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.ActionDelegateDeployableServersNotFoundTitle, (String)Messages.ActionDelegateDeployableServersNotFoundDesc);
        }
        if ((server = this.getServer(this.shell, deployableServersAsIServers)) == null) {
            return;
        }
        Status errorStatus = null;
        String errorMessage = null;
        String errorTitle = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel2 = (IStructuredSelection)selection;
            Object[] objs = sel2.toArray();
            if (server == null) {
                errorStatus = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ActionDelegateDeployableServersNotFoundTitle);
                errorTitle = Messages.ActionDelegateCannotPublish;
                errorMessage = Messages.ActionDelegateDeployableServersNotFoundDesc;
            } else if (objs == null || !this.allFiles(objs)) {
                errorStatus = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ActionDelegateFileResourcesOnly);
                errorTitle = Messages.ActionDelegateCannotPublish;
                errorMessage = Messages.ActionDelegateFileResourcesOnly;
            } else {
                IModule[] modules = new IModule[objs.length];
                int i = 0;
                while (i < objs.length) {
                    modules[i] = SingleDeployableFactory.findModule((IPath)((IResource)objs[i]).getFullPath());
                    ++i;
                }
                try {
                    IServerWorkingCopy copy = server.createWorkingCopy();
                    copy.modifyModules(modules, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
                    IServer saved = copy.save(false, (IProgressMonitor)new NullProgressMonitor());
                    new PublishServerJob(saved).schedule();
                }
                catch (CoreException ce) {
                    errorStatus = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ActionDelegatePublishFailed, (Throwable)ce);
                    errorTitle = Messages.ActionDelegateCannotPublish;
                    errorMessage = Messages.ActionDelegatePublishFailed;
                }
            }
        }
        if (errorStatus != null) {
            ErrorDialog dialog = new ErrorDialog(new Shell(), errorTitle, errorMessage, errorStatus, 65535);
            dialog.open();
        }
    }

    protected boolean allFiles(Object[] objs) {
        int i = 0;
        while (i < objs.length) {
            if (!(objs[i] instanceof IResource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected IServer getServer(Shell shell, IServer[] servers) {
        if (servers.length == 0) {
            return null;
        }
        if (servers.length == 1) {
            return servers[0];
        }
        SelectServerDialog d = new SelectServerDialog(shell);
        int result = d.open();
        if (result == 0) {
            return d.getSelectedServer();
        }
        return null;
    }

    public class SelectServerDialog
    extends Dialog {
        private Object selected;

        protected SelectServerDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.ActionDelegateSelectServer);
        }

        public IServer getSelectedServer() {
            if (this.selected instanceof IServer) {
                return (IServer)this.selected;
            }
            return null;
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            Tree tree = new Tree(c, 68356);
            tree.setLayoutData((Object)new GridData(1808));
            final TreeViewer viewer = new TreeViewer(tree);
            viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    return null;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object[] getElements(Object inputElement) {
                    return ServerConverter.getDeployableServersAsIServers();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderExtension());
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection sel = viewer.getSelection();
                    if (sel instanceof IStructuredSelection) {
                        SelectServerDialog.this.selected = ((IStructuredSelection)sel).getFirstElement();
                    }
                }
            });
            viewer.setInput((Object)new Boolean(true));
            return c;
        }

        private final class LabelProviderExtension
        extends BaseLabelProvider
        implements ILabelProvider {
            private LabelProviderExtension() {
            }

            public Image getImage(Object element) {
                if (element instanceof IServer) {
                    return ImageResource.getImage((String)((IServer)element).getServerType().getId());
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IServer) {
                    return ((IServer)element).getName();
                }
                return "";
            }
        }
    }
}

