/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.AS7DeploymentScannerUtility;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.osgi.service.prefs.BackingStoreException;

public class ModifyDeploymentScannerIntervalDialog
extends TitleAreaDialog {
    public static final String AS7_IGNORE_ZERO_INTERVAL_SCANNER_SETTING = "AS7_IGNORE_ZERO_INTERVAL_SCANNER_SETTING";
    private IServer server;
    private AS7DeploymentScannerUtility.Scanner[] scanners;
    private Label extraInfo;
    private TableViewer tv;
    private boolean askAgainSelected = false;
    private String[] headings = new String[]{Messages.DeploymentScannerColumnName, Messages.DeploymentScannerColumnPath, Messages.DeploymentScannerColumnInterval};
    private ArrayList<AS7DeploymentScannerUtility.Scanner> changed = new ArrayList();

    public ModifyDeploymentScannerIntervalDialog(IServer server, AS7DeploymentScannerUtility.Scanner[] scanners, Shell parentShell) {
        super(parentShell);
        this.scanners = scanners;
        this.server = server;
    }

    public AS7DeploymentScannerUtility.Scanner[] getChangedScanners() {
        return this.changed.toArray(new AS7DeploymentScannerUtility.Scanner[this.changed.size()]);
    }

    public boolean getAskAgainSelection() {
        return this.askAgainSelected;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.setMessage(NLS.bind((String)Messages.DeploymentScannerDialogWarning, (Object)this.server.getName()), 2);
        this.setTitle(Messages.DeploymentScannerDialogTitle);
        this.getShell().setText(Messages.DeploymentScannerDialogTitle);
        this.getShell().setSize(500, 400);
        return c;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite((Composite)super.createDialogArea(parent), 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new GridLayout(1, false));
        this.extraInfo = new Label(main, 64);
        this.extraInfo.setText(Messages.DeploymentScannerDialogWarningExplained);
        this.tv = new TableViewer(main, 65536);
        this.tv.setContentProvider((IContentProvider)new ScannerContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new ScannerLabelProvider());
        Table table = this.tv.getTable();
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tc1 = new TableColumn(table, 0x1000000);
        TableColumn tc2 = new TableColumn(table, 0x1000000);
        TableColumn tc3 = new TableColumn(table, 0x1000000);
        int i = 0;
        int n = table.getColumnCount();
        while (i < n) {
            table.getColumn(i).setText(this.headings[i]);
            table.getColumn(i).pack();
            ++i;
        }
        tc1.setWidth(150);
        tc2.setWidth(180);
        tc3.setWidth(70);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        CellEditor[] editors = new CellEditor[4];
        editors[0] = null;
        editors[1] = null;
        editors[2] = new TextCellEditor((Composite)table);
        this.tv.setColumnProperties(this.headings);
        this.tv.setCellModifier((ICellModifier)new ScannerCellModifier());
        this.tv.setCellEditors(editors);
        this.tv.setInput((Object)this.scanners);
        final Button askAgain = new Button(main, 32);
        askAgain.setText("Don't ask this again.");
        askAgain.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ModifyDeploymentScannerIntervalDialog.this.askAgainSelected = askAgain.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ModifyDeploymentScannerIntervalDialog.this.askAgainSelected = askAgain.getSelection();
            }
        });
        return main;
    }

    public static class DeploymentScannerUIServerStartedListener
    extends UnitedServerListener {
        public void serverChanged(ServerEvent event) {
            IServer s = event.getServer();
            JBossExtendedProperties props = (JBossExtendedProperties)s.loadAdapter(JBossExtendedProperties.class, null);
            if (props != null && props.getMultipleDeployFolderSupport() == 3 && DeploymentScannerUIServerStartedListener.serverSwitchesToState((ServerEvent)event, (int)2)) {
                this.launchJob(s);
            }
        }

        private void launchJob(final IServer server) {
            new Job(Messages.DeploymentScannerCheckJobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    AS7DeploymentScannerUtility.Scanner[] scanners;
                    IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
                    boolean ignore = prefs.getBoolean(ModifyDeploymentScannerIntervalDialog.AS7_IGNORE_ZERO_INTERVAL_SCANNER_SETTING, false);
                    if (!ignore && DeploymentScannerUIServerStartedListener.this.hasScannersAtZero(server, scanners = new AS7DeploymentScannerUtility().getDeploymentScanners(server))) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DeploymentScannerUIServerStartedListener.this.launchDialog(server, scanners);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        private void launchDialog(final IServer server, AS7DeploymentScannerUtility.Scanner[] scanners) {
            ModifyDeploymentScannerIntervalDialog d = new ModifyDeploymentScannerIntervalDialog(server, scanners, Display.getDefault().getActiveShell());
            int ret = d.open();
            final AS7DeploymentScannerUtility.Scanner[] changedArray = d.getChangedScanners();
            boolean neverAskAgainSetting = d.getAskAgainSelection();
            if (neverAskAgainSetting) {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
                prefs.putBoolean(ModifyDeploymentScannerIntervalDialog.AS7_IGNORE_ZERO_INTERVAL_SCANNER_SETTING, true);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            if (ret == 0 && changedArray.length > 0) {
                new Job(Messages.DeploymentScannerUpdateJobTitle){

                    protected IStatus run(IProgressMonitor monitor) {
                        return DeploymentScannerUIServerStartedListener.this.updateServersScanners(server, changedArray);
                    }
                }.schedule();
            }
        }

        private IStatus updateServersScanners(IServer server, AS7DeploymentScannerUtility.Scanner[] changed) {
            AS7DeploymentScannerUtility util = new AS7DeploymentScannerUtility();
            int i = 0;
            while (i < changed.length) {
                util.updateDeploymentScannerInterval(server, changed[i].getName(), changed[i].getInterval());
                ++i;
            }
            return Status.OK_STATUS;
        }

        private boolean hasScannersAtZero(IServer server, AS7DeploymentScannerUtility.Scanner[] scanners) {
            int i = 0;
            while (i < scanners.length) {
                if (scanners[i].getInterval() <= 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private class ScannerCellModifier
    implements ICellModifier {
        private ScannerCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(ModifyDeploymentScannerIntervalDialog.this.headings[2]);
        }

        public Object getValue(Object element, String property) {
            int i = ((AS7DeploymentScannerUtility.Scanner)element).getInterval();
            return new Integer(i).toString();
        }

        public void modify(Object element, String property, Object value) {
            String element2 = ((TableItem)element).getText();
            AS7DeploymentScannerUtility.Scanner e = null;
            int i = 0;
            while (i < ModifyDeploymentScannerIntervalDialog.this.scanners.length) {
                if (ModifyDeploymentScannerIntervalDialog.this.scanners[i].getName().equals(element2)) {
                    e = ModifyDeploymentScannerIntervalDialog.this.scanners[i];
                    break;
                }
                ++i;
            }
            if (!value.toString().equals(e.getInterval())) {
                Integer i2 = null;
                try {
                    i2 = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {}
                if (i2 != null) {
                    e.setInterval(i2.intValue());
                    if (!ModifyDeploymentScannerIntervalDialog.this.changed.contains(e)) {
                        ModifyDeploymentScannerIntervalDialog.this.changed.add(e);
                    }
                    ModifyDeploymentScannerIntervalDialog.this.tv.refresh();
                }
            }
        }
    }

    private class ScannerContentProvider
    implements IStructuredContentProvider {
        private ScannerContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ModifyDeploymentScannerIntervalDialog.this.scanners;
        }
    }

    private class ScannerLabelProvider
    implements ITableLabelProvider {
        private ScannerLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((AS7DeploymentScannerUtility.Scanner)element).getName();
            }
            if (columnIndex == 1) {
                return ((AS7DeploymentScannerUtility.Scanner)element).getAddress();
            }
            if (columnIndex == 2) {
                return "" + ((AS7DeploymentScannerUtility.Scanner)element).getInterval();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

