/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.editor.ServerEditorOverviewPageModifier;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.command.SetServerRuntimeCommand;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;

public class AddRuntimeComboOverviewPageModifier
extends ServerEditorOverviewPageModifier {
    private IRuntime[] runtimes;
    private Combo runtimeCombo;
    private IRuntimeLifecycleListener runtimeListener;
    protected boolean updating = false;

    public void handlePropertyChanged(PropertyChangeEvent event) {
    }

    public void createControl(ServerEditorOverviewPageModifier.UI_LOCATION location, Composite parent) {
        this.addControl(parent, null);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)AddRuntimeComboOverviewPageModifier.this.runtimeListener);
            }
        });
    }

    private void addControl(Composite composite, FormToolkit toolkit) {
        int decorationWidth = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        if (this.serverWc != null && this.serverWc.getServerType() != null) {
            Hyperlink link = new Hyperlink(composite, 0);
            link.setText(Messages.serverEditorOverviewRuntime);
            link.setUnderlined(true);
            link.setForeground(Display.getDefault().getSystemColor(9));
            final IServerWorkingCopy server2 = this.serverWc;
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IRuntime runtime = server2.getRuntime();
                    if (runtime != null && ServerUIPlugin.hasWizardFragment((String)RuntimeUtils.getRuntimeTypeId((IServerType)server2.getServerType()))) {
                        AddRuntimeComboOverviewPageModifier.this.editRuntime(runtime);
                    }
                }
            });
            IRuntime runtime = this.serverWc.getRuntime();
            if (runtime == null || !ServerUIPlugin.hasWizardFragment((String)RuntimeUtils.getRuntimeTypeId((IServerType)this.serverWc.getServerType()))) {
                link.setEnabled(false);
            }
            IRuntimeType runtimeType = this.serverWc.getServerType().getRuntimeType();
            this.runtimes = ServerUIPlugin.getRuntimes((IRuntimeType)runtimeType);
            this.runtimeCombo = new Combo(composite, 8);
            GridData data = new GridData(768);
            data.horizontalIndent = decorationWidth;
            this.runtimeCombo.setLayoutData((Object)data);
            this.updateRuntimeCombo();
            if (runtime == null) {
                String[] items;
                if (!this.requiresRuntime() && (items = this.runtimeCombo.getItems()).length > 0) {
                    this.runtimeCombo.select(items.length - 1);
                }
            } else {
                int size = this.runtimes.length;
                int i = 0;
                while (i < size) {
                    if (this.runtimes[i].equals(runtime)) {
                        this.runtimeCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.runtimeCombo.addSelectionListener(this.runtimeComboSelectionListener(link));
            whs.setHelp((Control)this.runtimeCombo, "org.eclipse.wst.server.ui.seop0008");
            this.runtimeListener = this.runtimeLifecycleListener(runtime);
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeListener);
        }
    }

    protected IRuntimeLifecycleListener runtimeLifecycleListener(final IRuntime originalRuntime) {
        return new IRuntimeLifecycleListener(){

            public void runtimeChanged(final IRuntime runtime2) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (runtime2.equals(AddRuntimeComboOverviewPageModifier.this.serverWc.getRuntime())) {
                            try {
                                if ((this).AddRuntimeComboOverviewPageModifier.this.updating) {
                                    return;
                                }
                                (this).AddRuntimeComboOverviewPageModifier.this.updating = true;
                                AddRuntimeComboOverviewPageModifier.this.executeCommand((IUndoableOperation)new SetServerRuntimeCommand(AddRuntimeComboOverviewPageModifier.this.serverWc, runtime2));
                                (this).AddRuntimeComboOverviewPageModifier.this.updating = false;
                            }
                            catch (Exception exception) {}
                        }
                        if (AddRuntimeComboOverviewPageModifier.this.runtimeCombo != null && !AddRuntimeComboOverviewPageModifier.this.runtimeCombo.isDisposed()) {
                            AddRuntimeComboOverviewPageModifier.this.updateRuntimeCombo();
                            int size2 = AddRuntimeComboOverviewPageModifier.this.runtimes.length;
                            int i = 0;
                            while (i < size2) {
                                if (AddRuntimeComboOverviewPageModifier.this.runtimes[i].equals(originalRuntime)) {
                                    AddRuntimeComboOverviewPageModifier.this.runtimeCombo.select(i);
                                }
                                ++i;
                            }
                        }
                    }
                });
            }

            public void runtimeAdded(IRuntime runtime2) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AddRuntimeComboOverviewPageModifier.this.runtimeCombo != null && !AddRuntimeComboOverviewPageModifier.this.runtimeCombo.isDisposed()) {
                            AddRuntimeComboOverviewPageModifier.this.updateRuntimeCombo();
                            int size2 = AddRuntimeComboOverviewPageModifier.this.runtimes.length;
                            int i = 0;
                            while (i < size2) {
                                if (AddRuntimeComboOverviewPageModifier.this.runtimes[i].equals(originalRuntime)) {
                                    AddRuntimeComboOverviewPageModifier.this.runtimeCombo.select(i);
                                }
                                ++i;
                            }
                        }
                    }
                });
            }

            public void runtimeRemoved(IRuntime runtime2) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AddRuntimeComboOverviewPageModifier.this.runtimeCombo != null && !AddRuntimeComboOverviewPageModifier.this.runtimeCombo.isDisposed()) {
                            AddRuntimeComboOverviewPageModifier.this.updateRuntimeCombo();
                            int size2 = AddRuntimeComboOverviewPageModifier.this.runtimes.length;
                            int i = 0;
                            while (i < size2) {
                                if (AddRuntimeComboOverviewPageModifier.this.runtimes[i].equals(originalRuntime)) {
                                    AddRuntimeComboOverviewPageModifier.this.runtimeCombo.select(i);
                                }
                                ++i;
                            }
                        }
                    }
                });
            }
        };
    }

    protected SelectionListener runtimeComboSelectionListener(final Hyperlink link) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IRuntime notNotNull;
                    if (AddRuntimeComboOverviewPageModifier.this.updating) {
                        return;
                    }
                    AddRuntimeComboOverviewPageModifier.this.updating = true;
                    int selIndex = AddRuntimeComboOverviewPageModifier.this.runtimeCombo.getSelectionIndex();
                    IRuntime newRuntime = selIndex < AddRuntimeComboOverviewPageModifier.this.runtimes.length ? AddRuntimeComboOverviewPageModifier.this.runtimes[selIndex] : null;
                    boolean bothNull = newRuntime == null && AddRuntimeComboOverviewPageModifier.this.serverWc.getRuntime() == null;
                    IRuntime notNull = newRuntime == null ? AddRuntimeComboOverviewPageModifier.this.serverWc.getRuntime() : newRuntime;
                    IRuntime iRuntime = notNotNull = notNull == newRuntime ? AddRuntimeComboOverviewPageModifier.this.serverWc.getRuntime() : newRuntime;
                    if (!bothNull && !notNull.equals(notNotNull)) {
                        AddRuntimeComboOverviewPageModifier.this.executeCommand((IUndoableOperation)new SetServerRuntimeCommand(AddRuntimeComboOverviewPageModifier.this.serverWc, newRuntime));
                    }
                    link.setEnabled(newRuntime != null && ServerUIPlugin.hasWizardFragment((String)RuntimeUtils.getRuntimeTypeId((IRuntime)newRuntime)));
                    AddRuntimeComboOverviewPageModifier.this.updating = false;
                }
                catch (Exception exception) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    protected void updateRuntimeCombo() {
        IRuntimeType runtimeType = this.serverWc.getServerType().getRuntimeType();
        this.runtimes = ServerUIPlugin.getRuntimes((IRuntimeType)runtimeType);
        if (SocketUtil.isLocalhost((String)this.serverWc.getHost())) {
            ArrayList<IRuntime> runtimes2 = new ArrayList<IRuntime>();
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                IRuntime runtime2 = this.runtimes[i];
                if (!runtime2.isStub()) {
                    runtimes2.add(runtime2);
                }
                ++i;
            }
            this.runtimes = new IRuntime[runtimes2.size()];
            runtimes2.toArray(this.runtimes);
        }
        int size = this.runtimes.length;
        boolean requiresRuntime = this.requiresRuntime();
        int size2 = size + (requiresRuntime ? 0 : 1);
        String[] items = new String[size2];
        int i = 0;
        while (i < size) {
            items[i] = this.runtimes[i].getName();
            ++i;
        }
        if (!requiresRuntime) {
            items[size2 - 1] = "(No Runtime)";
        }
        this.runtimeCombo.setItems(items);
    }

    protected void editRuntime(IRuntime runtime) {
        IRuntimeWorkingCopy runtimeWorkingCopy = runtime.createWorkingCopy();
        if (this.showWizard(runtimeWorkingCopy) != 1) {
            try {
                runtimeWorkingCopy.save(false, null);
            }
            catch (Exception exception) {}
        }
    }

    protected int showWizard(IRuntimeWorkingCopy runtimeWorkingCopy) {
        String title = Messages.wizEditRuntimeWizardTitle;
        final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment((String)runtimeWorkingCopy.getRuntimeType().getId());
        if (fragment2 == null) {
            return 1;
        }
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add(fragment2);
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(title, fragment, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(this.runtimeCombo.getShell(), (IWizard)wizard);
        return dialog.open();
    }

    private boolean requiresRuntime() {
        String currentProfile = ServerProfileModel.getProfile((IServerAttributes)this.serverWc, (String)"local");
        ServerProfileModel.ServerProfile sp = ServerProfileModel.getDefault().getProfile(this.serverWc.getServerType().getId(), currentProfile);
        boolean requires = ServerProfileModel.getDefault().profileRequiresRuntime(this.serverWc.getServerType().getId(), sp.getId());
        return requires;
    }
}

