/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.views.log.Messages;
import org.jboss.ide.eclipse.as.ui.views.AbstractEntry;
import org.jboss.ide.eclipse.as.ui.views.LogSession;

public class LogEntry
extends AbstractEntry {
    public static final String F_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final ThreadLocal<SimpleDateFormat> F_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(LogEntry.F_DATE_FORMAT);
        }
    };
    private String pluginId;
    private int severity;
    private int code;
    private String fDateString;
    private Date fDate;
    private String message;
    private String stack;
    private LogSession session;

    public LogEntry() {
    }

    public LogSession getSession() {
        if (this.session == null && this.parent != null && this.parent instanceof LogEntry) {
            return ((LogEntry)((Object)this.parent)).getSession();
        }
        return this.session;
    }

    void setSession(LogSession session) {
        this.session = session;
    }

    public LogEntry(IStatus status) {
        this.processStatus(status);
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public int getCode() {
        return this.code;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStack() {
        return this.stack;
    }

    public String getFormattedDate() {
        if (this.fDateString == null) {
            this.fDateString = F_SDF.get().format(this.getDate());
        }
        return this.fDateString;
    }

    public Date getDate() {
        if (this.fDate == null) {
            this.fDate = new Date(0L);
        }
        return this.fDate;
    }

    public String getSeverityText() {
        return this.getSeverityText(this.severity);
    }

    public String toString() {
        return this.getSeverityText();
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object arg0) {
        return null;
    }

    @Override
    public String getLabel(Object obj) {
        return this.getSeverityText();
    }

    private String getSeverityText(int severity) {
        switch (severity) {
            case 4: {
                return Messages.LogView_severity_error;
            }
            case 2: {
                return Messages.LogView_severity_warning;
            }
            case 1: {
                return Messages.LogView_severity_info;
            }
            case 0: {
                return Messages.LogView_severity_ok;
            }
        }
        return "?";
    }

    void processEntry(String line) {
        boolean noSeverity;
        StringTokenizer stok = new StringTokenizer(line, " ");
        int tokenCount = stok.countTokens();
        boolean bl = noSeverity = stok.countTokens() < 5;
        if (noSeverity) {
            this.severity = 0;
            this.code = 0;
        }
        StringBuffer dateBuffer = new StringBuffer();
        int i = 0;
        while (i < tokenCount) {
            String token = stok.nextToken();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    this.pluginId = token;
                    break;
                }
                case 2: {
                    if (noSeverity) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.severity = this.parseInteger(token);
                    break;
                }
                case 3: {
                    if (noSeverity) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.code = this.parseInteger(token);
                    break;
                }
                default: {
                    if (dateBuffer.length() > 0) {
                        dateBuffer.append(" ");
                    }
                    dateBuffer.append(token);
                }
            }
            ++i;
        }
        try {
            Date date = F_SDF.get().parse(dateBuffer.toString());
            if (date != null) {
                this.fDate = date;
                this.fDateString = F_SDF.get().format(this.fDate);
            }
        }
        catch (ParseException parseException) {}
    }

    int processSubEntry(String line) {
        StringTokenizer stok = new StringTokenizer(line, " ");
        int tokenCount = stok.countTokens();
        boolean byFrameWork = stok.countTokens() < 5;
        StringBuffer dateBuffer = new StringBuffer();
        int depth = 0;
        int i = 0;
        while (i < tokenCount) {
            String token = stok.nextToken();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    depth = this.parseInteger(token);
                    break;
                }
                case 2: {
                    this.pluginId = token;
                    break;
                }
                case 3: {
                    if (byFrameWork) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.severity = this.parseInteger(token);
                    break;
                }
                case 4: {
                    if (byFrameWork) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.code = this.parseInteger(token);
                    break;
                }
                default: {
                    if (dateBuffer.length() > 0) {
                        dateBuffer.append(" ");
                    }
                    dateBuffer.append(token);
                }
            }
            ++i;
        }
        try {
            Date date = F_SDF.get().parse(dateBuffer.toString());
            if (date != null) {
                this.fDate = date;
                this.fDateString = F_SDF.get().format(this.fDate);
            }
        }
        catch (ParseException parseException) {}
        return depth;
    }

    private int parseInteger(String token) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void setStack(String stack) {
        this.stack = stack;
    }

    void setMessage(String message) {
        this.message = message;
    }

    private void processStatus(IStatus status) {
        IStatus[] schildren;
        this.pluginId = status.getPlugin();
        this.severity = status.getSeverity();
        this.code = status.getCode();
        this.fDate = new Date();
        this.fDateString = F_SDF.get().format(this.fDate);
        this.message = status.getMessage();
        Throwable throwable = status.getException();
        if (throwable != null) {
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            throwable.printStackTrace(pwriter);
            pwriter.flush();
            pwriter.close();
            this.stack = swriter.toString();
        }
        if ((schildren = status.getChildren()).length > 0) {
            int i = 0;
            while (i < schildren.length) {
                LogEntry child = new LogEntry(schildren[i]);
                this.addChild(child);
                ++i;
            }
        }
    }

    @Override
    public void write(PrintWriter writer) {
        if (this.session != null) {
            writer.println(this.session.getSessionData());
        }
        writer.println(this.getSeverityText());
        if (this.fDate != null) {
            writer.println(this.getDate());
        }
        if (this.message != null) {
            writer.println(this.getMessage());
        }
        if (this.stack != null) {
            writer.println();
            writer.println(this.stack);
        }
    }
}

