/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;

public class CommonActionProviderUtils {
    private static final String SHOW_IN_QUICK_MENU_ID = "org.eclipse.ui.navigate.showInQuickMenu";

    public static ICommonViewerWorkbenchSite getCommonViewerWorkbenchSite(ICommonActionExtensionSite actionExtensionSite) {
        StructuredViewer v;
        ICommonViewerWorkbenchSite wsSite = null;
        ICommonViewerSite viewSite = actionExtensionSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite && (v = actionExtensionSite.getStructuredViewer()) instanceof CommonViewer) {
            wsSite = (ICommonViewerWorkbenchSite)viewSite;
        }
        return wsSite;
    }

    public static IStructuredSelection getSelection(ICommonActionExtensionSite actionExtensionSite) {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IStructuredSelection structuredSelection = null;
        ICommonViewerWorkbenchSite workbenchSite = CommonActionProviderUtils.getCommonViewerWorkbenchSite(actionExtensionSite);
        if (workbenchSite != null && (selectionProvider = workbenchSite.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
        }
        return structuredSelection;
    }

    public static boolean isServerSelected(IStructuredSelection selection) {
        return selection != null && selection.getFirstElement() instanceof IServer;
    }

    public static IContributionItem getShowInQuickMenu(IMenuManager menuManager) {
        return CommonActionProviderUtils.getShowInQuickMenu(menuManager, false);
    }

    public static IContributionItem getShowInQuickMenu(IMenuManager menuManager, boolean createShowInMenu) {
        IContributionItem item = null;
        if (menuManager != null && (item = menuManager.find(SHOW_IN_QUICK_MENU_ID)) == null && createShowInMenu) {
            String text = Messages.actionShowIn;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IBindingService bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
            TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor(SHOW_IN_QUICK_MENU_ID);
            if (activeBindings.length > 0) {
                text = String.valueOf(text) + "\t" + activeBindings[0].format();
            }
            item = new MenuManager(text, SHOW_IN_QUICK_MENU_ID);
            menuManager.insertAfter("org.eclipse.wst.server.ui.internal.cnf.topSectionEnd", item);
        }
        return item;
    }

    public static void addToShowInQuickSubMenu(IAction action, IMenuManager menu, ICommonActionExtensionSite actionSite) {
        IStructuredSelection selection = CommonActionProviderUtils.getSelection(actionSite);
        IContributionItem menuItem = CommonActionProviderUtils.getShowInQuickMenu(menu);
        if (menuItem instanceof MenuManager && CommonActionProviderUtils.isServerSelected(selection) && action != null) {
            ((MenuManager)menuItem).add(action);
        }
    }

    public static IWorkbenchPart getWorkbenchPart(String id) {
        IViewPart part = null;
        IWorkbenchPage page = CommonActionProviderUtils.getActiveWorkbenchPage();
        if (page != null) {
            part = page.findView(id);
        }
        return part;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage page = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            page = window.getActivePage();
        }
        return page;
    }

    public static IWorkbenchPart showView(String partId) throws PartInitException {
        IWorkbenchPart part = CommonActionProviderUtils.getWorkbenchPart(partId);
        if (part == null) {
            part = CommonActionProviderUtils.getActiveWorkbenchPage().showView(partId);
        }
        return part;
    }
}

