/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.wizards.CopyConfigurationDialog;
import org.jboss.ide.eclipse.as.ui.wizards.JBossConfigurationTableViewer;
import org.jboss.ide.eclipse.as.ui.wizards.composite.JBossJREComposite;
import org.jboss.ide.eclipse.as.ui.wizards.composite.JBossRuntimeHomeComposite;
import org.jboss.ide.eclipse.as.wtp.ui.composites.AbstractJREComposite;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;
import org.jboss.ide.eclipse.as.wtp.ui.wizard.RuntimeWizardFragment;
import org.osgi.service.prefs.BackingStoreException;

public class JBossRuntimeWizardFragment
extends RuntimeWizardFragment {
    protected Composite configComposite;
    protected Group configGroup;
    protected Label configDirLabel;
    protected Text configDirText;
    protected JBossConfigurationTableViewer configurations;
    protected Button configCopy;
    protected Button configBrowse;
    protected Button configDelete;
    protected String configDirTextVal;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        return super.createComposite(parent, handle);
    }

    protected IRuntime getRuntimeFromTaskModel() {
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        if (r == null) {
            r = (IRuntime)this.getTaskModel().getObject("custom_runtime");
        }
        return r;
    }

    protected JBossRuntimeHomeComposite createHomeCompositeWidget(Composite main) {
        return new JBossRuntimeHomeComposite(main, 0, this.handle, this.getTaskModel());
    }

    protected AbstractJREComposite createJRECompositeWidget(Composite main) {
        return new JBossJREComposite(main, 0, this.getTaskModel());
    }

    protected void saveRuntimeLocationInPreferences(IRuntime runtime) {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
        prefs.put("org.jboss.ide.eclipse.as.ui.preferences.runtime.last.type." + runtime.getRuntimeType().getId(), homeDir);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected void updateWizardHandle(Composite parent) {
        IRuntime r = this.getRuntimeFromTaskModel();
        this.handle.setTitle(Messages.rwf_JBossRuntime);
        String descript = r.getRuntimeType().getDescription();
        this.handle.setDescription(descript);
        this.handle.setImageDescriptor(this.getImageDescriptor());
        this.initiateHelp(parent);
    }

    protected ImageDescriptor getImageDescriptor() {
        String imageKey = "jbossLogo";
        return JBossServerUISharedImages.getImageDescriptor(imageKey);
    }

    protected void initiateHelp(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.ide.eclipse.as.doc.user.new_server_runtime");
    }

    protected void createWidgets(Composite main) {
        super.createWidgets(main);
        this.createConfigurationComposite(main);
    }

    protected void fillWidgets(IRuntime rt) {
        super.fillWidgets(rt);
        this.fillConfigWidgets(rt);
    }

    protected void fillConfigWidgets(IRuntime rt) {
        IJBossServerRuntime jbsrt = this.getRuntime();
        String dirText = jbsrt.getConfigLocation();
        this.configDirText.setText(this.isEmpty(dirText) ? "server" : dirText);
        this.configurations.setConfiguration(this.isEmpty(jbsrt.getJBossConfiguration()) ? "default" : jbsrt.getJBossConfiguration());
        this.configurations.getTable().setVisible(true);
    }

    protected void saveJreInRuntime(IRuntimeWorkingCopy wc) {
        IJBossServerRuntime srt = (IJBossServerRuntime)wc.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (srt != null) {
            IExecutionEnvironment selectedEnv = this.jreComposite.getSelectedExecutionEnvironment();
            IVMInstall selectedVM = this.jreComposite.getSelectedVM();
            srt.setVM(selectedVM);
            srt.setExecutionEnvironment(selectedEnv);
        }
    }

    protected String getExplanationText() {
        return Messages.rwf_Explanation;
    }

    protected void createConfigurationComposite(Composite main) {
        FormDataUtility u = new FormDataUtility();
        this.configComposite = new Composite(main, 0);
        this.configComposite.setLayoutData((Object)u.createFormData((Object)this.jreComposite, 10, (Object)100, -5, (Object)0, 5, (Object)100, -5));
        this.configComposite.setLayout((Layout)new FormLayout());
        this.configGroup = new Group(this.configComposite, -1);
        this.configGroup.setText(Messages.wf_ConfigLabel);
        this.configGroup.setLayoutData((Object)u.createFormData((Object)0, 0, (Object)100, 0, (Object)0, 0, (Object)100, 0));
        this.configGroup.setLayout((Layout)new FormLayout());
        this.configDirLabel = new Label((Composite)this.configGroup, 0);
        this.configDirLabel.setText(Messages.directory);
        this.configDirText = new Text((Composite)this.configGroup, 2048);
        this.configurations = new JBossConfigurationTableViewer((Composite)this.configGroup, 2052);
        IJBossServerRuntime srt = this.getRuntime();
        if (srt != null && !this.isEmpty(srt.getJBossConfiguration())) {
            this.configurations.setConfiguration(srt.getJBossConfiguration());
        }
        this.configBrowse = new Button((Composite)this.configGroup, -1);
        this.configCopy = new Button((Composite)this.configGroup, -1);
        this.configDelete = new Button((Composite)this.configGroup, -1);
        this.configBrowse.setText(Messages.browse);
        this.configCopy.setText(Messages.copy);
        this.configDelete.setText(Messages.delete);
        this.configDirLabel.setLayoutData((Object)u.createFormData((Object)2, 5, null, 0, (Object)0, 5, null, 0));
        this.configDirText.setLayoutData((Object)u.createFormData((Object)0, 5, null, 0, (Object)this.configDirLabel, 5, (Object)this.configBrowse, -5));
        this.configBrowse.setLayoutData((Object)u.createFormData((Object)0, 5, null, 0, (Object)this.configurations.getTable(), 5, (Object)100, -5));
        this.configurations.getTable().setLayoutData((Object)u.createFormData((Object)this.configDirText, 5, (Object)100, -5, (Object)0, 5, (Object)80, 0));
        this.configCopy.setLayoutData((Object)u.createFormData((Object)this.configBrowse, 5, null, 0, (Object)this.configurations.getTable(), 5, (Object)100, -5));
        this.configDelete.setLayoutData((Object)u.createFormData((Object)this.configCopy, 5, null, 0, (Object)this.configurations.getTable(), 5, (Object)100, -5));
        this.configDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossRuntimeWizardFragment.this.updatePage();
            }
        });
        this.configBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.configBrowsePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.configCopy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.configCopyPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.configDelete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.configDeletePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.configurations.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JBossRuntimeWizardFragment.this.updateErrorMessage();
                JBossRuntimeWizardFragment.this.configDelete.setEnabled(!((IStructuredSelection)JBossRuntimeWizardFragment.this.configurations.getSelection()).isEmpty());
                JBossRuntimeWizardFragment.this.configCopy.setEnabled(!((IStructuredSelection)JBossRuntimeWizardFragment.this.configurations.getSelection()).isEmpty());
            }
        });
    }

    protected void configBrowsePressed() {
        File directory;
        String homeDir = this.homeDirComposite.getHomeDirectory();
        String folder = new Path(this.configDirText.getText()).isAbsolute() ? this.configDirText.getText() : new Path(homeDir).append(this.configDirText.getText()).toString();
        File file = new File(folder);
        if (!file.exists()) {
            file = null;
        }
        if ((directory = JBossRuntimeWizardFragment.getDirectory((File)file, (Shell)this.homeDirComposite.getShell())) != null) {
            if (directory.getAbsolutePath().startsWith(new Path(homeDir).toString())) {
                String result = directory.getAbsolutePath().substring(homeDir.length());
                this.configDirText.setText(new Path(result).makeRelative().toString());
            } else {
                this.configDirText.setText(directory.getAbsolutePath());
            }
        }
    }

    protected void configCopyPressed() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        CopyConfigurationDialog d = new CopyConfigurationDialog(this.configCopy.getShell(), homeDir, this.configDirText.getText(), this.configurations.getCurrentlySelectedConfiguration());
        if (d.open() == 0) {
            Path source = new Path(this.configDirText.getText());
            if (!source.isAbsolute()) {
                source = new Path(homeDir).append((IPath)source);
            }
            source = source.append(this.configurations.getCurrentlySelectedConfiguration());
            Path dest = new Path(d.getNewDest());
            if (!dest.isAbsolute()) {
                dest = new Path(homeDir).append((IPath)dest);
            }
            dest = dest.append(d.getNewConfig());
            dest.toFile().mkdirs();
            FileUtil.copyDir((File)source.toFile(), (File)dest.toFile());
            this.configDirText.setText(d.getNewDest());
            this.configurations.setSelection((ISelection)new StructuredSelection((Object)d.getNewConfig()));
        }
    }

    protected void configDeletePressed() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        MessageDialog dialog = new MessageDialog(this.configBrowse.getShell(), Messages.JBossRuntimeWizardFragment_DeleteConfigTitle, null, Messages.JBossRuntimeWizardFragment_DeleteConfigConfirmation, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (dialog.open() == 0) {
            String config = this.configurations.getCurrentlySelectedConfiguration();
            String configDir = this.configDirText.getText();
            File folder = !new Path(configDir).isAbsolute() ? new Path(homeDir).append(configDir).append(config).toFile() : new Path(configDir).append(config).toFile();
            FileUtil.completeDelete((File)folder);
            this.configurations.refresh();
            this.updatePage();
        }
    }

    protected void updateDependentWidgets() {
        String folder;
        super.updateDependentWidgets();
        String homeDir = this.homeDirComposite.getHomeDirectory();
        if (!this.homeDirComposite.isHomeValid()) {
            this.configurations.getControl().setEnabled(false);
            folder = homeDir;
        } else {
            Path p = new Path(this.configDirText.getText());
            folder = p.isAbsolute() ? p.toString() : new Path(homeDir).append((IPath)p).toString();
        }
        this.configurations.setFolder(folder);
        if (folder != null) {
            File f = new File(folder);
            this.configurations.getControl().setEnabled(f.exists() && f.isDirectory());
            this.configDirTextVal = this.configDirText.getText();
        }
    }

    protected String getErrorString() {
        String sup = super.getErrorString();
        if (sup == null && this.configurations.getSelection().isEmpty()) {
            return Messages.JBossRuntimeWizardFragment_MustSelectValidConfig;
        }
        return sup;
    }

    protected String getHomeVersionWarning() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        File loc = new File(homeDir);
        String serverId = new ServerBeanLoader(loc).getServerAdapterId();
        String rtId = serverId == null ? null : RuntimeUtils.getRuntimeTypeId((IServerType)ServerCore.findServerType((String)serverId));
        IRuntime adapterRt = this.getRuntimeFromTaskModel();
        String adapterRuntimeId = adapterRt.getRuntimeType().getId();
        if (!adapterRuntimeId.equals(rtId)) {
            return NLS.bind((String)Messages.rwf_homeIncorrectVersionError, (Object)adapterRt.getRuntimeType().getVersion(), (Object)this.getVersionString(loc));
        }
        return null;
    }

    protected void saveDetailsInRuntime(IRuntimeWorkingCopy wc) {
        super.saveDetailsInRuntime(wc);
        this.saveConfigurationDetailsInRuntime(wc);
    }

    protected void saveConfigurationDetailsInRuntime(IRuntimeWorkingCopy wc) {
        IJBossServerRuntime srt = (IJBossServerRuntime)wc.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (this.configurations != null && this.configurations.getSelectedConfiguration() != null) {
            srt.setJBossConfiguration(this.configurations.getSelectedConfiguration());
        }
        if (this.configDirText != null) {
            srt.setConfigLocation(this.configDirTextVal);
        }
    }

    protected IJBossServerRuntime getRuntime() {
        IRuntime r = this.getRuntimeFromTaskModel();
        IJBossServerRuntime ajbsrt = null;
        if (r != null) {
            ajbsrt = (IJBossServerRuntime)r.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return ajbsrt;
    }
}

