/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.ui.wizards.ServerProfileWizardFragment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;

public class LayeredProductServerWizardFragment
extends ServerProfileWizardFragment {
    private RuntimeDetailsComposite rtDetails;

    @Override
    protected ServerProfileWizardFragment.IProfileComposite createProfileSection(Composite main) {
        LayeredProfileComposite pc = new LayeredProfileComposite(main, 0, this);
        GridData gd = new GridData();
        gd.widthHint = 500;
        pc.setLayoutData(gd);
        return pc;
    }

    @Override
    protected void addRuntimeDetailsGroup(Composite parent) {
        Group g = new Group(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 500;
        g.setLayoutData((Object)gd);
        g.setLayout((Layout)new GridLayout(1, true));
        this.rtDetails = new RuntimeDetailsComposite((Composite)g, 0);
        g.setText("Runtime Details");
    }

    @Override
    protected void runtimeComboChanged() {
        super.runtimeComboChanged();
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        if (this.rtDetails != null && !this.rtDetails.isDisposed()) {
            this.rtDetails.update(rt);
        }
    }

    private static class LayeredProfileComposite
    extends Composite
    implements ServerProfileWizardFragment.IProfileComposite {
        private ServerProfileModel.ServerProfile[] profiles;
        private ServerProfileWizardFragment profileFragment;
        private Button localButton;
        private Button remoteButton;
        private Button fsButton;
        private Button mgmtButton;

        LayeredProfileComposite(Composite parent, int style, final ServerProfileWizardFragment profileFragment) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(2, false));
            this.profileFragment = profileFragment;
            this.initProfiles();
            Label localOrRemote = new Label((Composite)this, 0);
            GridData lorData = new GridData();
            lorData.verticalAlignment = 1;
            localOrRemote.setLayoutData((Object)lorData);
            localOrRemote.setText("The server is: ");
            Composite localOrRemoteComposite = new Composite((Composite)this, 0);
            localOrRemoteComposite.setLayout((Layout)new GridLayout(1, true));
            this.localButton = new Button(localOrRemoteComposite, 16);
            this.remoteButton = new Button(localOrRemoteComposite, 16);
            this.localButton.setText("Local");
            this.remoteButton.setText("Remote");
            Label control = new Label((Composite)this, 0);
            control.setText("Controlled by: ");
            control.setLayoutData((Object)lorData);
            Composite fsOrMgmtComposite = new Composite((Composite)this, 0);
            fsOrMgmtComposite.setLayout((Layout)new GridLayout(1, true));
            this.fsButton = new Button(fsOrMgmtComposite, 16);
            this.mgmtButton = new Button(fsOrMgmtComposite, 16);
            this.fsButton.setText("Filesystem and shell operations");
            this.mgmtButton.setText("Management Operations");
            IServerAttributes server = (IServerAttributes)profileFragment.getTaskModel().getObject("server");
            String currentProfile = ServerProfileModel.getProfile((IServerAttributes)server, (String)"local");
            this.setSelectionsForProfile(currentProfile);
            SelectionAdapter sl = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    profileFragment.setProfile(LayeredProfileComposite.this.getSelectedProfile());
                }
            };
            this.localButton.addSelectionListener((SelectionListener)sl);
            this.remoteButton.addSelectionListener((SelectionListener)sl);
            this.fsButton.addSelectionListener((SelectionListener)sl);
            this.mgmtButton.addSelectionListener((SelectionListener)sl);
        }

        private void setSelectionsForProfile(String currentProfile) {
            if (currentProfile == null) {
                this.localButton.setSelection(true);
                this.fsButton.setSelection(true);
            } else {
                boolean rse = currentProfile.equals("rse") || currentProfile.startsWith("rse.");
                boolean mgmt = currentProfile.endsWith(".mgmt");
                this.localButton.setSelection(!rse);
                this.remoteButton.setSelection(rse);
                this.fsButton.setSelection(!mgmt);
                this.mgmtButton.setSelection(mgmt);
            }
        }

        @Override
        public ServerProfileModel.ServerProfile getSelectedProfile() {
            String profile;
            boolean local = this.localButton.getSelection();
            boolean mgmt = this.mgmtButton.getSelection();
            String string = profile = local ? "local" : "rse";
            if (mgmt) {
                profile = String.valueOf(profile) + ".mgmt";
            }
            int i = 0;
            while (i < this.profiles.length) {
                if (this.profiles[i].getId().equals(profile)) {
                    return this.profiles[i];
                }
                ++i;
            }
            return null;
        }

        protected void initProfiles() {
            IServerAttributes server = (IServerAttributes)this.profileFragment.getTaskModel().getObject("server");
            String serverType = server.getServerType().getId();
            ServerProfileModel.ServerProfile[] tmpProfiles = ServerProfileModel.getDefault().getProfiles(serverType);
            ArrayList<ServerProfileModel.ServerProfile> tmpProfileList = new ArrayList<ServerProfileModel.ServerProfile>(Arrays.asList(tmpProfiles));
            Collections.sort(tmpProfileList, new Comparator<ServerProfileModel.ServerProfile>(){

                @Override
                public int compare(ServerProfileModel.ServerProfile arg0, ServerProfileModel.ServerProfile arg1) {
                    String n1 = arg0.getVisibleName() == null ? arg0.getId() : arg0.getVisibleName();
                    String n2 = arg1.getVisibleName() == null ? arg1.getId() : arg1.getVisibleName();
                    return n1.compareTo(n2);
                }
            });
            this.profiles = tmpProfileList.toArray(new ServerProfileModel.ServerProfile[tmpProfileList.size()]);
        }
    }

    private class RuntimeDetailsComposite
    extends Composite {
        private Label jreVal;
        private Label homedirVal;
        private Label basedirVal;
        private Label configVal;

        RuntimeDetailsComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(2, false));
            Label jre = new Label((Composite)this, 0);
            jre.setText("JRE: ");
            this.jreVal = new Label((Composite)this, 0);
            Label homedir = new Label((Composite)this, 0);
            homedir.setText("Home Directory: ");
            this.homedirVal = new Label((Composite)this, 0);
            Label basedir = new Label((Composite)this, 0);
            basedir.setText("Base Directory: ");
            this.basedirVal = new Label((Composite)this, 0);
            Label config = new Label((Composite)this, 0);
            config.setText("Configuration File: ");
            this.configVal = new Label((Composite)this, 0);
        }

        public void update(IRuntime rt) {
            LocalJBoss7ServerRuntime jbsrt;
            LocalJBoss7ServerRuntime localJBoss7ServerRuntime = jbsrt = rt == null ? null : (LocalJBoss7ServerRuntime)rt.loadAdapter(LocalJBoss7ServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            if (!this.jreVal.isDisposed()) {
                if (jbsrt != null) {
                    this.jreVal.setText(jbsrt.getVM().getInstallLocation().getAbsolutePath());
                    this.homedirVal.setText(rt.getLocation().toOSString());
                    this.basedirVal.setText(jbsrt.getRawBaseDirectory());
                    this.configVal.setText(jbsrt.getConfigurationFile());
                } else {
                    this.jreVal.setText("");
                    this.homedirVal.setText("");
                    this.basedirVal.setText("");
                    this.configVal.setText("");
                }
            }
        }
    }
}

