/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.test;

import junit.framework.TestCase;
import org.jboss.tools.jmx.core.MBeanUtils;

public class MBeanUtilsTestCase
extends TestCase {
    public void testNullValue() throws Exception {
        MBeanUtilsTestCase.assertNull((Object)MBeanUtils.getValue(null, (String)"whatever"));
        MBeanUtilsTestCase.assertNull((Object)MBeanUtils.getValue((String)"whatever", null));
        MBeanUtilsTestCase.assertNull((Object)MBeanUtils.getValue(null, null));
    }

    public void testNonPrimitiveType() throws Exception {
        String value = "any value";
        MBeanUtilsTestCase.assertEquals((Object)value, (Object)MBeanUtils.getValue((String)value, (String)"java.util.Vector"));
    }

    public void testBooleanValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)Boolean.TRUE, (Object)MBeanUtils.getValue((String)"true", (String)"boolean"));
        MBeanUtilsTestCase.assertEquals((Object)Boolean.FALSE, (Object)MBeanUtils.getValue((String)"false", (String)"boolean"));
        MBeanUtilsTestCase.assertEquals((Object)Boolean.FALSE, (Object)MBeanUtils.getValue((String)"whatever", (String)"boolean"));
    }

    public void testByteValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)0, (Object)MBeanUtils.getValue((String)"0", (String)"byte"));
        MBeanUtilsTestCase.assertEquals((Object)1, (Object)MBeanUtils.getValue((String)"1", (String)"byte"));
        try {
            MBeanUtils.getValue((String)"whatever", (String)"byte");
            MBeanUtilsTestCase.fail();
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void testCharValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)Character.valueOf('a'), (Object)MBeanUtils.getValue((String)"a", (String)"char"));
        MBeanUtilsTestCase.assertEquals((Object)Character.valueOf('o'), (Object)MBeanUtils.getValue((String)"only take the first char", (String)"char"));
    }

    public void testShortValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)1, (Object)MBeanUtils.getValue((String)"1", (String)"short"));
        try {
            MBeanUtils.getValue((String)"not a short", (String)"short");
            MBeanUtilsTestCase.fail();
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void testIntValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)1, (Object)MBeanUtils.getValue((String)"1", (String)"int"));
        try {
            MBeanUtils.getValue((String)"not a int", (String)"int");
            MBeanUtilsTestCase.fail();
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void testLongValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)1L, (Object)MBeanUtils.getValue((String)"1", (String)"long"));
        try {
            MBeanUtils.getValue((String)"not a long", (String)"long");
            MBeanUtilsTestCase.fail();
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void testFloatValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)Float.valueOf(1.0f), (Object)MBeanUtils.getValue((String)"1", (String)"float"));
        try {
            MBeanUtils.getValue((String)"not a float", (String)"float");
            MBeanUtilsTestCase.fail();
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void testDoubleValue() throws Exception {
        MBeanUtilsTestCase.assertEquals((Object)1.0, (Object)MBeanUtils.getValue((String)"1", (String)"double"));
        try {
            MBeanUtils.getValue((String)"not a double", (String)"double");
            MBeanUtilsTestCase.fail();
        }
        catch (NumberFormatException numberFormatException) {}
    }
}

