/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.management.core;

import java.util.regex.Pattern;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ide.eclipse.as.management.core.OperationFormatException;

public abstract class ValidatingOperationCallbackHandler
implements CallbackHandler {
    private static final Pattern ALPHANUMERICS_PATTERN = Pattern.compile("[_a-zA-Z](?:[-_a-zA-Z0-9]*[_a-zA-Z0-9])?");
    private static final Pattern NODE_NAME_PATTERN = Pattern.compile("\\*|[^*\\p{Space}\\p{Cntrl}]+");
    protected String operationStr;

    public void start(String operationString) {
        this.operationStr = operationString;
    }

    public void nodeType(String nodeType) throws OperationFormatException {
        this.assertValidType(nodeType);
        this.validatedNodeType(nodeType);
    }

    protected abstract void validatedNodeType(String var1) throws OperationFormatException;

    public void nodeName(String nodeName) throws OperationFormatException {
        this.assertValidNodeName(nodeName);
        this.validatedNodeName(nodeName);
    }

    protected abstract void validatedNodeName(String var1) throws OperationFormatException;

    public void operationName(String operationName) throws OperationFormatException {
        if (operationName == null || !ALPHANUMERICS_PATTERN.matcher(operationName).matches()) {
            throw new OperationFormatException("'" + operationName + "' is not a valid operation name.");
        }
        this.validatedOperationName(operationName);
    }

    protected abstract void validatedOperationName(String var1) throws OperationFormatException;

    public void propertyName(String propertyName) throws OperationFormatException {
        this.assertValidParameterName(propertyName);
        this.validatedPropertyName(propertyName);
    }

    protected abstract void validatedPropertyName(String var1) throws OperationFormatException;

    public void property(String name, String value, int nameValueSeparatorIndex) throws OperationFormatException {
        this.assertValidParameterName(name);
        if (value.isEmpty()) {
            throw new OperationFormatException("Parameter '" + value + "' is missing value.");
        }
        this.validatedProperty(name, value, nameValueSeparatorIndex);
    }

    protected abstract void validatedProperty(String var1, String var2, int var3) throws OperationFormatException;

    protected void assertValidType(String nodeType) throws OperationFormatException {
        if (nodeType == null || !ALPHANUMERICS_PATTERN.matcher(nodeType).matches()) {
            throw new OperationFormatException("'" + nodeType + "' is not a valid node type name.");
        }
    }

    protected void assertValidNodeName(String nodeName) throws OperationFormatException {
        if (nodeName == null || !NODE_NAME_PATTERN.matcher(nodeName).matches()) {
            throw new OperationFormatException("'" + nodeName + "' is not a valid node name.");
        }
    }

    protected void assertValidParameterName(String name) throws OperationFormatException {
        if (name == null || !ALPHANUMERICS_PATTERN.matcher(name).matches()) {
            throw new OperationFormatException("'" + name + "' is not a valid parameter name.");
        }
    }
}

