/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.ui.ejb3;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.actions.NewServerAction;
import org.jboss.ide.eclipse.as.classpath.ui.Messages;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class JBossSelectionPage
extends WizardPage {
    protected TableViewer servers;
    protected JBossServer jbossServer;
    protected Button newServer;

    public JBossSelectionPage() {
        super(Messages.JBossSelectionPage_Name);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        Composite configurationComposite = new Composite(main, 0);
        configurationComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        configurationComposite.setLayout((Layout)new FillLayout());
        this.servers = new TableViewer(configurationComposite);
        this.servers.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.servers.setLabelProvider((IBaseLabelProvider)ServerUICore.getLabelProvider());
        this.servers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JBossSelectionPage.this.serverSelected();
            }
        });
        this.refreshConfigurations();
        Composite links = new Composite(main, 0);
        links.setLayout((Layout)new RowLayout());
        this.newServer = new Button(links, 0);
        this.newServer.setText(Messages.JBossSelectionPage_ButtonText);
        this.newServer.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                JBossSelectionPage.this.createJBossServer();
            }
        });
        this.setControl((Control)main);
    }

    private void refreshConfigurations() {
        this.servers.setInput((Object)ServerConverter.getJBossServersAsIServers());
    }

    private void createJBossServer() {
        NewServerAction action = new NewServerAction();
        action.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        action.run(null);
        this.refreshConfigurations();
    }

    protected void serverSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.servers.getSelection();
        IServer server = (IServer)selection.getFirstElement();
        this.jbossServer = (JBossServer)server.getAdapter(JBossServer.class);
        this.getWizard().getContainer().updateButtons();
    }

    public JBossServer getServer() {
        return this.jbossServer;
    }
}

