/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.editors;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.jmx.core.MBeanAttributeInfoWrapper;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.internal.tables.MBeanAttributesTable;

public class AttributesSection
extends SectionPart {
    private MBeanAttributesTable attributesTable;

    public AttributesSection(MBeanInfoWrapper wrapper, final IManagedForm managedForm, Composite parent) {
        super(parent, managedForm.getToolkit(), 256);
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = this.getSection();
        section.marginWidth = 10;
        section.marginHeight = 5;
        section.setText(Messages.AttributesSection_title);
        Composite container = toolkit.createComposite((Composite)section, 64);
        section.setClient((Control)container);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        this.attributesTable = new MBeanAttributesTable(container, toolkit);
        this.attributesTable.setInput(wrapper);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.attributesTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
    }

    public Viewer getTableViewer() {
        return this.attributesTable.getViewer();
    }

    public void refresh() {
        super.refresh();
        this.attributesTable.getViewer().refresh();
    }

    public boolean setFormInput(Object input) {
        if (input instanceof MBeanAttributeInfoWrapper) {
            MBeanAttributeInfoWrapper wrapper = (MBeanAttributeInfoWrapper)input;
            StructuredSelection selection = new StructuredSelection((Object)wrapper);
            this.attributesTable.getViewer().setSelection((ISelection)selection, true);
            return true;
        }
        return false;
    }
}

