/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.core.MBeanNotificationInfoWrapper;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.internal.editors.MBeanEditorInput;

public class InfoPage
extends FormPage {
    static final String ID = "info";
    private MBeanInfoWrapper wrapper;
    private Font bold;

    public InfoPage(FormEditor editor) {
        super(editor, ID, Messages.InfoPage_title);
        MBeanEditorInput input = (MBeanEditorInput)editor.getEditorInput();
        this.wrapper = input.getWrapper();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(this.wrapper.getObjectName().toString());
        FormToolkit toolkit = managedForm.getToolkit();
        form.getForm().setSeparatorVisible(true);
        Composite body = form.getBody();
        FontData[] fd = body.getFont().getFontData();
        this.bold = new Font((Device)body.getDisplay(), fd[0].getName(), fd[0].getHeight(), 1);
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        GridDataFactory defaultGridData = GridDataFactory.fillDefaults();
        String className = this.wrapper.getMBeanInfo().getClassName();
        toolkit.createLabel(body, Messages.className);
        Label classNameLabel = toolkit.createLabel(body, className, 72);
        classNameLabel.setFont(this.bold);
        classNameLabel.setLayoutData((Object)defaultGridData.create());
        String description = this.wrapper.getMBeanInfo().getDescription();
        toolkit.createLabel(body, Messages.description);
        Text descriptionText = toolkit.createText(body, description, 74);
        descriptionText.setLayoutData((Object)defaultGridData.create());
        Section notifSection = toolkit.createSection(body, 258);
        notifSection.setText(Messages.InfoPage_notificationsSectionTitle);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)notifSection);
        if (this.wrapper.getMBeanNotificationInfoWrappers().length == 0) {
            notifSection.setEnabled(false);
            notifSection.setExpanded(false);
        } else {
            notifSection.setEnabled(true);
            notifSection.setExpanded(true);
        }
        Composite notificationContainer = toolkit.createComposite((Composite)notifSection);
        notifSection.setClient((Control)notificationContainer);
        GridLayoutFactory.fillDefaults().generateLayout(notificationContainer);
        Tree notificationTree = toolkit.createTree(notificationContainer, 2048);
        GridDataFactory.fillDefaults().hint(500, 150).applyTo((Control)notificationTree);
        TreeViewer notificationViewer = new TreeViewer(notificationTree);
        notificationViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof MBeanNotificationInfoWrapper) {
                    MBeanNotificationInfoWrapper notifWrapper = (MBeanNotificationInfoWrapper)element;
                    return notifWrapper.getMBeanNotificationInfo().getName();
                }
                return super.getText(element);
            }
        });
        notificationViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parent) {
                if (parent instanceof MBeanNotificationInfoWrapper) {
                    MBeanNotificationInfoWrapper notifWrapper = (MBeanNotificationInfoWrapper)parent;
                    return notifWrapper.getMBeanNotificationInfo().getNotifTypes();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof MBeanNotificationInfoWrapper) {
                    MBeanNotificationInfoWrapper notifWrapper = (MBeanNotificationInfoWrapper)element;
                    return notifWrapper.getMBeanNotificationInfo().getNotifTypes().length > 0;
                }
                return false;
            }

            public Object[] getElements(Object input) {
                return ((MBeanInfoWrapper)input).getMBeanNotificationInfoWrappers();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        notificationViewer.setInput((Object)this.wrapper);
    }

    public void dispose() {
        super.dispose();
        if (this.bold != null) {
            this.bold.dispose();
        }
    }
}

